package map.route;


import map.data.MapMap;
import map.data.Node;

/**
 * Unidirectional Search algorithm
 * ヒューリスティック関数を設定すればA*アルゴリズム
 * 設定しなければDijkstraのアルゴリズムにより最短経路を求める。
 * @author Masayasu FUJIWARA
 */
public class ShortestPathSearch implements ShortestPathAlgorithm {
	
	
	/**
	 * Heuristic関数
	 */
	private final HeuristicEstimate heuristic;
	
	/**
	 * 地図データ
	 */
	private final MapMap maps;


	/**
	 * A* algorithm
	 * @param heuristic ヒューリステック関数
	 * @param maps 地図データ
	 */
	public ShortestPathSearch(HeuristicEstimate heuristic, MapMap maps) {
		this.heuristic = heuristic;
		this.maps = maps;
	}

	/**
	 * 単方向探索によって最短経路探索を行う．
	 */
	public SearchThread search(final Node start, final Node terminal) {
		this.maps.dump();
		HeapMap heap;
		if (this.heuristic == null) {
			heap = new HeapMap();
		} else {
			heap = new HeapMap(new HeuristicComparator(this.heuristic, terminal));
		}
		return new SearchThread(start, terminal, this.maps, heap);
	}
	@Override
	public String toString() {
		if (this.heuristic == null) {
			return "Dijkstra";
		} else {
			return "A* / "+ this.heuristic.toString();
		}
	}
}