package util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
/**
 * ディスク上にデータ構造を作る二分探索木
 * @author fujiwara
 *
 */
public class DiscTreeMap {
	public static Collection<File> list = new HashSet<File>();
	public static void main(String[] args) throws IOException {
		DiscTreeMap disc = new DiscTreeMap();
		Set<Integer> set = new HashSet<Integer>();
		for(int j = 0; j < 10; j++) {
			for(int i = 0; i < 1000; i++) {
				int value = (int)(10000 * Math.random());
				System.out.print("add("+value+")");
				if(disc.put(value, value) != set.add(value)) {
					System.out.println(" oper error");
					System.exit(1);
				}else if(disc.size() != set.size()){
					System.out.println(" size error");
					System.exit(1);
				}else{
					System.out.println();
				}
			}
			for(int i = 0; i < 1000; i++) {
				int value = (int)(10000 * Math.random());
				System.out.print("contains("+value+")");
				if(disc.containsKey(value) != set.contains(value)) {
					System.out.println(" oper error");
					System.exit(1);
				}else if(disc.size() != set.size()){
					System.out.println(" size error");
					System.exit(1);
				}else{
					System.out.println();
				}
			}
		}
		System.out.println("size "+disc.size());
	}
	private File tmp;
	private int size;
	/**
	 * [long:8][double:8][Integer:4][Integer:4]
	 */
	private int datasize = 8 + 8 + 4 + 4;
	/**
	 * コンストラクタ
	 * @throws IOException
	 */
	public DiscTreeMap() throws IOException {
		do{
			this.tmp = new File((int)(1000 * Math.random())+"dtl.mem");
		} while(DiscTreeMap.list.contains(this.tmp));
		this.tmp.deleteOnExit();
		DiscTreeMap.list.add(this.tmp);
		RandomAccessFile disc = new RandomAccessFile(this.tmp, "rw");
		disc.setLength(0);
		disc.close();
		this.size = 0;
	}
	/**
	 * 指定された要素がセットの要素として存在しない場合に、その要素をセットに追加します。
	 * @param data
	 * @throws IOException
	 */
	public boolean put(long k, double v) throws IOException {
		RandomAccessFile disc = new RandomAccessFile(this.tmp, "rw");
		int index = 0;
		if (this.size > 0) {
			while(true) {
				long key = disc.readLong();
				if(key == k) {
					disc.writeDouble(v);
					disc.close();
					break;
				}else{
					disc.readDouble();
					int leftson  = disc.readInt();
					int rightson = disc.readInt();
					if(key < k){
						if(rightson == 0) {
							disc.seek(index * this.datasize + 20);
							disc.writeInt(this.size);
							break;
						}
						index = rightson;
					}else{
						if(leftson == 0) {
							disc.seek(index * this.datasize + 16);
							disc.writeInt(this.size);
							break;
						}
						index = leftson;
					}
					disc.seek(index * this.datasize);
				}
			}
		}
		int tmp = this.size++ * this.datasize;
		System.out.println(tmp + " < "+ disc.length());
		disc.seek(tmp);
		// key
		disc.writeLong(k);
		// value
		disc.writeDouble(v);
		// leftson
		disc.writeInt(0);
		// rightson
		disc.writeInt(0);
		disc.close();
		return true;
	}
	/**
	 * セットが、指定された要素を保持している場合に true を返します。
	 * @param data - このセットにあるかどうかを判定するオブジェクト
	 * @return セットが、指定された要素を保持している場合は true
	 * @throws IOException
	 */
	public boolean containsKey(long k) throws IOException {
		if (this.size == 0) {
			return false;
		}
		RandomAccessFile disc = new RandomAccessFile(this.tmp, "r");
		while (true) {
			long key = disc.readLong();
			disc.readDouble();
			if (key == k) {
				disc.close();
				return true;
			} else {
				int leftson = disc.readInt();
				int rightson = disc.readInt();
				if (key < k) {
					if(rightson == 0) {
						break;
					}
					disc.seek(rightson * this.datasize);
				}else{
					if(leftson == 0) {
						break;
					}
					disc.seek(leftson * this.datasize);
				}
			}
		}
		disc.close();
		return false;
	}
	/**
	 * マップが指定されたキーをマップする値を返します。
	 * マップがこのキーのマッピングを保持していない場合は Double.NaN を返します。
	 * 戻り値の Double.NaN は、マップがキーのマッピングを保持していないことを示すとは限りません。
	 * つまり、マップが明示的にキーを Double.NaN にマップすることもあります。
	 * containsKey オペレーションを使うと、こうした 2 つの場合を見分けることができます。
	 * @param k - 関連付けられた値が返されるキー
	 * @return マップが、指定されたキーにマッピングしている値。このキーに対するマッピングがマップにない場合は Double.NaN
	 * @throws IOException
	 */
	public double get(long k) throws IOException {
		if (this.size == 0) {
			return Double.NaN;
		}
		RandomAccessFile disc = new RandomAccessFile(this.tmp, "r");
		while (true) {
			long key = disc.readLong();
			double value = disc.readDouble();
			if (key == k) {
				disc.close();
				return value;
			} else {
				int leftson = disc.readInt();
				int rightson = disc.readInt();
				if (key < k) {
					if(rightson == 0) {
						break;
					}
					disc.seek(rightson * this.datasize);
				}else{
					if(leftson == 0) {
						break;
					}
					disc.seek(leftson * this.datasize);
				}
			}
		}
		disc.close();
		return Double.NaN;
	}
	/**
	 * リスト内の要素数を返します。
	 * @return リスト内の要素数
	 */
	public int size() {
		return this.size;
	}
	/**
	 * マップからすべての要素を削除します。
	 * @throws IOException
	 */
	public void clear() throws IOException {
		RandomAccessFile disc = new RandomAccessFile(this.tmp, "rw");
		disc.setLength(0);
		disc.close();
		this.size = 0;
	}
	/**
	 * インスタンス破棄時の処理
	 */
	@Override
	protected void finalize() throws Throwable {
		DiscTreeMap.list.remove(this.tmp);
		super.finalize();
	}
}
