/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.gcat.scalc;

import jp.jasminesoft.gcat.scalc.Coordinate;
import jp.jasminesoft.gcat.scalc.Dms;
import jp.jasminesoft.gcat.scalc.LatLong;
import jp.jasminesoft.gcat.scalc.Phi;

public class XY2LatLong {
    private double x;
    private double y;
    private int kei;
    private double gentenB;
    private double gentenL;
    private Dms lat;
    private Dms lng;

    public XY2LatLong(int kei) {
        Coordinate coord = new Coordinate(kei);
        this.gentenB = coord.radianGB();
        this.gentenL = coord.angleGL();
    }

    public int getKei() {
        return this.kei;
    }

    public void setX(double x) {
        this.reset();
        this.x = x;
    }

    public void setY(double y) {
        this.reset();
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getLatitude() {
        if (this.lat == null) {
            this.calc();
        }
        return this.lat.getValue();
    }

    public String getDMSLatitude() {
        if (this.lat == null) {
            this.calc();
        }
        return this.lat.getDMSValue();
    }

    public double getLongitude() {
        if (this.lng == null) {
            this.calc();
        }
        return this.lng.getValue();
    }

    public String getDMSLongitude() {
        if (this.lat == null) {
            this.calc();
        }
        return this.lng.getDMSValue();
    }

    public void reset() {
        this.lng = null;
        this.lat = null;
    }

    private void calc() {
        Phi p = new Phi(this.gentenB, this.x);
        double phi = p.getPhi();
        LatLong llcnv = new LatLong(this.y, phi, this.gentenL);
        this.lat = new Dms(llcnv.getB());
        this.lng = new Dms(llcnv.getL());
    }

    public static void main(String[] argv) {
        int x = 0;
        int y = 0;
        if (argv.length >= 2) {
            x = Integer.parseInt(argv[0]);
            y = Integer.parseInt(argv[1]);
        }
        System.out.println("X:" + x + ", Y:" + y);
        int i = 1;
        while (i <= 19) {
            XY2LatLong conv = new XY2LatLong(i);
            conv.setX(x);
            conv.setY(y);
            System.out.println("Kei:" + i + ",lat:" + conv.getDMSLatitude() + "(" + conv.getLatitude() + "),lng:" + conv.getDMSLongitude() + "(" + conv.getLongitude() + ")");
            ++i;
        }
    }
}

