/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.xmlcat;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class MBR
implements Serializable {
    static final long serialVersionUID = -5295278249650569180L;
    private float x1 = Float.POSITIVE_INFINITY;
    private float y1 = Float.POSITIVE_INFINITY;
    private float x2 = 0.0f;
    private float y2 = 0.0f;

    public MBR() {
    }

    public MBR(float x1, float y1, float x2, float y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.rearrange();
    }

    public MBR(String str) {
        StringTokenizer st = new StringTokenizer(str);
        try {
            this.x1 = Float.parseFloat(st.nextToken());
            this.y1 = Float.parseFloat(st.nextToken());
            this.x2 = Float.parseFloat(st.nextToken());
            this.y2 = Float.parseFloat(st.nextToken());
        }
        catch (NoSuchElementException e) {
            this.x1 = Float.POSITIVE_INFINITY;
            this.y1 = Float.POSITIVE_INFINITY;
            this.x2 = 0.0f;
            this.y2 = 0.0f;
        }
        this.rearrange();
    }

    private void rearrange() {
        float tmp;
        if (this.x1 > this.x2) {
            tmp = this.x1;
            this.x1 = this.x2;
            this.x2 = tmp;
        }
        if (this.y1 > this.y2) {
            tmp = this.y1;
            this.y1 = this.y2;
            this.y2 = tmp;
        }
    }

    public float getSX() {
        return this.x1;
    }

    public float getSY() {
        return this.y1;
    }

    public float getEX() {
        return this.x2;
    }

    public float getEY() {
        return this.y2;
    }

    public void merge(MBR mbr) {
        if (mbr == null) {
            return;
        }
        float sx = mbr.getSX();
        float sy = mbr.getSY();
        float ex = mbr.getEX();
        float ey = mbr.getEY();
        this.merge(sx, sy, ex, ey);
    }

    public void merge(float sx, float sy, float ex, float ey) {
        if (sx < this.x1) {
            this.x1 = sx;
        }
        if (sy < this.y1) {
            this.y1 = sy;
        }
        if (this.x2 < ex) {
            this.x2 = ex;
        }
        if (this.y2 < ey) {
            this.y2 = ey;
        }
    }

    public boolean isIn(MBR mbr) {
        boolean retCode = false;
        if (mbr == null) {
            return retCode;
        }
        float dx1 = mbr.getSX();
        float dx2 = mbr.getEX();
        float dy1 = mbr.getSY();
        float dy2 = mbr.getEY();
        if (dx1 <= this.x1 && dx2 >= this.x2 && dy1 <= this.y1 && dy2 >= this.y2) {
            retCode = true;
        }
        return retCode;
    }

    public boolean contains(MBR mbr) {
        if (mbr == null) {
            return false;
        }
        int pattern = 0;
        float dx1 = mbr.getSX();
        float dx2 = mbr.getEX();
        float dy1 = mbr.getSY();
        float dy2 = mbr.getEY();
        if (dx1 <= this.x1 && dx2 >= this.x2 && dy1 <= this.y1 && dy2 >= this.y2) {
            pattern = 1;
        } else if (dx2 >= this.x1 && dx1 <= this.x2 && dy1 >= this.y1 && dy2 <= this.y2) {
            pattern = 2;
        } else if (dx1 <= this.x2 && dx2 >= this.x1 && dy2 >= this.y1 && dy2 <= this.y2) {
            pattern = 3;
        } else if (dx1 <= this.x2 && dx2 >= this.x1 && dy1 >= this.y1 && dy1 <= this.y2) {
            pattern = 4;
        } else if (dx2 >= this.x1 && dx2 <= this.x2 && dy1 <= this.y2 && dy2 >= this.y1) {
            pattern = 5;
        } else if (dx1 >= this.x1 && dx1 <= this.x2 && dy1 <= this.y2 && dy2 >= this.y1) {
            pattern = 6;
        }
        return pattern > 0;
    }

    public MBR getOverlapMBR(MBR mbr) {
        if (mbr == null || !this.contains(mbr)) {
            return null;
        }
        float dx1 = mbr.getSX();
        float dx2 = mbr.getEX();
        float dy1 = mbr.getSY();
        float dy2 = mbr.getEY();
        float nx1 = dx1;
        float nx2 = dx2;
        float ny1 = dy1;
        float ny2 = dy2;
        if (dx1 < this.x1) {
            nx1 = this.x1;
        }
        if (dx2 > this.x2) {
            nx2 = this.x2;
        }
        if (dy1 < this.y1) {
            ny1 = this.y1;
        }
        if (dy2 > this.y2) {
            ny2 = this.y2;
        }
        return new MBR(nx1, ny1, nx2, ny2);
    }

    public float getArea() {
        float area = (this.x2 - this.x1) * (this.y2 - this.y1);
        return area;
    }

    public boolean isValid() {
        return this.x1 != Float.POSITIVE_INFINITY && this.x1 != 0.0f || this.y1 != Float.POSITIVE_INFINITY && this.y1 != 0.0f || this.x2 != 0.0f || this.y2 != 0.0f;
    }

    public boolean equals(Object obj) {
        MBR mbr;
        boolean retCode = false;
        if (obj != null && obj instanceof MBR && this.x1 == (mbr = (MBR)obj).getSX() && this.y1 == mbr.getSY() && this.x2 == mbr.getEX() && this.y2 == mbr.getEY()) {
            retCode = true;
        }
        return retCode;
    }

    public Object clone() {
        return new MBR(this.x1, this.y1, this.x2, this.y2);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<MBR ");
        sb.append("x1=\"" + this.x1 + "\" ");
        sb.append("y1=\"" + this.y1 + "\" ");
        sb.append("x2=\"" + this.x2 + "\" ");
        sb.append("y2=\"" + this.y2 + "\">");
        return sb.toString();
    }

    public static void test() {
    }

    public static void main(String[] args) {
        MBR.test();
    }
}

