package store;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.sourceforge.ma38su.util.Log;

import map.DataCity;
import map.store.ChainStore;

/**
 * ジョリパの店舗情報を取得するためのクラスです。
 * @author Masayasu Fujiwara
 */
public class JollyPastaPlugin extends ChainStore {

	/**
	 * 住所解析用のパターン
	 */
	private Pattern ADDRESS_PARSER;
	
	/**
	 * Pluginロードのためのコンストラクタ
	 * キャッシュディレクトリを設定する必要がある。
	 */
	public JollyPastaPlugin() {
		super("ジョリパ");
	}
	
	/**
	 * 市区町村番号からURLを取得する
	 * @param city 市区町村データ
	 * @param page ページ番号
	 * @return URL 店舗情報が掲載されているURL
	 */
	@Override
	protected URL getURL(DataCity city, int page) {
		URL url = null;
		if (page == 1) {
			try {
				if (city.getCode() / 1000 < 15) {
					url = new URL("http://www.sundays-sun.co.jp/jp/shop_east.html");
				} else {
					url = new URL("http://www.sundays-sun.co.jp/jp/shop_west.html");
				}
				this.ADDRESS_PARSER = Pattern.compile("([^\\d\\s　]*"+ city.getName() +"[^<>]+)</td>");
			} catch (MalformedURLException e) {
				Log.err(this, e);
			}
		}
		return url;
	}

	@Override
	protected String parseAddress(String input) {
		Matcher matcher = this.ADDRESS_PARSER.matcher(input);
		if (matcher.find()) {
			return matcher.group(1);
		}
		return null;
	}
}
