import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.UIManager;

import tsp.Controller;
import tsp.Node;
import tsp.StatusBar;
import tsp.TspPanel;
import tsp.method.ImproveLoopRoutine;
import tsp.method.ImproveRoutine;
import tsp.method.NearestNeighbor;
import tsp.method.Opt2;
import tsp.method.Opt3;
import tsp.method.TspImprovement;
import tsp.method.TspConstruction;

/**
 * 起動のためのクラスです。
 * @author ma38su
 */
public class Main {
	public static void main(String[] args) {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			e.printStackTrace();
		}
		final TspConstruction tspConstruct = new NearestNeighbor();
		final List<TspImprovement> tspImprovement = new ArrayList<TspImprovement>();
		Opt2 opt2 = new Opt2();
		Opt3 opt3 = new Opt3();
		tspImprovement.add(opt2);
		tspImprovement.add(opt3);
		tspImprovement.add(new ImproveRoutine(opt2, opt3));
		tspImprovement.add(new ImproveRoutine(opt3, opt2));
		tspImprovement.add(new ImproveLoopRoutine(opt2, opt3));
		tspImprovement.add(new ImproveLoopRoutine(opt3, opt2));

		final JFrame frame = new JFrame("TSP "+tspConstruct.toString());

		JMenuBar menubar = new JMenuBar();
		frame.setJMenuBar(menubar);
		JMenu menu1 = new JMenu("ファイル");
		JMenuItem menu1_1 = new JMenuItem("終了");
		menu1_1.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.exit(0);
			}
		});
		menu1.add(menu1_1);
		menubar.add(menu1);
		
		frame.setLayout(new BorderLayout());
		final Observable observable = new Observable() {
			@Override
			public void notifyObservers(Object arg) {
				super.setChanged();
				super.notifyObservers(arg);
			}
		};

		final TspPanel panel = new TspPanel(observable);
		Controller controller = new Controller(panel);
		panel.addMouseListener(controller);
		frame.add(panel, BorderLayout.CENTER);

		JPanel subPanel = new JPanel(new BorderLayout());
		StatusBar statusbar = new StatusBar();
		observable.addObserver(statusbar);
		
		subPanel.add(statusbar, BorderLayout.CENTER);
		JPanel buttonPanel = new JPanel();
		subPanel.add(buttonPanel, BorderLayout.EAST);

		JButton startButton = new JButton("計算開始");
		buttonPanel.add(startButton);
		final boolean[] isImprove = new boolean[tspImprovement.size()];
		isImprove[4] = true;
		final ActionListener calc = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				panel.clearRoute();
				List<Node> route = tspConstruct.method(panel.getNodes());
				for (int i = 0; i < tspImprovement.size(); i++) {
					if (isImprove[i]) {
						TspImprovement tsp = tspImprovement.get(i);
						frame.setTitle("TSP "+ tspConstruct.toString() + " + "+ tsp);
						while (tsp.method(route));
					}
				}
				observable.notifyObservers(route);
				panel.add(route);
			}
		};
		startButton.addActionListener(calc);

		JButton clearButton = new JButton("やり直し");
		buttonPanel.add(clearButton);
		clearButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				panel.clear();
			}
		});

		JMenu menu2 = new JMenu("改善手法");
		ButtonGroup group = new ButtonGroup();
		for (int i = 0; i < tspImprovement.size(); i++) {
			JCheckBoxMenuItem item = new JCheckBoxMenuItem(tspImprovement.get(i).toString(), isImprove[i]);
			final int index = i;
			item.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					for (int i = 0; i < isImprove.length; i++) {
						isImprove[i] = false;
					}
					isImprove[index] = !isImprove[index];
					calc.actionPerformed(null);
				}
			});
			group.add(item);
			menu2.add(item);
		}
		menubar.add(menu2);

		
		frame.add(subPanel, BorderLayout.SOUTH);
		frame.setSize(600, 400);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);
	}
	public static double getLength(List<Node> route) {
		double length = 0;
		Node n0 = null;
		for (Node node : route) {
			if (n0 != null) {
				length += n0.getDistance(node);
			}
			n0 = node;
		}
		return length;
	}
}
