package tsp.method;

import java.util.List;

import tsp.Node;

/**
 * 3-Optによる巡回セールスマン問題の改善法です。
 * @author ma38su
 */
public class Opt3 implements TspImprovement {
	public boolean method(List<Node> route) {
		for (int i = 1; i < route.size(); i++) {
			Node s1 = route.get(i - 1);
			Node t1 = route.get(i);
			double d1 = s1.getDistance(t1);
			for (int j = i + 2; j < route.size(); j++) {
				Node s2 = route.get(j - 1);
				Node t2 = route.get(j);
				double d2 = s2.getDistance(t2);
				for (int k = j + 2; k < route.size(); k++) {
					Node s3 = route.get(k - 1);
					Node t3 = route.get(k);
					double before = d1 + d2 + s3.getDistance(t3);
					double after = s1.getDistance(t2) + s3.getDistance(t1) + s2.getDistance(t3);
					if (before > after) {
						// リストの回転を行います。
						this.reverse(route, i, j - 1);
						this.reverse(route, j, k - 1);
						this.reverse(route, i, k - 1);
						return true;
					}
					after = s1.getDistance(t2) + s3.getDistance(s2) + t1.getDistance(t3);
					if (before > after) {
						this.reverse(route, j, k - 1);
						this.reverse(route, i, k - 1);
						return true;
					}
					after = s1.getDistance(s3) + t2.getDistance(t1) + s2.getDistance(t3);
					if (before > after) {
						this.reverse(route, i, j - 1);
						this.reverse(route, i, k - 1);
						return true;
					}
					after = s1.getDistance(s2) + t1.getDistance(s3) + t2.getDistance(t3);
					if (before > after) {
						this.reverse(route, i, j - 1);
						this.reverse(route, j, k - 1);
						return true;
					}
				}
			}
		}
		return false;
	}

	/**
	 * 指定したインデックス間の要素を逆順に並べ替えます。
	 * @param list リスト 
	 * @param s 並べ替える要素の最小のインデックス
	 * @param t 並べ替える要素の最大のインデックス
	 */
	public void reverse(List<Node> list, int s, int t) {
		for (int i = (t - s) / 2; i >= 0; i--) {
			Node tmp = list.get(s + i);
			list.set(s + i, list.get(t - i));
			list.set(t - i, tmp);
		}
	}
	
	@Override
	public String toString() {
		return "3-Opt";
	}
}
