package tsp.method;

import java.util.List;

import tsp.Node;

/**
 * 改善法を順序を指定して適用するためのクラス
 * もし改善法が適用できれば、最初の改善法を改めて適用します。
 * @author ma38su
 */
public class ImproveLoopRoutine implements TspImprovement {
	TspImprovement[] algorithm;
	
	public ImproveLoopRoutine(TspImprovement... algorithm) {
		this.algorithm = algorithm;
	}

	public boolean method(List<Node> route) {
		boolean flag = false;
		for (int i = 0; i < this.algorithm.length; i++) {
			while (this.algorithm[i].method(route)) {
				flag = true;
				i = 0;
			}
		}
		return flag;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		boolean isFirst = true;
		for (TspImprovement tsp : this.algorithm) {
			if (isFirst) {
				isFirst = false;
			} else {
				sb.append(", ");
			}
			sb.append(tsp);
		}
		return sb.toString();
	}
}
