//******************************************************************************
//
// Simple MIDI Library / SMOutDevCtrlEx
//
// 拡張MIDI出力デバイス制御クラス
//
// Copyright (C) 2010-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// memo:
// MIDI出力デバイス制御クラス(SMOutDevCtrl)とWavetableシンセサイザ制御クラス(SMWavetableSynthCtrl)
// を統合して、MIDI出力デバイス制御クラスと同等のI/Fに集約するクラス。
// SMOutDevCtrlにSMWavetableSynthCtrlを組み込まず、CoreMIDIの制御に集中できるようにする。

#import "SMOutDevCtrl.h"
#import "SMWavetableSynthCtrl.h"


//******************************************************************************
// 拡張MIDI出力デバイス制御クラス
//******************************************************************************
class SMOutDevCtrlEx
{
public:
	
	//コンストラクタ／デストラクタ
	SMOutDevCtrlEx(void);
	virtual ~SMOutDevCtrlEx(void);
	
	//初期化
	int Initialize();
	
	//内部シンセサイザ：Wavetableファイルパス登録
	int SetInternalSynthsizerWavetableFilePath(NSString* pWavetableFilePath);
	
	//デバイス数取得
	unsigned int GetDevNum();
	
	//デバイス表示名称取得
	NSString* GetDevDisplayName(unsigned int index);
	
	//デバイス識別名取得
	NSString* GetDevIdName(unsigned int index);
	
	//メーカー名取得
	NSString* GetManufacturerName(unsigned int index);
	
	//ポート対応デバイス登録
	int SetDevForPort(unsigned char portNo, NSString* pIdName, NSString* pDisplayName);
	
	//全デバイスのオープン／クローズ
	int OpenPortDevAll();
	int ClosePortDevAll();
	
	//ポート情報クリア
	int ClearPortInfo();
	
	//MIDI出力メッセージ送信
	int SendShortMsg(unsigned char portNo, unsigned char* pMsg, unsigned int size);
	int SendLongMsg(unsigned char portNo, unsigned char* pMsg, unsigned int size);
	int NoteOffAll();
	
private:
	
	//ポート種別
	enum SMPortType {
		PortNone,			//なし
		PortWavetableSynth,	//Wavetable シンセサイザ
		PortCoreMIDIDevice	//CoreMIDI デバイス
	};
	
private:
	
	//出力デバイス制御
	SMOutDevCtrl m_OutDevCtrl;
	
	//Wavetableシンセサイザ制御
	SMWavetableSynthCtrl m_WavetableSynthCtrl;
	
	//ポート情報
	SMPortType m_PortType[SM_MIDIOUT_PORT_NUM_MAX];

};


