//******************************************************************************
//
// MIDITrail / MTColorParamExportDlg
//
// カラーパラメータ出力ダイアログ
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "YNBaseLib.h"
#import "MTColorParamExportDlg.h"


//##############################################################################
// カラーパラメータエクスポートダイアログクラス
//##############################################################################
@implementation MTColorParamExportDlg

//******************************************************************************
// 生成
//******************************************************************************
- (id)init
{
	m_pParamText = nil;
	
	//Nibファイルを指定してウィンドウコントローラを生成
	return [super initWithWindowNibName:@"ColorParamExportDlg"];
}

//******************************************************************************
// 破棄
//******************************************************************************
- (void)dealloc
{
	[m_pParamText release];
	[super dealloc];
}

//******************************************************************************
// パラメータ文字列登録
//******************************************************************************
- (void)setParamString:(NSString*)pString
{
	m_pParamText = pString;
	[pString retain];
}

//******************************************************************************
// ウィンドウ読み込み完了
//******************************************************************************
- (void)windowDidLoad
{
	int result = 0;
	
	//ウィンドウ表示項目初期化
	//  モーダル終了後に再度モーダル表示してもwindowDidLoadは呼び出されない
	result = [self initDlg];
	if (result != 0) goto EXIT;
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
}

//******************************************************************************
// モーダルウィンドウ表示
//******************************************************************************
- (void)showModalWindow
{
	//モーダルウィンドウ表示
	[NSApp runModalForWindow:[self window]];
	
	//モーダル表示終了後はウィンドウを非表示にする
	[[self window] orderOut:self];
}

//******************************************************************************
// OKボタン押下
//******************************************************************************
- (IBAction)onOK:(NSButton *)sender
{
	int result = 0;
	
	//ダイアログを閉じる
	[NSApp stopModal];
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
	return;
}

//******************************************************************************
// コピーボタン押下
//******************************************************************************
- (IBAction)onBtnCopy:(NSButton *)sender
{
	int result = 0;
	BOOL apiresult = NO;
	NSPasteboard* pPasteboard = nil;
	
	//テキストフィールドの文字列をクリップボードにコピー
	pPasteboard = [NSPasteboard generalPasteboard];
	[pPasteboard clearContents];
	[pPasteboard declareTypes:[NSArray arrayWithObject:NSPasteboardTypeString] owner:nil];
	apiresult = [pPasteboard setString:m_pTextField.stringValue forType:NSPasteboardTypeString];
	if (!apiresult) {
		result = YN_SET_ERR(@"NSPasteboard error.", 0, 0);
		goto EXIT;
	}
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
	return;
}

//******************************************************************************
// クローズボタン押下
//******************************************************************************
- (void)windowWillClose:(NSNotification*)aNotification
{
	//モーダル表示終了
	[NSApp stopModal];
}

//******************************************************************************
// ダイアログ初期化
//******************************************************************************
- (int)initDlg
{
	int result = 0;
	
	//テキストフィールドにパラメータ文字列を設定
	[m_pTextField setStringValue:m_pParamText];
	
EXIT:;
	return result;
}

@end

