//******************************************************************************
//
// MIDITrail / MTFileList
//
// ファイルリストクラス
//
// Copyright (C) 2021 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

//using namespace YNBaseLib;
//using namespace SMIDILib;


//******************************************************************************
// ファイルリストクラス
//******************************************************************************
class MTFileList
{
public:

	//コンストラクタ／デストラクタ
	MTFileList(void);
	virtual ~MTFileList(void);

	//ディレクトリ配下ファイルリスト作成
	int MakeFileListWithDirectory(NSString* pTargetDirPath);

	//ファイル数
	NSUInteger GetFileCount();

	//ファイルパス取得
	NSString* GetFilePath(unsigned int index);

	//ファイル名取得
	NSString* GetFileName(unsigned int index);

	//クリア
	void Clear();

	//選択ファイル登録
	int SetSelectedFileName(NSString* pFileName);

	//先頭ファイル選択
	void SelectFirstFile();

	//前ファイル選択
	void SelectPreviousFile(bool* pExist);

	//次ファイル選択
	void SelectNextFile(bool* pExist);

	//選択ファイルインデックス取得
	unsigned int GetSelectedFileIndex();

private:

	//代入とコピーコンストラクタの禁止
	void operator=(const MTFileList&);
	MTFileList(const MTFileList&);

	NSString* m_pTargetDirPath;
	NSString* m_pCurFilePath;

	NSMutableArray* m_pFileNameArray;

	unsigned int m_SelectedFileIndex;

};

