/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.common;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.SocketException;
import java.util.List;
import java.util.Properties;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.ParserConfigurationException;
import jp.mosp.common.common.ActionInterface;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.FileUploadUtility;
import jp.mosp.common.common.LogUtility;
import jp.mosp.common.common.MobileUserUtility;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.express.ExpressUtility;
import jp.mosp.legal.LegalUtility;
import jp.mosp.se.SeUtility;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jopendocument.dom.spreadsheet.SpreadSheet;

public class Controller
extends HttpServlet {
    private static final long serialVersionUID = 5986464246296477656L;
    private transient ServletContext ctx = null;
    private Properties ctl = null;
    private Properties cfg = null;
    private Properties nam = null;
    private Properties msg = null;

    public void init(ServletConfig config) throws ServletException {
        try {
            super.init(config);
            if (this.ctx == null) {
                this.ctx = config.getServletContext();
            }
            this.getResources();
            LogUtility.log(this.cfg, "", "", "", 4, "MosP\u60c5\u5831", "MosP\u30d5\u30ec\u30fc\u30e0\u30ef\u30fc\u30af\u30d0\u30fc\u30b8\u30e7\u30f3-" + MospUtility.getMospJarVersion());
            try {
                Thread.currentThread().getContextClassLoader().loadClass("jp.mosp.se.SeUtility").newInstance();
                String seVer = SeUtility.getMospSeJarVersion();
                this.ctx.setAttribute("seVer", (Object)seVer);
                LogUtility.log(this.cfg, "", "", "", 4, "MosP\u60c5\u5831", "MosPSE\u30e6\u30fc\u30c6\u30a3\u30ea\u30c6\u30a3\u30fc\u30d0\u30fc\u30b8\u30e7\u30f3-" + seVer);
            }
            catch (ClassNotFoundException e) {
                this.ctx.removeAttribute("seVer");
            }
            try {
                Thread.currentThread().getContextClassLoader().loadClass("jp.mosp.legal.LegalUtility").newInstance();
                String legalVer = LegalUtility.getMospLegalJarVersion();
                this.ctx.setAttribute("legalVer", (Object)legalVer);
                LogUtility.log(this.cfg, "", "", "", 4, "MosP\u60c5\u5831", "MosP\u6cd5\u5b9a\u30e6\u30fc\u30c6\u30a3\u30ea\u30c6\u30a3\u30fc\u30d0\u30fc\u30b8\u30e7\u30f3-" + legalVer);
            }
            catch (ClassNotFoundException e) {
                this.ctx.removeAttribute("legalVer");
            }
            try {
                Thread.currentThread().getContextClassLoader().loadClass("jp.mosp.express.ExpressUtility").newInstance();
                String expressVer = ExpressUtility.getMospExpressJarVersion();
                this.ctx.setAttribute("expressVer", (Object)expressVer);
                LogUtility.log(this.cfg, "", "", "", 4, "MosP\u60c5\u5831", "MosP\u8a08\u7b97\u5f0f\u30e6\u30fc\u30c6\u30a3\u30ea\u30c6\u30a3\u30fc\u30d0\u30fc\u30b8\u30e7\u30f3-" + expressVer);
            }
            catch (ClassNotFoundException e) {
                this.ctx.removeAttribute("expressVer");
            }
            try {
                Thread.currentThread().getContextClassLoader().loadClass("org.apache.poi.hssf.usermodel.HSSFWorkbook").newInstance();
                this.ctx.setAttribute("poiExist", (Object)true);
            }
            catch (ClassNotFoundException e) {
                this.ctx.removeAttribute("poiExist");
            }
            try {
                Thread.currentThread().getContextClassLoader().loadClass("org.jopendocument.dom.ODPackage").newInstance();
                this.ctx.setAttribute("jodExist", (Object)true);
            }
            catch (ClassNotFoundException e) {
                this.ctx.removeAttribute("jodExist");
            }
            try {
                Thread.currentThread().getContextClassLoader().loadClass("net.sf.jasperreports.engine.JasperPrint").newInstance();
                this.ctx.setAttribute("jasperExist", (Object)true);
            }
            catch (ClassNotFoundException e) {
                this.ctx.removeAttribute("jasperExist");
            }
            try {
                Thread.currentThread().getContextClassLoader().loadClass("org.apache.commons.fileupload.servlet.ServletFileUpload").newInstance();
                this.ctx.setAttribute("uploadExist", (Object)true);
            }
            catch (ClassNotFoundException e) {
                this.ctx.removeAttribute("uploadExist");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            String responseType = request.getParameter("resType");
            String cmd = request.getParameter("cmd");
            String procSeq = request.getParameter("procSeq");
            if (responseType == null || cmd == null || procSeq == null) {
                request.setAttribute("cfg", (Object)this.cfg);
                throw new MospException(3001);
            }
            if (responseType.equals("image")) {
                this.doPost(request, response);
                return;
            }
            if (responseType.equals("html") && MobileUserUtility.isMobileUser(request)) {
                this.doPost(request, response);
                return;
            }
            request.setAttribute("cfg", (Object)this.cfg);
            throw new MospException(3001);
        }
        catch (Exception e) {
            this.handleException(e, request, response);
            return;
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.doCommonPreProcess(request);
            LogUtility.log(request, 0, "\u30a2\u30af\u30bb\u30b9", "");
            String cmd = (String)request.getAttribute("cmd");
            ActionInterface action = (ActionInterface)MospUtility.getInstance(this.ctl, cmd);
            action.init(request, response);
            action.doAction();
            action = null;
            this.forward(request, response);
        }
        catch (Exception e) {
            this.handleException(e, request, response);
        }
        catch (Error e) {
            this.handleException(e, request, response);
        }
    }

    private void getResources() throws IOException {
        String docbase = this.ctx.getRealPath("");
        this.cfg = MospUtility.getResource(docbase + "/WEB-INF/" + "mosp.properties");
        MospUtility.addResources(this.cfg, docbase + "/WEB-INF/", "extra.properties");
        this.cfg.setProperty("app.docbase", docbase);
        this.ctl = MospUtility.getResource(docbase + "/WEB-INF/" + "controller.properties");
        MospUtility.addResources(this.ctl, docbase + "/WEB-INF/", "controller.properties");
        try {
            this.nam = MospUtility.getResource(docbase + "/WEB-INF/" + "naming.properties");
        }
        catch (IOException e) {
            this.nam = new Properties();
        }
        MospUtility.addResources(this.nam, docbase + "/WEB-INF/", "naming.properties");
        this.msg = MospUtility.getResource(docbase + "/WEB-INF/" + "message.properties");
        MospUtility.addResources(this.msg, docbase + "/WEB-INF/", "message.properties");
        MospUtility.convProperties(this.msg, this.cfg.getProperty("app.docbase") + "/pub/common/js/message.js", "msg");
    }

    private void forward(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, MospException {
        String url = null;
        String responseType = (String)request.getAttribute("resType");
        if (responseType == null) {
            url = (String)request.getAttribute("url");
            if (url == null || !url.equals("/pub/common/index.html")) {
                url = "/pub/common/error.html";
            }
        } else if (responseType.equals("html")) {
            url = (String)request.getAttribute("url");
        } else if (responseType.equals("xml")) {
            url = "/jsp/common/xml.jsp";
        } else {
            if (responseType.equals("file")) {
                Object objFile = request.getAttribute("fileObject");
                String strFile = (String)request.getAttribute("fileName");
                response.setContentType("application/octet-stream; charset=Windows-31J");
                response.setHeader("Content-Disposition", "attachment; filename=" + strFile);
                if (objFile instanceof String || objFile instanceof StringBuffer) {
                    PrintWriter pw = response.getWriter();
                    pw.print(objFile);
                } else {
                    boolean hasPoi = true;
                    boolean hasJOpenDoc = true;
                    boolean hasJasperReport = true;
                    if (this.ctx.getAttribute("poiExist") == null) {
                        hasPoi = false;
                    }
                    if (this.ctx.getAttribute("jodExist") == null) {
                        hasJOpenDoc = false;
                    }
                    if (this.ctx.getAttribute("jasperExist") == null) {
                        hasJasperReport = false;
                    }
                    if (hasPoi && objFile instanceof HSSFWorkbook) {
                        HSSFWorkbook workbook = (HSSFWorkbook)objFile;
                        workbook.write((OutputStream)response.getOutputStream());
                    } else if (hasJOpenDoc && objFile instanceof SpreadSheet) {
                        SpreadSheet spreadSheet = (SpreadSheet)objFile;
                        spreadSheet.getPackage().save((OutputStream)response.getOutputStream());
                    } else if (hasJasperReport && objFile instanceof JRExporter) {
                        JRExporter exporter = (JRExporter)objFile;
                        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)response.getOutputStream());
                        try {
                            exporter.exportReport();
                        }
                        catch (Exception e) {
                            throw new MospException(9001);
                        }
                    } else {
                        PrintWriter pw = response.getWriter();
                        pw.print(objFile);
                    }
                }
                return;
            }
            if (responseType.equals("image")) {
                int len;
                Object objFile = request.getAttribute("fileObject");
                response.setContentType("image/jpeg");
                ServletOutputStream out = response.getOutputStream();
                byte[] data = new byte[1024];
                BufferedInputStream in = (BufferedInputStream)objFile;
                while ((len = in.read(data, 0, 1024)) != -1) {
                    out.write(data, 0, len);
                }
                in.close();
                return;
            }
            url = "/pub/common/error.html";
        }
        if (url == null) {
            url = "/pub/common/error.html";
            LogUtility.log(request, 6, "MosP\u30a8\u30e9\u30fc", "\u30d5\u30a9\u30ef\u30fc\u30c9\u5148\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        RequestDispatcher rd = this.ctx.getRequestDispatcher(url);
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }

    private void doCommonPreProcess(HttpServletRequest request) throws Exception {
        Integer forward;
        request.setAttribute("ctx", (Object)this.ctx);
        request.setAttribute("ctl", (Object)this.ctl);
        request.setAttribute("cfg", (Object)this.cfg);
        request.setAttribute("nam", (Object)this.nam);
        request.setAttribute("msg", (Object)this.msg);
        if (17000000 < request.getContentLength()) {
            throw new MospException(4001);
        }
        Properties hot = MospUtility.getResource(this.cfg.getProperty("app.docbase") + "/WEB-INF/" + "hot.properties");
        if (hot.getProperty("app.hot").equals("0")) {
            this.getResources();
            LogUtility.setLevel(this.cfg);
        }
        Integer n = forward = (forward = (Integer)request.getAttribute("forward")) != null ? forward : new Integer(0);
        if (forward > 1) {
            throw new MospException(5006);
        }
        String contentType = request.getHeader("content-type");
        if (contentType != null && contentType.indexOf("charset") == -1) {
            request.setCharacterEncoding("Windows-31J");
        }
        List<?> multipartFieldList = null;
        if (this.ctx.getAttribute("uploadExist") != null) {
            multipartFieldList = FileUploadUtility.getMultipartFieldList(request);
        }
        request.setAttribute("multipartList", multipartFieldList);
        String responseType = (String)request.getAttribute("resType");
        if (responseType == null) {
            responseType = request.getParameter("resType");
        }
        if (responseType == null && multipartFieldList != null) {
            responseType = FileUploadUtility.getMultipartField(multipartFieldList, "resType");
        }
        if (responseType == null) {
            throw new MospException(4009);
        }
        if (!(responseType.equals("html") || responseType.equals("file") || responseType.equals("xml") || responseType.equals("image"))) {
            throw new MospException(4010);
        }
        request.setAttribute("resType", (Object)responseType);
        String cmd = (String)request.getAttribute("nextCmd");
        request.removeAttribute("nextCmd");
        if (cmd == null) {
            cmd = request.getParameter("cmd");
            if (cmd == null) {
                cmd = FileUploadUtility.getMultipartField(multipartFieldList, "cmd");
            }
            if (cmd == null) {
                throw new MospException(4002);
            }
            request.removeAttribute("forward");
        } else {
            request.setAttribute("forward", (Object)new Integer(forward + 1));
        }
        if (cmd.length() != 5) {
            throw new MospException(4003);
        }
        request.setAttribute("cmd", (Object)cmd);
    }

    private void handleException(Object obj, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (response.isCommitted()) {
                return;
            }
            String url = "/pub/common/error.html";
            HttpSession session = request.getSession(false);
            String responseType = (String)request.getAttribute("resType");
            if (obj instanceof MospException) {
                MospException me = (MospException)obj;
                int exCode = me.getExCode();
                int logLevel = this.getExLogLevel(exCode);
                String logType = this.getExLogType(exCode);
                StringBuffer message = new StringBuffer();
                message.append(exCode);
                message.append("-");
                if (me.getExMessage() == null) {
                    message.append(this.getExLogMessage(exCode));
                } else {
                    message.append(me.getExMessage());
                }
                LogUtility.log(request, logLevel, logType, message.toString());
                if (this.needInitSession(exCode)) {
                    if (session != null) {
                        session.invalidate();
                    }
                    request.getSession(true);
                }
                url = this.getUrl(exCode, request);
            } else if (obj instanceof Exception) {
                Exception ex = (Exception)obj;
                LogUtility.outputErrorLog(ex, request);
                if (ex.getCause() instanceof SocketException && responseType.equals("file")) {
                    return;
                }
                if (session != null) {
                    session.invalidate();
                }
                request.getSession(true);
                url = "/pub/common/error.html";
            } else if (obj instanceof Error) {
                Error er = (Error)obj;
                LogUtility.outputErrorLog(er, request);
                if (session != null) {
                    session.invalidate();
                }
                request.getSession(true);
                url = "/pub/common/error.html";
            }
            request.setAttribute("url", (Object)url);
            if (responseType != null && responseType.equals("file")) {
                request.setAttribute("resType", (Object)"html");
            } else if (responseType != null && responseType.equals("xml")) {
                this.setXmlErrCode(obj, request);
            }
            this.forward(request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setXmlErrCode(Object ex, HttpServletRequest request) throws ParserConfigurationException {
        BaseVo vo = (BaseVo)request.getAttribute("vo");
        if (vo == null) {
            vo = new BaseVo();
            request.setAttribute("vo", (Object)vo);
        }
        vo.initXmlDoc();
        if (ex instanceof MospException) {
            MospException me = (MospException)ex;
            vo.setXmlRetCode(String.valueOf(me.getExCode()));
        } else {
            vo.setXmlRetCode(String.valueOf(9001));
        }
        if (vo.getDocXml() == null) {
            vo.initXmlDoc();
        }
    }

    private String getExLogMessage(int exCode) {
        String message = "";
        try {
            Field field = MospConst.class.getField("LOG_MSG_" + String.valueOf(exCode));
            message = (String)field.get(null);
        }
        catch (NoSuchFieldException e) {
            message = "\u30ed\u30b0\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
        }
        catch (IllegalAccessException e) {
            message = "\u30ed\u30b0\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
        }
        return message;
    }

    private String getExLogType(int exCode) {
        String logType = "";
        logType = exCode >= 1000 && exCode < 4000 ? "MosP\u60c5\u5831" : (exCode >= 4000 && exCode < 5000 ? "\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u8b66\u544a" : "MosP\u30a8\u30e9\u30fc");
        return logType;
    }

    private int getExLogLevel(int exCode) {
        int logLevel = 0;
        logLevel = exCode >= 1000 && exCode < 4000 ? 4 : (exCode >= 4000 && exCode < 5000 ? 5 : 6);
        return logLevel;
    }

    private boolean needInitSession(int exCode) {
        return exCode < 1000 || exCode >= 3000;
    }

    private String getUrl(int exCode, HttpServletRequest request) {
        String url = "";
        url = exCode >= 1000 && exCode < 2000 ? (String)request.getAttribute("url") : (exCode >= 2000 && exCode < 3000 ? "/srv/" : (exCode >= 3000 && exCode < 4000 ? "/pub/common/index.html" : "/pub/common/error.html"));
        return url;
    }
}

