/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.base;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospStoredInfo;
import jp.mosp.framework.base.MospUser;
import jp.mosp.framework.base.TopicPath;
import jp.mosp.framework.log.LoggerInterface;
import jp.mosp.framework.property.CodeProperty;
import jp.mosp.framework.property.CommandProperty;
import jp.mosp.framework.property.MospProperties;
import jp.mosp.framework.property.RoleProperty;

public class MospParams {
    protected static final String APP_PATH_ERROR_VIEW = "PathErrorView";
    public static final String APP_TEST_SUPPORT = "TestSupport";
    public static final String APP_USE_TARGET_APPROVAL_UNIT = "UseTargetApprovalUnit";
    private MospProperties properties;
    private Map<String, LoggerInterface> loggers;
    private MospStoredInfo storedInfo;
    private String command;
    private String nextCommand;
    private int nextCount;
    private BaseVo vo;
    private String url;
    private String naviUrl;
    private String articleUrl;
    private List<String> jsFiles;
    private List<String> cssFiles;
    private Object file;
    private String fileName;
    private String redirect;
    private int procSeq;
    private Map<String, String[]> requestParamsMap;
    private Map<String, InputStream> requestFilesMap;
    private List<String> messageList;
    private List<String> errorMessageList;
    private Map<String, Object> generalParamsMap;
    private List<String> apiParams;

    public MospParams(MospProperties properties, Map<String, LoggerInterface> loggers) {
        this.properties = properties;
        this.loggers = loggers;
        this.storedInfo = new MospStoredInfo();
        this.storedInfo.setRangeMap(new HashMap());
        this.messageList = new ArrayList();
        this.errorMessageList = new ArrayList();
        this.generalParamsMap = new HashMap();
        this.apiParams = new ArrayList();
        this.jsFiles = new ArrayList();
        this.cssFiles = new ArrayList();
        this.nextCount = 0;
    }

    public void inheritParams(MospParams params) {
        this.command = params.nextCommand;
        this.generalParamsMap = params.getGeneralParamsMap();
        this.apiParams = params.getApiParams();
        this.nextCount = ++params.nextCount;
        this.messageList = new ArrayList(params.getMessageList());
        this.errorMessageList = new ArrayList(params.getErrorMessageList());
    }

    public MospUser getUser() {
        return this.storedInfo.getUser();
    }

    public void setUser(MospUser user) {
        this.storedInfo.setUser(user);
    }

    public MospProperties getProperties() {
        return this.properties;
    }

    public void setProperties(MospProperties properties) {
        this.properties = properties;
    }

    public MospStoredInfo getStoredInfo() {
        return this.storedInfo;
    }

    public void setStoredInfo(MospStoredInfo storedInfo) {
        this.storedInfo = storedInfo;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public CommandProperty getCommandProperty() throws MospException {
        CommandProperty commandProperty = this.properties.getCommandProperty(this.command);
        if (commandProperty == null) {
            this.setErrorViewUrl();
            if (this.command == null) {
                this.command = "";
            }
            throw new MospException("FWE9112", this.command);
        }
        return commandProperty;
    }

    public String getNextCommand() {
        return this.nextCommand;
    }

    public void setNextCommand(String nextCommand) {
        this.nextCommand = nextCommand;
    }

    public int getNextCount() {
        return this.nextCount;
    }

    public void setNextCount(int nextCount) {
        this.nextCount = nextCount;
    }

    public BaseVo getVo() {
        return this.vo;
    }

    public void setVo(BaseVo vo) {
        this.vo = vo;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getNaviUrl() {
        return this.naviUrl;
    }

    public void setNaviUrl(String naviUrl) {
        this.naviUrl = naviUrl;
    }

    public String getArticleUrl() {
        return this.articleUrl;
    }

    public void setArticleUrl(String articleUrl) {
        this.articleUrl = articleUrl;
    }

    public void setRequestParamsMap(Map requestParamsMap) {
        this.requestParamsMap = new HashMap(requestParamsMap);
    }

    public Map<String, String[]> getRequestParamsMap() {
        return this.requestParamsMap;
    }

    public Map<String, InputStream> getRequestFilesMap() {
        return this.requestFilesMap;
    }

    public void setRequestFilesMap(Map<String, InputStream> requestFilesMap) {
        this.requestFilesMap = requestFilesMap;
    }

    public Object getFile() {
        return this.file;
    }

    public void setFile(Object file) {
        this.file = file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    public int getProcSeq() {
        return this.procSeq;
    }

    public void setProcSeq(int procSeq) {
        this.procSeq = procSeq;
    }

    public List<String> getMessageList() {
        return this.messageList;
    }

    public String getMessage(String key, String ... replacements) {
        return this.properties.getMessage(key, replacements);
    }

    public String getCodedMessage(String key, String ... replacements) {
        String message = this.properties.getMessage(key, replacements);
        if (message.isEmpty()) {
            return message;
        }
        if (message.isEmpty()) {
            return message;
        }
        return message + "(" + key + ")";
    }

    public void addMessage(String key, String ... replacements) {
        this.messageList.add(this.getMessage(key, replacements));
    }

    public List<String> getErrorMessageList() {
        return this.errorMessageList;
    }

    public void addErrorMessage(String key, String ... replacements) {
        String messege = this.getCodedMessage(key, replacements);
        if (!this.errorMessageList.contains(messege)) {
            this.errorMessageList.add(messege);
        }
    }

    public boolean hasErrorMessage() {
        return this.errorMessageList.size() > 0;
    }

    public Map<String, Object> getGeneralParamsMap() {
        return this.generalParamsMap;
    }

    public void addGeneralParam(String key, Object value) {
        this.generalParamsMap.put(key, value);
    }

    public Object getGeneralParam(String key) {
        return this.generalParamsMap.get(key);
    }

    public Set<String> getGeneralParamKeySet() {
        return this.generalParamsMap.keySet();
    }

    public void addApiParams(List<String> list) {
        this.apiParams.addAll(list);
    }

    public List<String> getApiParams() {
        return this.apiParams;
    }

    public void setErrorViewUrl() {
        this.url = this.properties.getApplicationProperty(APP_PATH_ERROR_VIEW);
    }

    public boolean isUrlErrorView() {
        if (this.url == null) {
            return false;
        }
        return this.url.equals(this.properties.getApplicationProperty(APP_PATH_ERROR_VIEW));
    }

    public boolean isTestSupport() {
        return this.properties.getApplicationPropertyBool(APP_TEST_SUPPORT);
    }

    public boolean isTargetApprovalUnit() {
        return this.properties.getApplicationPropertyBool(APP_USE_TARGET_APPROVAL_UNIT);
    }

    public List<String> getJsFiles() {
        return this.jsFiles;
    }

    public List<String> getCssFiles() {
        return this.cssFiles;
    }

    public void addCssFile(String cssFile) {
        this.cssFiles.add(cssFile);
    }

    public void addJsFile(String jsFile) {
        this.jsFiles.add(jsFile);
    }

    public String getRequestParam(String key) {
        if (this.requestParamsMap == null) {
            return null;
        }
        String[] requestParams = (String[])this.requestParamsMap.get(key);
        if (requestParams == null) {
            return null;
        }
        return requestParams[0];
    }

    public InputStream getRequestFile(String key) {
        if (this.requestFilesMap == null) {
            return null;
        }
        return (InputStream)this.requestFilesMap.get(key);
    }

    public String getName(String key) {
        return this.properties.getName(key);
    }

    public String getName(String key, String ... keys) {
        StringBuffer sb = new StringBuffer(this.getName(key));
        if (keys == null) {
            return sb.toString();
        }
        for (String concatKey : keys) {
            sb.append(this.getName(concatKey));
        }
        return sb.toString();
    }

    public String getApplicationProperty(String key) {
        return this.properties.getApplicationProperty(key);
    }

    public String[] getApplicationProperties(String key) {
        return this.properties.getApplicationProperties(key);
    }

    public int getApplicationProperty(String key, int defaultValue) {
        return this.properties.getApplicationProperty(key, defaultValue);
    }

    public boolean getApplicationPropertyBool(String key) {
        return this.properties.getApplicationPropertyBool(key);
    }

    public LoggerInterface getLogger(String loggerName) {
        return (LoggerInterface)this.loggers.get(loggerName);
    }

    public void putLogger(String loggerName, LoggerInterface logger) {
        this.loggers.put(loggerName, logger);
    }

    public BaseVo getStoredVo(String key) {
        List list = this.getTopicPathList();
        if (list == null) {
            return null;
        }
        BaseVo baseVo = null;
        for (TopicPath topicPath : list) {
            if (!topicPath.getId().equals(key)) continue;
            baseVo = topicPath.getVo();
        }
        return baseVo;
    }

    public List<TopicPath> getTopicPathList() {
        return this.storedInfo.getTopicPathList();
    }

    public void setTopicPathList(List<TopicPath> topicPathList) {
        this.storedInfo.setTopicPathList(topicPathList);
    }

    public RoleProperty getUserRole() {
        return (RoleProperty)this.properties.getRoleProperties().get(this.getUser().getRole());
    }

    public Map<String, CodeProperty> getCodeProperty() {
        return this.properties.getCodeProperty();
    }
}

