/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.property;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.IndexedDtoInterface;
import jp.mosp.framework.property.BaseProperty;
import jp.mosp.framework.property.RoleMenuProperty;
import jp.mosp.framework.utils.MospUtility;

public class RoleProperty
implements IndexedDtoInterface,
BaseProperty {
    protected static final String ROLE_EXTRA_DEFAULT = "default";
    protected static final String ROLE_EXTRA_NEEDED = "needed";
    protected static final String ROLE_EXTRA_SUPER = "super";
    protected static final String ROLE_EXTRA_APPROVER = "approver";
    protected static final String ROLE_EXTRA_CALCULATOR = "calculator";
    protected static final String ROLE_EXTRA_MYNUMBER = "mynumber";
    private String key;
    private String roleName;
    private String roleExtra;
    private Map<String, RoleMenuProperty> roleMenuMap;
    private List<String> acceptCmdList;
    private List<String> rejectCmdList;
    private int viewIndex;
    private String roleAuthority;
    private String roleCharge;
    private List<String> hiddenDivisionsList;
    private List<String> referenceDivisionsList;

    public RoleProperty(String key) {
        this.key = key;
        this.roleName = "";
        this.roleExtra = "";
        this.roleMenuMap = new HashMap();
        this.acceptCmdList = new ArrayList();
        this.rejectCmdList = new ArrayList();
        this.roleAuthority = "";
        this.roleCharge = "";
        this.hiddenDivisionsList = new ArrayList();
        this.referenceDivisionsList = new ArrayList();
    }

    public String getKey() {
        return this.key;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getRoleExtra() {
        return this.roleExtra;
    }

    public void setRoleExtra(String roleExtra) {
        this.roleExtra = roleExtra;
    }

    public Map<String, RoleMenuProperty> getRoleMenuMap() {
        return this.roleMenuMap;
    }

    public List<String> getAcceptCmdList() {
        return this.acceptCmdList;
    }

    public List<String> getRejectCmdList() {
        return this.rejectCmdList;
    }

    public int getIndex() {
        return this.viewIndex;
    }

    public void setViewIndex(int viewIndex) {
        this.viewIndex = viewIndex;
    }

    public String getRoleAuthority() {
        return this.roleAuthority;
    }

    public void setRoleAuthority(String roleAuthority) {
        this.roleAuthority = roleAuthority;
    }

    public String getRoleCharge() {
        return this.roleCharge;
    }

    public void setRoleCharge(String roleCharge) {
        this.roleCharge = roleCharge;
    }

    public List<String> getHiddenDivisionsList() {
        return this.hiddenDivisionsList;
    }

    public List<String> getReferenceDivisionsList() {
        return this.referenceDivisionsList;
    }

    public boolean isDefault() {
        for (String extra : this.getRoleExtraArray()) {
            if (!extra.equals(ROLE_EXTRA_DEFAULT)) continue;
            return true;
        }
        return false;
    }

    public boolean isNeeded() {
        for (String extra : this.getRoleExtraArray()) {
            if (!extra.equals(ROLE_EXTRA_NEEDED)) continue;
            return true;
        }
        return false;
    }

    public boolean isSuper() {
        for (String extra : this.getRoleExtraArray()) {
            if (!extra.equals(ROLE_EXTRA_SUPER)) continue;
            return true;
        }
        return false;
    }

    public boolean isApprover() {
        for (String extra : this.getRoleExtraArray()) {
            if (!extra.equals(ROLE_EXTRA_APPROVER)) continue;
            return true;
        }
        return false;
    }

    public boolean isCalculator() {
        for (String extra : this.getRoleExtraArray()) {
            if (!extra.equals(ROLE_EXTRA_CALCULATOR)) continue;
            return true;
        }
        return false;
    }

    public boolean isMynumber() {
        for (String extra : this.getRoleExtraArray()) {
            if (!extra.equals(ROLE_EXTRA_MYNUMBER)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRoleExtra(String roleExtra) {
        if (roleExtra.isEmpty()) {
            return false;
        }
        for (String extra : this.getRoleExtraArray()) {
            if (!extra.equals(roleExtra)) continue;
            return true;
        }
        return false;
    }

    protected String[] getRoleExtraArray() {
        if (this.roleExtra == null) {
            this.roleExtra = "";
        }
        return MospUtility.split((String)this.roleExtra, (String)",");
    }

    public boolean hasAuthority(String command) {
        if (command == null || command.isEmpty()) {
            return false;
        }
        if (this.rejectCmdList.contains(command)) {
            return false;
        }
        if (this.acceptCmdList.contains(command)) {
            return true;
        }
        String wildCardCommand = MospUtility.getWildCardCommand((String)command);
        while (!wildCardCommand.isEmpty()) {
            if (this.acceptCmdList.contains(wildCardCommand)) {
                return true;
            }
            wildCardCommand = MospUtility.getWildCardCommand((String)wildCardCommand);
        }
        return false;
    }
}

