/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import jp.mosp.framework.base.MospException;

/*
 * Exception performing whole class analysis ignored.
 */
public class BinaryUtility {
    public static final String STR_EXTENSION_SEPARATOR = ".";
    public static final String STR_EXTENSION_GIF = "gif";
    public static final String STR_EXTENSION_PNG = "png";
    public static final String STR_EXTENSION_JPEG = "jpeg";
    public static final String STR_EXTENSION_JPG = "jpg";

    private BinaryUtility() {
    }

    public static byte[] getBinaryData(InputStream requestedFile) throws MospException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = requestedFile.read(buffer)) >= 0) {
                bout.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new MospException((Throwable)e, "FWE9121", null);
        }
        return bout.toByteArray();
    }

    public static String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        String extension = fileName.substring(++index);
        return extension.toLowerCase(Locale.ENGLISH);
    }

    public static boolean isExtensionGif(String fileName) {
        String extension = BinaryUtility.getExtension((String)fileName);
        return extension != null && extension.equals("gif");
    }

    public static boolean isExtensionPng(String fileName) {
        String extension = BinaryUtility.getExtension((String)fileName);
        return extension != null && extension.equals("png");
    }

    public static boolean isExtensionJpg(String fileName) {
        String extension = BinaryUtility.getExtension((String)fileName);
        if (extension == null) {
            return false;
        }
        return extension.equals("jpg") || extension.equals("jpeg");
    }
}

