/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.utils;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.RDBMSType;

/*
 * Exception performing whole class analysis ignored.
 */
public class DatabaseUtility {
    private DatabaseUtility() {
    }

    public static String getDatabaseProductName(Connection conn) throws MospException {
        try {
            if (conn != null) {
                return conn.getMetaData().getDatabaseProductName();
            }
            return null;
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
    }

    public static RDBMSType getRDBMS(Connection conn) throws MospException {
        String name = DatabaseUtility.getDatabaseProductName((Connection)conn);
        if (name == null) {
            return null;
        }
        if (RDBMSType.MySQL.toString().equals(name)) {
            return RDBMSType.MySQL;
        }
        if (RDBMSType.PostgreSQL.toString().equals(name)) {
            return RDBMSType.PostgreSQL;
        }
        if (name.toLowerCase(Locale.JAPANESE).contains("oracle")) {
            return RDBMSType.Oracle;
        }
        if (RDBMSType.H2.toString().equals(name)) {
            return RDBMSType.H2;
        }
        return null;
    }
}

