/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.xml;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.mosp.framework.xml.FileFinderInterface;

public class FileFinder
implements FileFinderInterface {
    private static final String PATH_PROPERTY = "/WEB-INF/xml";
    private static final String PATH_ADDON_PROPERTY = "/addon/";
    private static final String PATH_USER_PROPERTY = "/user/";
    private static final String FILE_PROPERTY = "mosp.xml";
    private static final String SUFFIX_PROPERTY_FILE = ".xml";

    public List<String> getPathList(String docBase) {
        ArrayList<String> list = new ArrayList<String>();
        String xmlDirPath = docBase + PATH_PROPERTY;
        List propertyList = this.getFilePathList(xmlDirPath, false);
        Collections.sort(propertyList);
        File mospXml = new File(xmlDirPath, FILE_PROPERTY);
        if (mospXml.exists()) {
            list.add(mospXml.getAbsolutePath());
        }
        list.addAll(propertyList);
        list.addAll(this.getFilePathList(xmlDirPath + PATH_ADDON_PROPERTY, false));
        list.addAll(this.getFilePathList(xmlDirPath + PATH_USER_PROPERTY, false));
        return list;
    }

    public List<String> getFilePathList(String dirPath, boolean containDir) {
        ArrayList<String> propertyList = new ArrayList<String>();
        File[] files = new File(dirPath).listFiles();
        if (files == null) {
            return propertyList;
        }
        ArrayList<String> xmlFileList = new ArrayList<String>();
        for (File file : files) {
            String fileName;
            if (file.isDirectory() && containDir) {
                propertyList.addAll(this.getFilePathList(file.getPath(), containDir));
            }
            if (!file.isFile() || !(fileName = file.getName()).endsWith(SUFFIX_PROPERTY_FILE) || fileName.contains(FILE_PROPERTY)) continue;
            xmlFileList.add(file.getPath());
        }
        Collections.sort(propertyList);
        Collections.sort(xmlFileList);
        propertyList.addAll(xmlFileList);
        return propertyList;
    }
}

