/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.property.BaseProperty;
import jp.mosp.framework.property.RangeProperty;
import jp.mosp.framework.property.RoleMenuProperty;
import jp.mosp.framework.property.RoleProperty;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.xml.NodeWrapper;
import jp.mosp.framework.xml.TagConverterInterface;
import jp.mosp.framework.xml.TagUtility;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RoleTagConverter
implements TagConverterInterface {
    private static final String TAG_ROLE_NAME = "RoleName";
    private static final String TAG_ROLE_EXTRA = "RoleExtra";
    private static final String TAG_VIEW_INDEX = "ViewIndex";
    private static final String TAG_ROLE_AUTHORITY = "RoleAuthority";
    private static final String TAG_ROLE_CHARGE = "RoleCharge";
    private static final String TAG_ROLE_ACCEPT_COMMAND = "RoleAcceptCommand";
    private static final String TAG_ROLE_REJECT_COMMAND = "RoleRejectCommand";
    private static final String TAG_ROLE_ACCEPT_REMOVE = "RoleAcceptRemove";
    private static final String TAG_ROLE_REJECT_REMOVE = "RoleRejectRemove";
    private static final String TAG_MENU = "Menu";
    private static final String TAG_ROLE_MENU_REMOVE = "RoleMenuRemove";
    private static final String TAG_ROLE_INVALID = "RoleInvalid";
    private static final String TAG_INDEX = "Index";
    private static final String TAG_RANGE = "Range";
    private static final String TAG_WORK_PLACE = "WorkPlace";
    private static final String TAG_EMPLOYMENT_CONTRACT = "EmploymentContract";
    private static final String TAG_SECTION = "Section";
    private static final String TAG_POSITION = "Position";
    private static final String TAG_EMPLOYEE = "Employee";
    private String path;
    private static final String TAG_ROLE_HIDDEN_DIVISIONS = "RoleHiddenDivisions";
    private static final String TAG_ROLE_REFERENCE_DIVISIONS = "RoleReferenceDivisions";

    public void put(Map<String, BaseProperty> properties, NodeWrapper wrapper) {
        Node node = wrapper.getNode();
        int index = wrapper.index;
        this.path = wrapper.path;
        String key = TagUtility.getKey((Node)node);
        if (key.isEmpty()) {
            TagUtility.noElementKeyMessage((String)this.path, (Node)node, (int)index);
            return;
        }
        Number number = TagUtility.getNumber((String)"count(*)", (Object)node);
        if (number.intValue() == 0) {
            TagUtility.invalidMassage((String)this.path, (Node)node);
            return;
        }
        BaseProperty baseProperty = properties.get(key);
        if (baseProperty == null) {
            baseProperty = new RoleProperty(key);
        }
        RoleProperty property = (RoleProperty)baseProperty;
        Map roleMenuMap = property.getRoleMenuMap();
        List acceptCmdList = property.getAcceptCmdList();
        List rejectCmdList = property.getRejectCmdList();
        List hiddenDivisionsList = property.getHiddenDivisionsList();
        List referenceDivisionsList = property.getReferenceDivisionsList();
        boolean roleInvalid = false;
        NodeList list = node.getChildNodes();
        int length = list.getLength();
        for (int itemIndex = 0; itemIndex < length; ++itemIndex) {
            Node item = list.item(itemIndex);
            if (TagUtility.isTag((Node)item, (String)TAG_ROLE_NAME)) {
                property.setRoleName(TagUtility.trimText((Node)item));
            }
            if (TagUtility.isTag((Node)item, (String)TAG_ROLE_EXTRA)) {
                property.setRoleExtra(TagUtility.trimText((Node)item));
            }
            if (TagUtility.isTag((Node)item, (String)TAG_VIEW_INDEX)) {
                try {
                    property.setViewIndex(Integer.parseInt(TagUtility.trimText((Node)item)));
                }
                catch (NumberFormatException e) {
                    TagUtility.invalidItemMassage((String)this.path, (Node)node, (String)TAG_VIEW_INDEX, (int)index);
                }
            }
            if (TagUtility.isTag((Node)item, (String)TAG_ROLE_AUTHORITY)) {
                property.setRoleAuthority(TagUtility.trimText((Node)item));
            }
            if (TagUtility.isTag((Node)item, (String)TAG_ROLE_CHARGE)) {
                property.setRoleCharge(TagUtility.trimText((Node)item));
            }
            if (TagUtility.isTag((Node)item, (String)TAG_ROLE_INVALID)) {
                roleInvalid = Boolean.parseBoolean(TagUtility.trimText((Node)item));
            }
            if (TagUtility.isTag((Node)item, (String)TAG_ROLE_ACCEPT_COMMAND)) {
                acceptCmdList.add(TagUtility.trimText((Node)item));
            }
            if (TagUtility.isTag((Node)item, (String)TAG_ROLE_REJECT_COMMAND)) {
                rejectCmdList.add(TagUtility.trimText((Node)item));
            }
            if (TagUtility.isTag((Node)item, (String)TAG_ROLE_ACCEPT_REMOVE)) {
                acceptCmdList.remove(TagUtility.trimText((Node)item));
            }
            if (TagUtility.isTag((Node)item, (String)TAG_ROLE_REJECT_REMOVE)) {
                rejectCmdList.remove(TagUtility.trimText((Node)item));
            }
            if (TagUtility.isTag((Node)item, (String)TAG_ROLE_HIDDEN_DIVISIONS)) {
                hiddenDivisionsList.addAll(MospUtility.asList((String[])MospUtility.split((String)TagUtility.trimText((Node)item), (String)",")));
            }
            if (TagUtility.isTag((Node)item, (String)TAG_ROLE_REFERENCE_DIVISIONS)) {
                referenceDivisionsList.addAll(MospUtility.asList((String[])MospUtility.split((String)TagUtility.trimText((Node)item), (String)",")));
            }
            if (TagUtility.isTag((Node)item, (String)TAG_MENU)) {
                RoleMenuProperty menu = this.toRoleMenuProperty(item);
                if (menu == null) {
                    TagUtility.invalidItemMassage((String)this.path, (Node)node, (String)TAG_MENU, (int)itemIndex);
                } else {
                    roleMenuMap.put(menu.getKey(), menu);
                }
            }
            if (!TagUtility.isTag((Node)item, (String)TAG_ROLE_MENU_REMOVE)) continue;
            this.removeRoleMenu(TagUtility.trimText((Node)item), roleMenuMap);
        }
        properties.put(key, (BaseProperty)property);
        if (roleInvalid) {
            properties.remove(key);
        }
    }

    protected RoleMenuProperty toRoleMenuProperty(Node item) {
        String key = TagUtility.getKey((Node)item);
        if (key.isEmpty()) {
            return null;
        }
        Integer index = null;
        HashMap<String, RangeProperty> rangeMap = new HashMap<String, RangeProperty>();
        NodeList list = item.getChildNodes();
        int length = list.getLength();
        for (int itemIndex = 0; itemIndex < length; ++itemIndex) {
            Node menuItem = list.item(itemIndex);
            if (TagUtility.isTag((Node)menuItem, (String)TAG_INDEX)) {
                try {
                    index = Integer.parseInt(TagUtility.trimText((Node)menuItem));
                }
                catch (NumberFormatException e) {
                    TagUtility.invalidItemMassage((String)this.path, (Node)item, (String)TAG_INDEX, (int)itemIndex);
                }
            }
            if (!TagUtility.isTag((Node)menuItem, (String)TAG_RANGE)) continue;
            RangeProperty range = this.toRangeProperty(menuItem);
            if (range == null) {
                TagUtility.invalidItemMassage((String)this.path, (Node)item, (String)TAG_RANGE, (int)itemIndex);
                continue;
            }
            rangeMap.put(range.getKey(), range);
        }
        return new RoleMenuProperty(key, index, rangeMap);
    }

    protected void removeRoleMenu(String keys, Map<String, RoleMenuProperty> roleMenuMap) {
        String[] keyArray;
        if (keys == null) {
            return;
        }
        for (String key : keyArray = MospUtility.split((String)keys, (String)",")) {
            roleMenuMap.remove(key);
        }
    }

    protected RangeProperty toRangeProperty(Node item) {
        String key = TagUtility.getKey((Node)item);
        if (key.isEmpty()) {
            return null;
        }
        String operationType = key;
        String workPlace = null;
        String employmentContract = null;
        String section = null;
        String position = null;
        String employee = null;
        NodeList list = item.getChildNodes();
        int length = list.getLength();
        for (int index = 0; index < length; ++index) {
            Node rangeItem = list.item(index);
            if (TagUtility.isTag((Node)rangeItem, (String)TAG_WORK_PLACE)) {
                workPlace = TagUtility.trimText((Node)rangeItem);
            }
            if (TagUtility.isTag((Node)rangeItem, (String)TAG_EMPLOYMENT_CONTRACT)) {
                employmentContract = TagUtility.trimText((Node)rangeItem);
            }
            if (TagUtility.isTag((Node)rangeItem, (String)TAG_SECTION)) {
                section = TagUtility.trimText((Node)rangeItem);
            }
            if (TagUtility.isTag((Node)rangeItem, (String)TAG_POSITION)) {
                position = TagUtility.trimText((Node)rangeItem);
            }
            if (!TagUtility.isTag((Node)rangeItem, (String)TAG_EMPLOYEE)) continue;
            employee = TagUtility.trimText((Node)rangeItem);
        }
        return new RangeProperty(operationType, workPlace, employmentContract, section, position, employee);
    }
}

