/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseAction;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParametersMapper;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.base.TopicPath;
import jp.mosp.framework.instance.InstanceFactory;
import jp.mosp.framework.property.RoleMenuProperty;
import jp.mosp.framework.property.RoleProperty;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.TopicPathUtility;
import jp.mosp.framework.utils.ViewFileLocationUtility;
import jp.mosp.platform.base.PlatformBeanHandlerInterface;
import jp.mosp.platform.base.PlatformVo;
import jp.mosp.platform.base.ReferenceBeanHandlerInterface;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.dto.base.PersonalIdDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;
import jp.mosp.platform.utils.PlatformMessageUtility;

public abstract class PlatformAction
extends BaseAction {
    public static final String APP_TEMPLATE_JSP = "TemplateJsp";
    public static final String APP_NAVI_JSP = "NaviJsp";
    public static final String APP_BASE_CSS_FILES = "BaseCssFiles";
    public static final String APP_BASE_JS_FILES = "BaseJsFiles";
    protected static final String APP_COMMAND_PORTAL = "CommandPortal";
    protected static final String APP_COMMAND_INDEX = "CommandIndex";
    protected static final String APP_LIST_LENGTH = "ListLength";
    protected static final String MGP_JS_SCROLL_TO = "jsScrollTo";
    protected static final String MEN_MAIN_TOP = "Top";
    protected PlatformBeanHandlerInterface platform;
    protected ReferenceBeanHandlerInterface platformReference;
    protected String topicPathCommand = null;

    protected void preAction() throws MospException {
        super.preAction();
        String menuKey = this.getTransferredMenuKey();
        this.checkLoginUser();
        if (menuKey != null && !menuKey.isEmpty() && this.mospParams.getNextCount() == 0) {
            this.setRangeMap(menuKey);
            this.removeAfterIndex(this.mospParams.getTopicPathList(), 0);
        }
        if (this.mospParams.getUser() != null) {
            this.reference().preAction().preAction();
        }
    }

    protected void checkLoginUser() throws MospException {
        if (this.mospParams.getUser() == null) {
            return;
        }
        String userlId = this.mospParams.getUser().getUserId();
        String personalId = this.mospParams.getUser().getPersonalId();
        Date systemTime = DateUtility.getSystemTime();
        UserMasterDtoInterface userMasterDto = this.reference().user().getUserInfo(userlId, systemTime);
        HumanDtoInterface humanDto = this.reference().human().getHumanInfo(personalId, systemTime);
        if (userMasterDto == null || humanDto == null) {
            this.mospParams.getStoredInfo().initStoredInfo();
            String nextCommand = this.mospParams.getApplicationProperty(APP_COMMAND_INDEX);
            this.mospParams.setNextCommand(nextCommand);
            this.mospParams.addErrorMessage("PFW0235", new String[0]);
            throw new MospException("PFW0235");
        }
    }

    protected void setRangeMap(String menuKey) {
        RoleProperty role = this.mospParams.getUserRole();
        RoleMenuProperty menu = (RoleMenuProperty)role.getRoleMenuMap().get(menuKey);
        this.mospParams.getStoredInfo().setRangeMap(menu.getRangeMap());
    }

    protected void checkRangeMap(String menuKey) {
        Map rangeMap = this.mospParams.getStoredInfo().getRangeMap();
        if (rangeMap != null && !rangeMap.isEmpty()) {
            return;
        }
        this.setRangeMap(menuKey);
    }

    protected BaseVo prepareVo() throws MospException {
        return this.prepareVo(true, true);
    }

    protected BaseVo prepareVo(boolean useStoredVo, boolean useParametersMapper) throws MospException {
        BaseVo baseVo = this.getSpecificVo();
        BaseVo storedVo = this.mospParams.getStoredVo(baseVo.getClassName());
        if (storedVo != null && useStoredVo) {
            baseVo = storedVo;
        }
        if (useParametersMapper) {
            MospParametersMapper.mapParameters((Object)baseVo, (Map)this.mospParams.getRequestParamsMap());
        }
        this.setTemplateUrl();
        this.addBaseJsCssFiles();
        this.setViewPath(baseVo.getClassName());
        this.mospParams.setVo(baseVo);
        this.setTopicPath();
        return baseVo;
    }

    protected BaseVo getSpecificVo() {
        return new PlatformVo();
    }

    protected void setViewPath(String className) {
        ViewFileLocationUtility location = new ViewFileLocationUtility(className);
        this.mospParams.setArticleUrl(location.getRetUrl());
        this.mospParams.addCssFile(location.getExtraCss());
        this.mospParams.addJsFile(location.getExtraJs());
    }

    protected void setTemplateUrl() {
        this.mospParams.setUrl(this.mospParams.getApplicationProperty(APP_TEMPLATE_JSP));
        this.mospParams.setNaviUrl(this.mospParams.getApplicationProperty(APP_NAVI_JSP));
    }

    protected void addBaseJsCssFiles() {
        String[] baseCssFiles = this.mospParams.getApplicationProperties(APP_BASE_CSS_FILES);
        String[] baseJsFiles = this.mospParams.getApplicationProperties(APP_BASE_JS_FILES);
        for (String baseCssFile : baseCssFiles) {
            this.mospParams.addCssFile(baseCssFile);
        }
        for (String baseJsFile : baseJsFiles) {
            this.mospParams.addJsFile(baseJsFile);
        }
    }

    private void setTopicPath() {
        BaseVo vo;
        List topicPathList = this.mospParams.getTopicPathList();
        int idx = TopicPathUtility.getTopicPathIndex((List)topicPathList, (String)(vo = this.mospParams.getVo()).getClassName());
        if (idx >= 0) {
            this.removeAfterIndex(topicPathList, idx);
            ((TopicPath)topicPathList.get(idx)).setVo(vo);
            return;
        }
        topicPathList.add(this.createTopicPath());
    }

    private TopicPath createTopicPath() {
        TopicPath topicPath = new TopicPath();
        BaseVo vo = this.mospParams.getVo();
        topicPath.setId(vo.getClassName());
        topicPath.setName(this.mospParams.getName(vo.getClassName()));
        topicPath.setVo(vo);
        topicPath.setMenuKey(this.getTransferredMenuKey());
        if (this.topicPathCommand != null && !this.topicPathCommand.isEmpty()) {
            topicPath.setCommand(this.topicPathCommand);
        } else {
            topicPath.setCommand(this.mospParams.getCommand());
        }
        return topicPath;
    }

    protected void removeAfterIndex(List<?> list, int index) {
        for (int i = list.size() - 1; i > index; --i) {
            list.remove(i);
        }
    }

    protected PlatformBeanHandlerInterface platform() throws MospException {
        if (this.platform != null) {
            return this.platform;
        }
        this.platform = (PlatformBeanHandlerInterface)this.createHandler(PlatformBeanHandlerInterface.class);
        return this.platform;
    }

    protected ReferenceBeanHandlerInterface reference() throws MospException {
        if (this.platformReference != null) {
            return this.platformReference;
        }
        this.platformReference = (ReferenceBeanHandlerInterface)this.createHandler(ReferenceBeanHandlerInterface.class);
        return this.platformReference;
    }

    protected void setPageInfo(String command, int dataPerPage) {
        PlatformVo vo = (PlatformVo)this.mospParams.getVo();
        vo.setPageCommand(command);
        vo.setDataPerPage(dataPerPage);
        vo.setSelectIndex(String.valueOf(1));
    }

    protected int getListLength() {
        return this.mospParams.getApplicationProperty(APP_LIST_LENGTH, 0);
    }

    public List<? extends BaseDtoInterface> sortList(String sortKey) throws MospException {
        PlatformVo vo = (PlatformVo)this.mospParams.getVo();
        if (vo.getComparatorName().equals(sortKey)) {
            if (vo.isAscending()) {
                vo.setAscending(false);
            } else {
                vo.setAscending(true);
            }
        } else {
            vo.setAscending(false);
        }
        if (sortKey != null) {
            vo.setComparatorName(sortKey);
        }
        Comparator comp = InstanceFactory.loadComparator((String)vo.getComparatorName());
        if (vo.isAscending()) {
            Collections.sort(vo.getList(), Collections.reverseOrder(comp));
        } else {
            Collections.sort(vo.getList(), comp);
        }
        return this.getFirstPageList();
    }

    protected List<? extends BaseDtoInterface> getFirstPageList() {
        PlatformVo vo = (PlatformVo)this.mospParams.getVo();
        vo.setSelectIndex(String.valueOf(1));
        return this.pageList();
    }

    protected List<? extends BaseDtoInterface> pageList() {
        PlatformVo vo = (PlatformVo)this.mospParams.getVo();
        int offset = (Integer.parseInt(vo.getSelectIndex()) - 1) * vo.getDataPerPage();
        ArrayList list = new ArrayList();
        for (int i = offset; i < (offset + vo.getDataPerPage() < vo.getList().size() ? offset + vo.getDataPerPage() : vo.getList().size()); ++i) {
            list.add(vo.getList().get(i));
        }
        return list;
    }

    protected BaseDtoInterface[] getArray() {
        PlatformVo vo = (PlatformVo)this.mospParams.getVo();
        return vo.getList().toArray(new BaseDtoInterface[0]);
    }

    protected void checkRange(String personalId, Date targetDate, String operationType) throws MospException {
        HumanSearchBeanInterface bean = this.reference().humanSearch();
        bean.setTargetDate(targetDate);
        bean.setEmployeeCode(this.reference().human().getEmployeeCode(personalId, targetDate));
        bean.setEmployeeCodeType("exact");
        bean.setOperationType(operationType);
        List list = bean.search();
        if (list.size() == 1) {
            return;
        }
        this.mospParams.setNextCommand(((TopicPath)this.mospParams.getTopicPathList().get(0)).getCommand());
        this.mospParams.addErrorMessage("FWW0102", new String[0]);
        throw new MospException("FWW0102");
    }

    protected void throwInvalidCommandException() throws MospException {
        String[] rep = new String[]{this.getClass().getName(), this.mospParams.getCommand()};
        this.mospParams.setErrorViewUrl();
        throw new MospException("FWE9111", rep);
    }

    protected Date getSystemDate() {
        return DateUtility.getSystemDate();
    }

    protected Date getDate(String date) {
        return DateUtility.getDate((String)date);
    }

    protected String getStringDate(Date date) {
        return DateUtility.getStringDate((Date)date);
    }

    protected String getStringDateAndDay(Date date) {
        return DateUtility.getStringDateAndDay((Date)date);
    }

    protected String getStringTime(Date date) {
        return DateUtility.getStringTime((Date)date);
    }

    protected String getStringYear(Date date) {
        return DateUtility.getStringYear((Date)date);
    }

    protected String getStringMonth(Date date) {
        return DateUtility.getStringMonth((Date)date);
    }

    protected String getStringDay(Date date) {
        return DateUtility.getStringDay((Date)date);
    }

    protected String getStringHour(Date date) {
        return DateUtility.getStringHour((Date)date);
    }

    protected String getStringMinute(Date date) {
        return DateUtility.getStringMinute((Date)date);
    }

    protected Date getDate(String year, String month, String day) {
        try {
            return DateUtility.getDate((String)year, (String)month, (String)day);
        }
        catch (Throwable e) {
            this.mospParams.addErrorMessage("PFW0116", new String[0]);
            return null;
        }
    }

    protected Date getTime(String hour, String minute) {
        try {
            return DateUtility.getTime((String)hour, (String)minute);
        }
        catch (Throwable e) {
            this.mospParams.addErrorMessage("PFW0121", new String[0]);
            return null;
        }
    }

    protected long getLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (Throwable e) {
            this.mospParams.addErrorMessage("PFW0112", new String[0]);
            return 0L;
        }
    }

    protected int getInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Throwable e) {
            this.mospParams.addErrorMessage("PFW0112", new String[0]);
            return 0;
        }
    }

    protected double getDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (Throwable e) {
            this.mospParams.addErrorMessage("PFW0112", new String[0]);
            return 0.0;
        }
    }

    protected String[][] getCodeArray(String codeKey, boolean needBlank) {
        return this.mospParams.getProperties().getCodeArray(codeKey, needBlank);
    }

    protected String getCodeName(String code, String codeKey) {
        return MospUtility.getCodeName((MospParams)this.mospParams, (String)code, (String)codeKey);
    }

    protected String getCodeName(int code, String codeKey) {
        return MospUtility.getCodeName((MospParams)this.mospParams, (int)code, (String)codeKey);
    }

    protected String getCodeItemCode(String code, String codeKey) {
        return MospUtility.getCodeItemCode((String)code, (String[][])this.getCodeArray(codeKey, false));
    }

    protected String getCodeItemCode(int code, String codeKey) {
        return this.getCodeItemCode(String.valueOf(code), codeKey);
    }

    protected String[][] addArrayString(String[][] aryItem, String[][] aryAddItem) {
        String[][] lblExportItem = new String[aryItem.length + aryAddItem.length][2];
        for (int i = 0; i < lblExportItem.length; ++i) {
            lblExportItem[i] = i < aryItem.length ? aryItem[i] : aryAddItem[i - aryItem.length];
        }
        return lblExportItem;
    }

    protected String getInactivateFlagName(int inactivateFlag) {
        return this.getCodeName(inactivateFlag, "InactivateFlag");
    }

    protected String getInsertUserName(BaseDtoInterface dto) throws MospException {
        UserMasterDtoInterface userDto = this.reference().user().getUserInfo(dto.getInsertUser(), dto.getInsertDate());
        if (userDto == null) {
            return "";
        }
        HumanDtoInterface humanDto = this.getHumanInfo(userDto.getPersonalId(), dto.getInsertDate());
        if (humanDto == null) {
            return "";
        }
        return MospUtility.getHumansName((String)humanDto.getFirstName(), (String)humanDto.getLastName());
    }

    protected HumanDtoInterface getHumanInfo(String personalId, Date targetDate) throws MospException {
        return this.reference().human().getHumanInfo(personalId, targetDate);
    }

    public String getLastFirstName(String lastName, String firstName) {
        return MospUtility.getHumansName((String)firstName, (String)lastName);
    }

    protected String getEmployeeName(String personalId) throws MospException {
        HumanDtoInterface humanDto = this.getHumanInfo(personalId, this.getSystemDate());
        if (humanDto == null) {
            PlatformMessageUtility.addErrorEmployeeNotExist((MospParams)this.mospParams);
            return null;
        }
        return this.getLastFirstName(humanDto.getLastName(), humanDto.getFirstName());
    }

    protected String getEmployeeCode(String personalId) throws MospException {
        HumanDtoInterface humanDto = this.getHumanInfo(personalId, this.getSystemDate());
        if (humanDto == null) {
            PlatformMessageUtility.addErrorEmployeeNotExist((MospParams)this.mospParams);
            return null;
        }
        return humanDto.getEmployeeCode();
    }

    protected String[][] getInputActivateDatePulldown() {
        String[][] aryPulldown = new String[][]{{"", this.mospParams.getName("InputActiveDate")}};
        return aryPulldown;
    }

    protected String[][] getInputStartDatePulldown() {
        String[][] aryPulldown = new String[][]{{"", this.mospParams.getName("InputStartDate")}};
        return aryPulldown;
    }

    protected String[][] getInputTermPulldown() {
        String[][] aryPulldown = new String[][]{{"", this.mospParams.getName("InputTerm")}};
        return aryPulldown;
    }

    protected String[][] getSearchCodePulldown() {
        String[][] aryPulldown = new String[][]{{"", this.mospParams.getName("SearchCode")}};
        return aryPulldown;
    }

    protected String[][] getPleaseSearchPulldown() {
        String[][] aryPulldown = new String[][]{{"", this.mospParams.getName("PleaseSearch")}};
        return aryPulldown;
    }

    protected long[] getIdArray(String[] aryString) {
        if (aryString == null) {
            return new long[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String id : aryString) {
            if (id == null || id.isEmpty() || this.getLong(id) == 0L) continue;
            list.add(id);
        }
        long[] aryLong = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            aryLong[i] = this.getLong((String)list.get(i));
        }
        return aryLong;
    }

    protected int[] getIndexArray(String[] aryString) {
        if (aryString == null) {
            return new int[0];
        }
        int[] aryInt = new int[aryString.length];
        for (int i = 0; i < aryString.length; ++i) {
            aryInt[i] = this.getInt(aryString[i]);
        }
        return aryInt;
    }

    protected boolean isIndexed(int target, int[] aryIndex) {
        for (int idx : aryIndex) {
            if (target != idx) continue;
            return true;
        }
        return false;
    }

    protected long[] getIdArray(int[] aryIndex, String[] aryId) {
        if (aryIndex == null) {
            return new long[0];
        }
        String[] idArray = new String[aryIndex.length];
        for (int i = 0; i < aryIndex.length; ++i) {
            idArray[i] = aryId[aryIndex[i]];
        }
        return this.getIdArray(idArray);
    }

    protected BaseDtoInterface getSelectedListDto(String idx) {
        return this.getSelectedListDto(this.getInt(idx));
    }

    protected BaseDtoInterface getSelectedListDto(int idx) {
        PlatformVo vo = (PlatformVo)this.mospParams.getVo();
        int offset = (this.getInt(vo.getSelectIndex()) - 1) * vo.getDataPerPage();
        int index = offset + idx;
        return (BaseDtoInterface)vo.getList().get(index);
    }

    protected String getSelectedPersonalId(int idx) {
        PersonalIdDtoInterface dto = (PersonalIdDtoInterface)this.getSelectedListDto(idx);
        return dto.getPersonalId();
    }

    protected String getSelectedPersonalId(String idx) {
        return this.getSelectedPersonalId(this.getInt(idx));
    }

    protected String[] getSelectedPersonalIds(String[] indexes) {
        ArrayList<String> list = new ArrayList<String>();
        for (String idx : indexes) {
            list.add(this.getSelectedPersonalId(idx));
        }
        return MospUtility.toArray(list);
    }

    protected void checkSelectedDataExist(Object obj) throws MospException {
        if (obj != null) {
            return;
        }
        this.mospParams.addErrorMessage("PFW0201", new String[]{this.mospParams.getName("Information")});
        this.mospParams.setNextCommand(this.mospParams.getApplicationProperty(APP_COMMAND_PORTAL));
        throw new MospException("FWW0101");
    }

    protected void setJsScrollTo(String target) {
        this.mospParams.addGeneralParam(MGP_JS_SCROLL_TO, (Object)target);
    }

    protected void setModeActivateDate(String modeActivateDate) {
        PlatformVo vo = (PlatformVo)this.mospParams.getVo();
        vo.setModeActivateDate(modeActivateDate);
    }

    protected boolean setApproverPullDown(String personalId, Date date, int workflowType) throws MospException {
        PlatformVo vo = (PlatformVo)this.mospParams.getVo();
        String[][][] aryApproverInfo = this.reference().workflowIntegrate().getArrayForApproverSetting(personalId, date, workflowType);
        if (aryApproverInfo.length == 0) {
            this.addApproverNotExistMessage(workflowType);
        }
        if (this.mospParams.hasErrorMessage()) {
            return false;
        }
        vo.setAryApproverInfo(aryApproverInfo);
        String[] aryPltLblApproverSetting = new String[aryApproverInfo.length];
        for (int i = 0; i < aryPltLblApproverSetting.length; ++i) {
            aryPltLblApproverSetting[i] = String.valueOf(i + 1) + this.mospParams.getName("Following") + this.mospParams.getName("Approver");
        }
        vo.setAryPltLblApproverSetting(aryPltLblApproverSetting);
        String[] aryApproverSetting = new String[]{vo.getPltApproverSetting1(), vo.getPltApproverSetting2(), vo.getPltApproverSetting3(), vo.getPltApproverSetting4(), vo.getPltApproverSetting5(), vo.getPltApproverSetting6(), vo.getPltApproverSetting7(), vo.getPltApproverSetting8(), vo.getPltApproverSetting9(), vo.getPltApproverSetting10()};
        vo.setAryPltApproverSetting(aryApproverSetting);
        String[] pltApproverSetting = new String[]{"pltApproverSetting1", "pltApproverSetting2", "pltApproverSetting3", "pltApproverSetting4", "pltApproverSetting5", "pltApproverSetting6", "pltApproverSetting7", "pltApproverSetting8", "pltApproverSetting9", "pltApproverSetting10"};
        vo.setPltApproverSetting(pltApproverSetting);
        return true;
    }

    protected void addApproverNotExistMessage(int workflowType) {
        String workflowName = "";
        if (workflowType == 1) {
            workflowName = this.mospParams.getName("WorkManage");
        } else if (workflowType == 2) {
            workflowName = this.mospParams.getName("HumanInfo");
        }
        this.mospParams.addErrorMessage("PFW0227", new String[]{workflowName + this.mospParams.getName("Approver"), this.mospParams.getName("Application", new String[]{"Day"})});
    }

    protected void checkSearchCondition(String ... condition) {
        if (!this.isSearchConditionRequired()) {
            return;
        }
        if (this.hasSearchCondition(condition)) {
            return;
        }
        this.mospParams.addErrorMessage("PFW0234", new String[0]);
    }

    protected boolean isSearchConditionRequired() {
        return this.mospParams.getApplicationPropertyBool("SearchConditionRequired");
    }

    protected boolean hasSearchCondition(String ... condition) {
        return !this.isEmpty(condition);
    }

    protected boolean isEmpty(String ... strings) {
        for (String string : strings) {
            if (string.isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected Date getDateFromString(String strDate, String fieldName, Integer row) {
        if (strDate == null || strDate.isEmpty()) {
            return null;
        }
        Date date = DateUtility.getVariousDate((String)strDate);
        if (date != null) {
            return date;
        }
        PlatformMessageUtility.addErrorDateInvalid((MospParams)this.mospParams, (String)fieldName, (Integer)row);
        return date;
    }

    protected String getDocBase() {
        return this.mospParams.getApplicationProperty("Docbase");
    }

    protected int getTransferredIndex() {
        return this.getInt(this.mospParams.getRequestParam("transferredIndex"));
    }

    protected void setTargetPersonalId(String targetPersonalId) {
        this.mospParams.addGeneralParam("prmTargetPersonalId", (Object)targetPersonalId);
    }

    protected String getTargetPersonalId() {
        return (String)this.mospParams.getGeneralParam("prmTargetPersonalId");
    }

    protected void setTargetDate(Date targetDate) {
        this.mospParams.addGeneralParam("prmTargetDate", (Object)targetDate);
    }

    protected Date getTargetDate() {
        return (Date)this.mospParams.getGeneralParam("prmTargetDate");
    }

    protected String getTransferredMenuKey() {
        String key = this.mospParams.getRequestParam("transferredMenuKey");
        if (key != null && key.equals(MEN_MAIN_TOP)) {
            key = null;
        }
        return key;
    }

    protected String getTransferredCode() {
        return this.mospParams.getRequestParam("transferredCode");
    }

    protected String getTransferredWorkflow() {
        return this.mospParams.getRequestParam("transferredWorkflow");
    }

    protected String getTransferredRecordId() {
        return this.mospParams.getRequestParam("transferredRecordId");
    }

    protected String getTransferredActivateDate() {
        return this.mospParams.getRequestParam("transferredActivateDate");
    }

    protected String getTransferredType() {
        return this.mospParams.getRequestParam("transferredType");
    }

    protected String getTransferredCommand() {
        return this.mospParams.getRequestParam("transferredCommand");
    }

    protected String getTransferredSortKey() {
        return this.mospParams.getRequestParam("transferredSortKey");
    }

    protected String getTransferredAction() {
        return this.mospParams.getRequestParam("transferredAction");
    }

    protected void addNoSearchResultMessage() {
        this.mospParams.addMessage("PFI0102", new String[0]);
    }

    protected void addInsertMessage() {
        String rep = this.mospParams.getName("Insert");
        this.mospParams.addMessage("PFI0001", new String[]{rep});
    }

    protected void addUpdateMessage() {
        String[] aryMeassage = new String[]{this.mospParams.getName("Update")};
        this.mospParams.addMessage("PFI0001", aryMeassage);
    }

    protected void addInsertNewMessage() {
        PlatformMessageUtility.addInsertNewSucceed((MospParams)this.mospParams);
    }

    protected void addInsertHistoryMessage() {
        String rep = this.mospParams.getName("History", new String[]{"Add"});
        this.mospParams.addMessage("PFI0001", new String[]{rep});
    }

    protected void addUpdateHistoryMessage() {
        String rep = this.mospParams.getName("History", new String[]{"Edit"});
        this.mospParams.addMessage("PFI0001", new String[]{rep});
    }

    protected void addDeleteMessage() {
        String rep = this.mospParams.getName("Delete");
        this.mospParams.addMessage("PFI0001", new String[]{rep});
    }

    protected void addDeleteHistoryMessage(int count) {
        String rep = String.valueOf(count);
        this.mospParams.addMessage("PFI0003", new String[]{rep});
    }

    protected void addImportMessage(int count) {
        String rep = String.valueOf(count);
        this.mospParams.addMessage("PFI0004", new String[]{rep});
    }

    protected void addInsertFailedMessage() {
        String rep = this.mospParams.getName("Insert");
        this.mospParams.addMessage("PFI0002", new String[]{rep});
    }

    protected void addUpdateFailedMessage() {
        String rep = this.mospParams.getName("Update");
        this.mospParams.addMessage("PFI0002", new String[]{rep});
    }

    protected void addBatchUpdateFailedMessage() {
        String rep = this.mospParams.getName("Bulk", new String[]{"Update"});
        this.mospParams.addMessage("PFI0002", new String[]{rep});
    }

    protected void addDeleteFailedMessage() {
        String rep = this.mospParams.getName("Delete");
        this.mospParams.addMessage("PFI0002", new String[]{rep});
    }

    protected void addDeleteHistoryFailedMessage() {
        String rep = this.mospParams.getName("History", new String[]{"Delete"});
        this.mospParams.addMessage("PFI0002", new String[]{rep});
    }

    protected void addFixFailedMessage() {
        String rep = this.mospParams.getName("Decision");
        this.mospParams.addMessage("PFI0002", new String[]{rep});
    }

    protected void addSendMailFailedMessage() {
        this.mospParams.addMessage("PFI0002", new String[]{this.mospParams.getName("SendMail")});
    }

    protected void addNotJoinedEmployeesErrorMessage(Date targetDate, String employeesCode) {
        this.mospParams.addErrorMessage("PFW0230", new String[]{DateUtility.getStringDate((Date)targetDate), employeesCode});
    }

    protected void addNotRetirementEmployeesErrorMessage(Date targetDate, String employeesCode) {
        this.mospParams.addErrorMessage("PFW0231", new String[]{DateUtility.getStringDate((Date)targetDate), employeesCode});
    }
}

