/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file;

import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.orangesignal.OrangeSignalParams;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.file.ImportFieldReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.dto.file.ImportFieldDtoInterface;

public abstract class PlatformFileBean
extends PlatformBean {
    public PlatformFileBean() {
    }

    protected PlatformFileBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    protected List<String[]> getDataList(ImportDtoInterface importDto, InputStream requestedFile) throws MospException {
        List<Object> dataList = new ArrayList<String[]>();
        if (!importDto.getType().equals("1")) {
            this.addFileTypeNotExistMessage();
            return dataList;
        }
        dataList = this.parse(requestedFile);
        if (importDto.getHeader() != 0 && dataList.size() > 0) {
            dataList.remove(0);
        }
        if (dataList.size() == 0) {
            this.addFileDataNotExistMessage();
        }
        return dataList;
    }

    protected void convertEmployeeCodeIntoPersonalId(List<ImportFieldDtoInterface> fieldList, List<String[]> dataList, String activateDateField, String activateDateName) throws MospException {
        Integer personalIdIndex = this.getFieldIndex("personal_id", fieldList);
        Integer activateDateIndex = this.getFieldIndex(activateDateField, fieldList);
        if (personalIdIndex == null || activateDateIndex == null) {
            return;
        }
        HumanReferenceBeanInterface refer = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
        for (int i = 0; i < dataList.size(); ++i) {
            String personalId;
            String[] data = dataList.get(i);
            String employeeCode = this.getFieldValue("personal_id", fieldList, data);
            Date activateDate = this.getDateFieldValue(activateDateField, fieldList, data);
            int row = i + 1;
            this.checkRequired((Object)employeeCode, this.getNameEmployeeCode(), Integer.valueOf(row));
            this.checkRequired((Object)activateDate, activateDateName, Integer.valueOf(row));
            if (employeeCode == null || employeeCode.isEmpty() || activateDate == null) continue;
            data[personalIdIndex.intValue()] = personalId = refer.getPersonalId(employeeCode, activateDate);
        }
    }

    protected void convertEmployeeCodeIntoPersonalId(List<ImportFieldDtoInterface> fieldList, List<String[]> dataList) throws MospException {
        this.convertEmployeeCodeIntoPersonalId(fieldList, dataList, "activate_date", this.getNameActivateDate());
    }

    protected List<String[]> parse(InputStream stream) throws MospException {
        return this.parse(stream, this.createOrangeSignalParams());
    }

    protected List<String[]> parse(InputStream stream, OrangeSignalParams orangeParams) throws MospException {
        List list = OrangeSignalUtility.parse((InputStream)stream, (OrangeSignalParams)orangeParams);
        return list;
    }

    protected OrangeSignalParams createOrangeSignalParams() {
        return new OrangeSignalParams();
    }

    protected List<ImportFieldDtoInterface> getImportFieldList(String importCode) throws MospException {
        ImportFieldReferenceBeanInterface refer = (ImportFieldReferenceBeanInterface)this.createBean(ImportFieldReferenceBeanInterface.class);
        return refer.getImportFieldList(importCode);
    }

    protected Integer getFieldIndex(String fieldName, List<ImportFieldDtoInterface> fieldList) {
        for (ImportFieldDtoInterface field : fieldList) {
            if (!field.getFieldName().equals(fieldName)) continue;
            return field.getFieldOrder() - 1;
        }
        return null;
    }

    protected String getFieldValue(String fieldName, List<ImportFieldDtoInterface> fieldList, String[] data) {
        Integer fieldIndex = this.getFieldIndex(fieldName, fieldList);
        if (fieldIndex == null) {
            return "";
        }
        return data[fieldIndex];
    }

    protected Date getDateFieldValue(String fieldName, List<ImportFieldDtoInterface> fieldList, String[] data) {
        String date = this.getFieldValue(fieldName, fieldList, data);
        if (date == null || date.isEmpty()) {
            return null;
        }
        return this.getDate(date);
    }

    protected Date getMinutesFieldValue(String fieldName, Date baseTime, List<ImportFieldDtoInterface> fieldList, String[] data) {
        Integer minutes = this.getInteger(this.getFieldValue(fieldName, fieldList, data));
        if (minutes == null || baseTime == null) {
            return null;
        }
        return DateUtility.addMinute((Date)baseTime, (int)minutes);
    }

    protected int getIntegerFieldValue(String fieldName, List<ImportFieldDtoInterface> fieldList, String[] data) {
        String strInteger = this.getFieldValue(fieldName, fieldList, data);
        if (strInteger == null || strInteger.isEmpty()) {
            return 0;
        }
        Integer objInteger = this.getInteger(strInteger);
        return objInteger == null ? 0 : objInteger;
    }

    protected double getDoubleFieldValue(String fieldName, List<ImportFieldDtoInterface> fieldList, String[] data) {
        String strDouble = this.getFieldValue(fieldName, fieldList, data);
        if (strDouble == null || strDouble.isEmpty()) {
            return 0.0;
        }
        Double objDouble = this.getDouble(strDouble);
        return objDouble == null ? 0.0 : objDouble;
    }

    protected void checkCsvLength(List<ImportFieldDtoInterface> fieldList, List<String[]> dataList) {
        for (int i = 0; i < dataList.size(); ++i) {
            if (dataList.get(i).length == fieldList.size()) continue;
            this.addDataLengthErrorMessage(i);
            break;
        }
    }

    protected Date getDate(String date) {
        if (date.indexOf("/") == -1) {
            return DateUtility.getDate((String)date, (String)"yyyyMMdd");
        }
        return DateUtility.getDate((String)date);
    }

    protected void addFileTypeNotExistMessage() {
        String[] rep = new String[]{this.mospParams.getName("Data", new String[]{"Type"})};
        this.mospParams.addErrorMessage("PFW0201", rep);
    }

    protected void addFileDataNotExistMessage() {
        String[] rep = new String[]{this.mospParams.getName("Insert", new String[]{"Data"})};
        this.mospParams.addErrorMessage("PFW0201", rep);
    }

    protected void addDataLengthErrorMessage(int row) {
        String rep = this.getRowColonName(row) + this.mospParams.getName("Insert", new String[]{"Data"});
        this.mospParams.addErrorMessage("PFW0115", new String[]{rep, null});
    }
}

