/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MessageUtility;
import jp.mosp.platform.bean.file.SectionImportBeanInterface;
import jp.mosp.platform.bean.system.impl.SectionRegistBean;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.dto.file.ImportFieldDtoInterface;
import jp.mosp.platform.dto.system.SectionDtoInterface;

public class SectionImportBean
extends SectionRegistBean
implements SectionImportBeanInterface {
    protected List<SectionDtoInterface> sectionList;

    public SectionImportBean() {
    }

    public SectionImportBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public int importFile(ImportDtoInterface importDto, InputStream requestedFile) throws MospException {
        List dataList = this.getDataList(importDto, requestedFile);
        this.getTargetLists(importDto, dataList);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        for (int i = 0; i < this.sectionList.size(); ++i) {
            this.registSectionDto((SectionDtoInterface)this.sectionList.get(i));
        }
        return this.sectionList.size();
    }

    protected void getTargetLists(ImportDtoInterface importDto, List<String[]> dataList) throws MospException {
        this.sectionList = new ArrayList();
        List fieldList = this.getImportFieldList(importDto.getImportCode());
        this.checkCsvLength(fieldList, dataList);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (int i = 0; i < dataList.size(); ++i) {
            String[] data = dataList.get(i);
            SectionDtoInterface sectionDto = this.getSectionDto(fieldList, data, i);
            if (sectionDto == null) continue;
            this.sectionList.add(sectionDto);
        }
        block1: for (SectionDtoInterface sectionDto : this.sectionList) {
            sectionDto.setClassRoute(",");
            SectionDtoInterface upperSectionDto = this.getUpperSection(sectionDto, dataList, fieldList);
            while (upperSectionDto != null) {
                if (upperSectionDto.getClassRoute() != null && upperSectionDto.getClassRoute().contains(",")) {
                    sectionDto.setClassRoute(upperSectionDto.getClassRoute() + upperSectionDto.getSectionCode() + sectionDto.getClassRoute());
                    continue block1;
                }
                sectionDto.setClassRoute("," + upperSectionDto.getSectionCode() + sectionDto.getClassRoute());
                upperSectionDto = this.getUpperSection(upperSectionDto, dataList, fieldList);
            }
        }
    }

    private SectionDtoInterface getUpperSection(SectionDtoInterface dto, List<String[]> dataList, List<ImportFieldDtoInterface> fieldList) throws MospException {
        String upperSectionCode = "";
        for (String[] data : dataList) {
            if (!dto.getSectionCode().equals(this.getFieldValue("section_code", fieldList, data)) || !dto.getActivateDate().equals(this.getDateFieldValue("activate_date", fieldList, data))) continue;
            upperSectionCode = this.getFieldValue("upper_section_code", fieldList, data);
        }
        if (upperSectionCode == null || upperSectionCode.isEmpty() || upperSectionCode.equals(dto.getSectionCode())) {
            return null;
        }
        Date maxUpperActivateDate = null;
        String upperInactivateFlag = Integer.toString(0);
        for (String[] data : dataList) {
            Date upperActivateDate;
            if (!upperSectionCode.equals(this.getFieldValue("section_code", fieldList, data)) || (upperActivateDate = this.getDateFieldValue("activate_date", fieldList, data)) == null || upperActivateDate.after(dto.getActivateDate()) || maxUpperActivateDate != null && maxUpperActivateDate.after(upperActivateDate)) continue;
            maxUpperActivateDate = upperActivateDate;
            upperInactivateFlag = this.getFieldValue("close_flag", fieldList, data);
        }
        SectionDtoInterface upperSectionDto = this.dao.findForInfo(upperSectionCode, dto.getActivateDate());
        if (upperSectionDto != null && (maxUpperActivateDate == null || upperSectionDto.getActivateDate().after(maxUpperActivateDate))) {
            if (upperSectionDto.getCloseFlag() == 0) {
                return upperSectionDto;
            }
            return null;
        }
        if (maxUpperActivateDate == null || Integer.toString(1).equals(upperInactivateFlag)) {
            return null;
        }
        SectionDtoInterface sectionDto = this.getInitDto();
        sectionDto.setSectionCode(upperSectionCode);
        sectionDto.setActivateDate(maxUpperActivateDate);
        sectionDto.setCloseFlag(Integer.parseInt(upperInactivateFlag));
        return sectionDto;
    }

    protected SectionDtoInterface getSectionDto(List<ImportFieldDtoInterface> fieldList, String[] data, int row) throws MospException {
        String sectionCode = this.getFieldValue("section_code", fieldList, data);
        Date activateDate = this.getDateFieldValue("activate_date", fieldList, data);
        String sectionName = this.getFieldValue("section_name", fieldList, data);
        String sectionAbbr = this.getFieldValue("section_abbr", fieldList, data);
        String sectionDisplay = this.getFieldValue("section_display", fieldList, data);
        String closeFlag = this.getFieldValue("close_flag", fieldList, data);
        if (sectionCode == null || sectionCode.isEmpty()) {
            this.addRequiredErrorMessage(this.getNameSectionCode(), Integer.valueOf(row));
            return null;
        }
        if (activateDate == null) {
            this.addRequiredErrorMessage(this.getNameActivateDate(), Integer.valueOf(row));
            return null;
        }
        SectionDtoInterface section = this.dao.findForInfo(sectionCode, activateDate);
        if (section == null) {
            section = this.getInitDto();
        }
        section.setSectionCode(sectionCode);
        section.setActivateDate(activateDate);
        if (sectionName != null) {
            section.setSectionName(sectionName);
        } else if (section.getSectionName() == null) {
            section.setSectionName("");
        }
        if (sectionAbbr != null) {
            section.setSectionAbbr(sectionAbbr);
        } else if (section.getSectionAbbr() == null) {
            section.setSectionAbbr("");
        }
        if (sectionDisplay != null) {
            section.setSectionDisplay(sectionDisplay);
        } else if (section.getSectionDisplay() == null) {
            section.setSectionDisplay("");
        }
        section.setCloseFlag(0);
        if (closeFlag != null && !closeFlag.isEmpty()) {
            try {
                section.setCloseFlag(Integer.parseInt(closeFlag));
            }
            catch (NumberFormatException e) {
                MessageUtility.addErrorMessageActivateOrInactivateInvalid((MospParams)this.mospParams, (Integer)row);
                return null;
            }
        }
        this.validate(section, Integer.valueOf(row));
        return section;
    }

    protected void registSectionDto(SectionDtoInterface section) throws MospException {
        if (section == null) {
            return;
        }
        List list = this.dao.findForHistory(section.getSectionCode());
        if (list.isEmpty()) {
            this.insert(section);
            return;
        }
        SectionDtoInterface dto = this.dao.findForKey(section.getSectionCode(), section.getActivateDate());
        if (dto == null) {
            this.add(section);
            return;
        }
        this.update(section);
    }
}

