/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.file.ImportBeanInterface;
import jp.mosp.platform.bean.file.PlatformFileBean;
import jp.mosp.platform.bean.workflow.ApprovalUnitRegistBeanInterface;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.dto.file.ImportFieldDtoInterface;
import jp.mosp.platform.dto.workflow.ApprovalUnitDtoInterface;

public abstract class UnitImportBean
extends PlatformFileBean
implements ImportBeanInterface {
    protected ApprovalUnitRegistBeanInterface regist;

    public UnitImportBean() {
    }

    public UnitImportBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.regist = (ApprovalUnitRegistBeanInterface)this.createBean(ApprovalUnitRegistBeanInterface.class);
    }

    public int importFile(ImportDtoInterface importDto, InputStream requestedFile) throws MospException {
        List dataList = this.getDataList(importDto, requestedFile);
        List fieldList = this.getImportFieldList(importDto.getImportCode());
        return this.importFile(fieldList, dataList);
    }

    protected int importFile(List<ImportFieldDtoInterface> fieldList, List<String[]> dataList) throws MospException {
        List targetList = this.getTargetList(fieldList, dataList);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        int row = 0;
        for (ApprovalUnitDtoInterface dto : targetList) {
            this.regist.validate(dto, Integer.valueOf(row++));
            if (this.mospParams.hasErrorMessage()) continue;
            this.regist.regist(dto);
        }
        return targetList.size();
    }

    protected List<ApprovalUnitDtoInterface> getTargetList(List<ImportFieldDtoInterface> fieldList, List<String[]> dataList) throws MospException {
        ArrayList<ApprovalUnitDtoInterface> targetList = new ArrayList<ApprovalUnitDtoInterface>();
        this.checkCsvLength(fieldList, dataList);
        if (this.mospParams.hasErrorMessage()) {
            return targetList;
        }
        for (int i = 0; i < dataList.size(); ++i) {
            String[] data = dataList.get(i);
            ApprovalUnitDtoInterface dto = this.getUnitDto(fieldList, data);
            targetList.add(dto);
        }
        return targetList;
    }

    protected ApprovalUnitDtoInterface getUnitDto(List<ImportFieldDtoInterface> fieldList, String[] data) throws MospException {
        ApprovalUnitDtoInterface dto = this.regist.getInitDto();
        String unitCode = this.getFieldValue("unit_code", fieldList, data);
        Date activateDate = this.getDateFieldValue("activate_date", fieldList, data);
        String unitName = this.getFieldValue("unit_name", fieldList, data);
        int inactivateFlag = this.getIntegerFieldValue("inactivate_flag", fieldList, data);
        dto.setUnitCode(unitCode);
        dto.setActivateDate(activateDate);
        dto.setUnitName(unitName);
        dto.setInactivateFlag(inactivateFlag);
        return dto;
    }
}

