/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.file.UserExportBeanInterface;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.dao.file.ExportDaoInterface;
import jp.mosp.platform.dao.file.ExportFieldDaoInterface;
import jp.mosp.platform.dao.system.UserMasterDaoInterface;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.dto.file.ExportFieldDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;

public class UserExportBean
extends PlatformBean
implements UserExportBeanInterface {
    protected ExportDaoInterface exportDao;
    protected ExportFieldDaoInterface exportFieldDao;
    protected UserMasterDaoInterface userMasterDao;
    protected HumanSearchBeanInterface humanSearch;
    protected SectionReferenceBeanInterface sectionReference;
    protected List<HumanDtoInterface> humanList;

    public UserExportBean() {
    }

    protected UserExportBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.exportDao = (ExportDaoInterface)this.createDao(ExportDaoInterface.class);
        this.exportFieldDao = (ExportFieldDaoInterface)this.createDao(ExportFieldDaoInterface.class);
        this.userMasterDao = (UserMasterDaoInterface)this.createDao(UserMasterDaoInterface.class);
        this.humanSearch = (HumanSearchBeanInterface)this.createBean(HumanSearchBeanInterface.class);
        this.sectionReference = (SectionReferenceBeanInterface)this.createBean(SectionReferenceBeanInterface.class);
    }

    public void export(String exportCode, Date targetDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        List csvDataList = this.getCsvDataList(exportCode, targetDate, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        if (csvDataList.isEmpty()) {
            this.addNoExportDataMessage();
            return;
        }
        this.mospParams.setFile((Object)OrangeSignalUtility.getOrangeSignalParams((List)csvDataList));
        this.setFileName(exportCode, targetDate);
    }

    protected List<String[]> getCsvDataList(String exportCode, Date targetDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        ArrayList<String[]> csvDataList = new ArrayList<String[]>();
        ExportDtoInterface exportDto = this.exportDao.findForKey(exportCode);
        List fieldList = this.exportFieldDao.findForList(exportCode);
        this.searchHumanData(csvDataList, fieldList, targetDate, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        this.addUserMasterData(csvDataList, fieldList, targetDate);
        if (exportDto.getHeader() != 0) {
            this.addHeader(csvDataList, fieldList);
        }
        return csvDataList;
    }

    protected void addHeader(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList) {
        String[] header = new String[fieldList.size()];
        int i = 0;
        for (ExportFieldDtoInterface field : fieldList) {
            header[i++] = this.getCodeName(field.getFieldName(), "pfm_user");
        }
        csvDataList.add(0, header);
    }

    protected void searchHumanData(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList, Date targetDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        this.humanSearch.setTargetDate(targetDate);
        this.humanSearch.setWorkPlaceCode(workPlaceCode);
        this.humanSearch.setEmploymentContractCode(employmentContractCode);
        this.humanSearch.setSectionCode(sectionCode);
        this.humanSearch.setPositionCode(positionCode);
        this.humanSearch.setStateType("presence");
        this.humanSearch.setNeedLowerSection(true);
        this.humanSearch.setNeedConcurrent(true);
        this.humanSearch.setOperationType("1");
        this.humanList = this.humanSearch.search();
    }

    protected void addUserMasterData(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList, Date targetDate) throws MospException {
        Integer userIdIndex = null;
        Integer activateDateIndex = null;
        Integer employeeCodeIndex = null;
        Integer employeeNameIndex = null;
        Integer sectionNameIndex = null;
        Integer sectionDisplayIndex = null;
        Integer roleCodeIndex = null;
        for (ExportFieldDtoInterface field : fieldList) {
            if (field.getFieldName().equals("user_id")) {
                userIdIndex = field.getFieldOrder() - 1;
            }
            if (field.getFieldName().equals("activate_date")) {
                activateDateIndex = field.getFieldOrder() - 1;
            }
            if (field.getFieldName().equals("employee_code")) {
                employeeCodeIndex = field.getFieldOrder() - 1;
            }
            if (field.getFieldName().equals("full_name")) {
                employeeNameIndex = field.getFieldOrder() - 1;
            }
            if (field.getFieldName().equals("role_code")) {
                roleCodeIndex = field.getFieldOrder() - 1;
            }
            if (field.getFieldName().equals("section_name")) {
                sectionNameIndex = field.getFieldOrder() - 1;
            }
            if (!field.getFieldName().equals("section_display")) continue;
            sectionDisplayIndex = field.getFieldOrder() - 1;
        }
        for (int i = 0; i < this.humanList.size(); ++i) {
            HumanDtoInterface human = (HumanDtoInterface)this.humanList.get(i);
            List userMasterList = this.userMasterDao.findForPersonalId(human.getPersonalId(), targetDate);
            for (UserMasterDtoInterface userMaster : userMasterList) {
                String[] csvData = new String[fieldList.size()];
                if (userIdIndex != null) {
                    csvData[userIdIndex.intValue()] = userMaster.getUserId();
                }
                if (activateDateIndex != null) {
                    csvData[activateDateIndex.intValue()] = this.getStringDate(userMaster.getActivateDate());
                }
                if (employeeCodeIndex != null) {
                    csvData[employeeCodeIndex.intValue()] = human.getEmployeeCode();
                }
                if (employeeNameIndex != null) {
                    csvData[employeeNameIndex.intValue()] = MospUtility.getHumansName((String)human.getFirstName(), (String)human.getLastName());
                }
                if (roleCodeIndex != null) {
                    csvData[roleCodeIndex.intValue()] = userMaster.getRoleCode();
                }
                if (sectionNameIndex != null) {
                    csvData[sectionNameIndex.intValue()] = this.sectionReference.getSectionName(human.getSectionCode(), targetDate);
                }
                if (sectionDisplayIndex != null) {
                    csvData[sectionDisplayIndex.intValue()] = this.sectionReference.getSectionDisplay(human.getSectionCode(), targetDate);
                }
                csvDataList.add(csvData);
            }
        }
    }

    protected void setFileName(String exportCode, Date targetDate) {
        String fileName = exportCode + this.mospParams.getName("Hyphen") + DateUtility.getStringYear((Date)targetDate) + DateUtility.getStringMonth((Date)targetDate) + DateUtility.getStringDay((Date)targetDate) + ".csv";
        this.mospParams.setFileName(fileName);
    }

    protected void addNoExportDataMessage() {
        String rep = this.mospParams.getName("Export", new String[]{"Information"});
        this.mospParams.addErrorMessage("PFW0201", new String[]{rep});
    }
}

