/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.base;

import java.sql.Connection;
import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.file.PlatformFileBean;
import jp.mosp.platform.bean.system.PlatformMasterCheckBeanInterface;
import jp.mosp.platform.dao.human.EntranceDaoInterface;
import jp.mosp.platform.dao.human.RetirementDaoInterface;
import jp.mosp.platform.dao.system.EmploymentContractDaoInterface;
import jp.mosp.platform.dao.system.NamingDaoInterface;
import jp.mosp.platform.dao.system.PositionDaoInterface;
import jp.mosp.platform.dao.system.SectionDaoInterface;
import jp.mosp.platform.dao.system.WorkPlaceDaoInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;
import jp.mosp.platform.dto.system.EmploymentContractDtoInterface;
import jp.mosp.platform.dto.system.NamingDtoInterface;
import jp.mosp.platform.dto.system.PositionDtoInterface;
import jp.mosp.platform.dto.system.SectionDtoInterface;
import jp.mosp.platform.dto.system.WorkPlaceDtoInterface;

public abstract class PlatformHumanBean
extends PlatformFileBean {
    protected PlatformMasterCheckBeanInterface masterCheck;

    public PlatformHumanBean() {
    }

    protected PlatformHumanBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.masterCheck = (PlatformMasterCheckBeanInterface)this.createBean(PlatformMasterCheckBeanInterface.class);
    }

    protected String getHumanName(HumanDtoInterface dto) {
        if (dto == null) {
            return "";
        }
        return MospUtility.getHumansName((String)dto.getFirstName(), (String)dto.getLastName());
    }

    protected Date getEntranceDate(String personalId) throws MospException {
        EntranceDaoInterface entranceDao = (EntranceDaoInterface)this.createDao(EntranceDaoInterface.class);
        EntranceDtoInterface dto = entranceDao.findForInfo(personalId);
        if (dto != null) {
            return dto.getEntranceDate();
        }
        return null;
    }

    protected Date getRetirementDate(String personalId) throws MospException {
        RetirementDaoInterface retirementDao = (RetirementDaoInterface)this.createDao(RetirementDaoInterface.class);
        RetirementDtoInterface dto = retirementDao.findForInfo(personalId);
        if (dto != null) {
            return dto.getRetirementDate();
        }
        return null;
    }

    protected void checkWorkPlace(String workPlaceCode, Date startDate, Date endDate, Integer row) throws MospException {
        if (workPlaceCode.isEmpty()) {
            return;
        }
        WorkPlaceDaoInterface workPlaceDao = (WorkPlaceDaoInterface)this.createDao(WorkPlaceDaoInterface.class);
        WorkPlaceDtoInterface workDto = workPlaceDao.findForInfo(workPlaceCode, startDate);
        if (workDto == null) {
            this.addWorkPlaceNotExistMessage(workPlaceCode, row);
            return;
        }
        this.masterCheck.isCheckWorkPlace(workPlaceCode, startDate, endDate, row);
    }

    protected void checkEmploymentContract(String employmentContractCode, Date startDate, Date endDate, Integer row) throws MospException {
        if (employmentContractCode.isEmpty()) {
            return;
        }
        EmploymentContractDaoInterface employmentContractDao = (EmploymentContractDaoInterface)this.createDao(EmploymentContractDaoInterface.class);
        EmploymentContractDtoInterface employmentDto = employmentContractDao.findForInfo(employmentContractCode, startDate);
        if (employmentDto == null) {
            this.addEmploymentContractNotExistMessage(employmentContractCode, row);
            return;
        }
        this.masterCheck.isCheckEmploymentContract(employmentContractCode, startDate, endDate, row);
    }

    protected void checkSection(String sectionCode, Date startDate, Date endDate, Integer row) throws MospException {
        if (sectionCode.isEmpty()) {
            return;
        }
        SectionDaoInterface sectionDao = (SectionDaoInterface)this.createDao(SectionDaoInterface.class);
        SectionDtoInterface dto = sectionDao.findForInfo(sectionCode, startDate);
        if (dto == null) {
            this.addSectionNotExistMessage(sectionCode, row);
            return;
        }
        if (!this.masterCheck.isCheckSection(sectionCode, startDate, endDate, row)) {
            return;
        }
    }

    protected void checkPosition(String positionCode, Date startDate, Date endDate, Integer row) throws MospException {
        if (positionCode.isEmpty()) {
            return;
        }
        PositionDaoInterface positionDao = (PositionDaoInterface)this.createDao(PositionDaoInterface.class);
        PositionDtoInterface dto = positionDao.findForInfo(positionCode, startDate);
        if (dto == null) {
            this.addPositionNotExistMessage(positionCode, row);
            return;
        }
        if (this.masterCheck.isCheckPosition(positionCode, startDate, endDate, row)) {
            return;
        }
    }

    protected void checkNaming(String namingType, String namingItemCode, Date startDate, Date endDate, Integer row) throws MospException {
        if (namingItemCode.isEmpty()) {
            return;
        }
        NamingDaoInterface namingDao = (NamingDaoInterface)this.createDao(NamingDaoInterface.class);
        NamingDtoInterface dto = namingDao.findForInfo(namingType, namingItemCode, startDate);
        if (dto == null) {
            this.addNamingItemNotExistMessage(namingType, namingItemCode, row);
            return;
        }
        if (this.masterCheck.isCheckNaming(namingType, namingItemCode, startDate, endDate, row)) {
            return;
        }
    }

    protected void addWorkPlaceNotExistMessage(String workPlaceCode, Integer row) {
        String[] rep = new String[]{this.getRowedFieldName(this.mospParams.getName("WorkPlace"), row), workPlaceCode};
        this.mospParams.addErrorMessage("PFW0214", rep);
    }

    protected void addEmploymentContractNotExistMessage(String employmentContractCode, Integer row) {
        String[] rep = new String[]{this.getRowedFieldName(this.mospParams.getName("EmploymentContract"), row), employmentContractCode};
        this.mospParams.addErrorMessage("PFW0214", rep);
    }

    protected void addSectionNotExistMessage(String sectionCode, Integer row) {
        this.mospParams.addErrorMessage("PFW0214", new String[]{this.getRowedFieldName(this.getNameSection(), row), sectionCode});
    }

    protected void addPositionNotExistMessage(String positionCode, Integer row) {
        this.mospParams.addErrorMessage("PFW0214", new String[]{this.getRowedFieldName(this.getNamePosition(), row), positionCode});
    }

    protected void addNamingItemNotExistMessage(String namingType, String namingItemCode, Integer row) {
        String namingTypeItemName = this.mospParams.getProperties().getCodeItemName("NamingType", namingType);
        this.mospParams.addErrorMessage("PFW0214", new String[]{this.getRowedFieldName(namingTypeItemName, row), namingItemCode});
    }

    protected void addEmployeeNotEnteredMessage() {
        this.mospParams.addErrorMessage("PFW0203", new String[]{this.getNameEntrance()});
    }

    protected void addEmployeeHistoryNotExistMessage(String employeeCode, Date targetDate) {
        this.mospParams.addErrorMessage("PFW0219", new String[]{this.getStringDate(targetDate), employeeCode});
    }

    protected void addDuplicateTermMessage(String duplicated) {
        this.mospParams.addErrorMessage("PFW0218", new String[]{duplicated});
    }

    protected String getNameEntrance() {
        return this.mospParams.getName("Joined");
    }

    protected String getNameEntranceDate() {
        return this.getNameEntrance() + this.mospParams.getName("Day");
    }

    protected String getNameRetirementDate() {
        return this.mospParams.getName("RetirementOn") + this.mospParams.getName("Day");
    }

    protected String getNameSuspension() {
        return this.mospParams.getName("RetirementLeave");
    }

    protected String getNameSuspensionStartDate() {
        return this.getNameSuspension() + this.mospParams.getName("Start") + this.mospParams.getName("Day");
    }

    protected String getNameSuspensionEndDate() {
        return this.getNameSuspension() + this.mospParams.getName("End") + this.mospParams.getName("Day");
    }

    protected String getNameSuspensionScheduledEndDate() {
        return this.getNameSuspension() + this.mospParams.getName("End") + this.mospParams.getName("Schedule") + this.mospParams.getName("Day");
    }

    protected String getNameConcurrent() {
        return this.mospParams.getName("Concurrent");
    }

    protected String getNameConcurrentStartDate() {
        return this.getNameConcurrent() + this.mospParams.getName("Start") + this.mospParams.getName("Day");
    }

    protected String getNameConcurrentEndDate() {
        return this.getNameConcurrent() + this.mospParams.getName("End") + this.mospParams.getName("Day");
    }
}

