/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.human.ConcurrentRegistBeanInterface;
import jp.mosp.platform.bean.human.base.PlatformHumanBean;
import jp.mosp.platform.dao.human.ConcurrentDaoInterface;
import jp.mosp.platform.dto.human.ConcurrentDtoInterface;
import jp.mosp.platform.dto.human.impl.PfaHumanConcurrentDto;

public class ConcurrentRegistBean
extends PlatformHumanBean
implements ConcurrentRegistBeanInterface {
    ConcurrentDaoInterface dao;

    public ConcurrentRegistBean() {
    }

    public ConcurrentRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (ConcurrentDaoInterface)this.createDao(ConcurrentDaoInterface.class);
    }

    public ConcurrentDtoInterface getInitDto() {
        return new PfaHumanConcurrentDto();
    }

    public List<ConcurrentDtoInterface> getInitDtoList(int size) {
        ArrayList<ConcurrentDtoInterface> list = new ArrayList<ConcurrentDtoInterface>();
        for (int i = 0; i < size; ++i) {
            list.add(this.getInitDto());
        }
        return list;
    }

    public void regist(List<ConcurrentDtoInterface> list) throws MospException {
        this.checkRegist(list);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (ConcurrentDtoInterface dto : list) {
            if (dto.getPfaHumanConcurrentId() == 0L) {
                this.insert(dto);
                continue;
            }
            this.update(dto);
        }
    }

    public void delete(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            this.checkExclusive((BaseDaoInterface)this.dao, id);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, id);
        }
    }

    protected void insert(ConcurrentDtoInterface dto) throws MospException {
        dto.setPfaHumanConcurrentId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void update(ConcurrentDtoInterface dto) throws MospException {
        ConcurrentDtoInterface currentDto = (ConcurrentDtoInterface)this.findForKey((BaseDaoInterface)this.dao, dto.getPfaHumanConcurrentId(), true);
        this.checkExclusive((BaseDtoInterface)currentDto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (this.isSameDto(dto, currentDto)) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanConcurrentId());
        dto.setPfaHumanConcurrentId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void checkRegist(List<ConcurrentDtoInterface> list) throws MospException {
        String personalId = list.get(0).getPersonalId();
        Date entranceDate = this.getEntranceDate(personalId);
        if (entranceDate == null) {
            this.addEmployeeNotEnteredMessage();
            return;
        }
        Date retirementDate = this.getRetirementDate(personalId);
        for (ConcurrentDtoInterface dto : list) {
            if (!this.checkDateOrder(entranceDate, dto.getStartDate(), true)) {
                this.addInvalidOrderMessage(this.getNameEntranceDate(), this.getNameConcurrentStartDate());
            }
            if (!this.checkDateOrder(dto.getEndDate(), retirementDate, true)) {
                this.addInvalidOrderMessage(this.getNameConcurrentEndDate(), this.getNameRetirementDate());
            }
            if (!this.checkDateOrder(dto.getStartDate(), dto.getEndDate(), true)) {
                this.addInvalidOrderMessage(this.getNameConcurrentStartDate(), this.getNameConcurrentEndDate());
            }
            this.checkSection(dto.getSectionCode(), dto.getStartDate(), dto.getEndDate(), null);
            this.checkPosition(dto.getPositionCode(), dto.getStartDate(), dto.getEndDate(), null);
        }
        for (int i = 0; i < list.size(); ++i) {
            ConcurrentDtoInterface dto1 = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                ConcurrentDtoInterface dto2 = list.get(j);
                if (!dto1.getSectionCode().equals(dto2.getSectionCode()) || !dto1.getPositionCode().equals(dto2.getPositionCode()) || this.checkTermDuplicate(dto1.getStartDate(), dto1.getEndDate(), dto2.getStartDate(), dto2.getEndDate())) continue;
                this.addDuplicateTermMessage(this.getNameConcurrent());
            }
        }
    }

    protected boolean isSameDto(ConcurrentDtoInterface dto1, ConcurrentDtoInterface dto2) {
        if (!dto1.getPersonalId().equals(dto2.getPersonalId())) {
            return false;
        }
        if (!this.isSameDate(dto1.getStartDate(), dto2.getStartDate())) {
            return false;
        }
        if (!this.isSameDate(dto1.getEndDate(), dto2.getEndDate())) {
            return false;
        }
        if (!dto1.getSectionCode().equals(dto2.getSectionCode())) {
            return false;
        }
        if (!dto1.getPositionCode().equals(dto2.getPositionCode())) {
            return false;
        }
        return dto1.getConcurrentRemark().equals(dto2.getConcurrentRemark());
    }
}

