/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.ConcurrentReferenceBeanInterface;
import jp.mosp.platform.bean.human.ConcurrentRegistBeanInterface;
import jp.mosp.platform.bean.human.EntranceReferenceBeanInterface;
import jp.mosp.platform.bean.human.EntranceRegistBeanInterface;
import jp.mosp.platform.bean.human.ExtraHumanDeleteBeanInterface;
import jp.mosp.platform.bean.human.HistoryBasicDeleteBeanInterface;
import jp.mosp.platform.bean.human.HumanHistoryReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanHistoryRegistBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanRegistBeanInterface;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.RetirementRegistBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionRegistBeanInterface;
import jp.mosp.platform.bean.human.impl.HumanRegistBean;
import jp.mosp.platform.bean.system.UserMasterReferenceBeanInterface;
import jp.mosp.platform.bean.system.UserMasterRegistBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalUnitReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.RouteApplicationReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.SubApproverReferenceBeanInterface;
import jp.mosp.platform.dto.human.ConcurrentDtoInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.HumanHistoryDtoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;
import jp.mosp.platform.dto.human.SuspensionDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;
import jp.mosp.platform.human.utils.HumanUtility;

public class HistoryBasicDeleteBean
extends HumanRegistBean
implements HistoryBasicDeleteBeanInterface {
    protected static final String APP_KEY_BASIC_DELETE_BEANS = "HistoryBasicDeleteBeans";
    private UserMasterRegistBeanInterface userMasterRegist;
    private HumanRegistBeanInterface humanRegist;
    private HumanHistoryRegistBeanInterface humanHistoryRegist;
    private EntranceRegistBeanInterface entranceRegist;
    private RetirementRegistBeanInterface retirementRegist;
    private SuspensionRegistBeanInterface suspensionRegist;
    private ConcurrentRegistBeanInterface concurrentRegist;
    private UserMasterReferenceBeanInterface userMasterReference;
    private HumanReferenceBeanInterface humanReference;
    private HumanHistoryReferenceBeanInterface humanHistoryReference;
    private EntranceReferenceBeanInterface entranceReference;
    private SuspensionReferenceBeanInterface suspensionReference;
    private RetirementReferenceBeanInterface retirementReference;
    private ConcurrentReferenceBeanInterface concurrentReference;
    private ApprovalUnitReferenceBeanInterface approvalUnitReference;
    private RouteApplicationReferenceBeanInterface routeApplicationReference;
    private SubApproverReferenceBeanInterface subApproverReference;

    public HistoryBasicDeleteBean() {
    }

    public HistoryBasicDeleteBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.userMasterRegist = (UserMasterRegistBeanInterface)this.createBean(UserMasterRegistBeanInterface.class);
        this.humanRegist = (HumanRegistBeanInterface)this.createBean(HumanRegistBeanInterface.class);
        this.humanHistoryRegist = (HumanHistoryRegistBeanInterface)this.createBean(HumanHistoryRegistBeanInterface.class);
        this.entranceRegist = (EntranceRegistBeanInterface)this.createBean(EntranceRegistBeanInterface.class);
        this.retirementRegist = (RetirementRegistBeanInterface)this.createBean(RetirementRegistBeanInterface.class);
        this.suspensionRegist = (SuspensionRegistBeanInterface)this.createBean(SuspensionRegistBeanInterface.class);
        this.concurrentRegist = (ConcurrentRegistBeanInterface)this.createBean(ConcurrentRegistBeanInterface.class);
        this.userMasterReference = (UserMasterReferenceBeanInterface)this.createBean(UserMasterReferenceBeanInterface.class);
        this.humanReference = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
        this.humanHistoryReference = (HumanHistoryReferenceBeanInterface)this.createBean(HumanHistoryReferenceBeanInterface.class);
        this.entranceReference = (EntranceReferenceBeanInterface)this.createBean(EntranceReferenceBeanInterface.class);
        this.suspensionReference = (SuspensionReferenceBeanInterface)this.createBean(SuspensionReferenceBeanInterface.class);
        this.retirementReference = (RetirementReferenceBeanInterface)this.createBean(RetirementReferenceBeanInterface.class);
        this.concurrentReference = (ConcurrentReferenceBeanInterface)this.createBean(ConcurrentReferenceBeanInterface.class);
        this.approvalUnitReference = (ApprovalUnitReferenceBeanInterface)this.createBean(ApprovalUnitReferenceBeanInterface.class);
        this.routeApplicationReference = (RouteApplicationReferenceBeanInterface)this.createBean(RouteApplicationReferenceBeanInterface.class);
        this.subApproverReference = (SubApproverReferenceBeanInterface)this.createBean(SubApproverReferenceBeanInterface.class);
    }

    public void delete(long pfmHumanId, boolean isAllDelete) throws MospException {
        List extraList = this.getExtraHumanDelete();
        HumanDtoInterface dto = this.humanReference.findForKey(pfmHumanId);
        this.checkExclusive((BaseDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDelete(extraList, dto, isAllDelete);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.humanDelete(extraList, dto, isAllDelete);
    }

    protected List<ExtraHumanDeleteBeanInterface> getExtraHumanDelete() throws MospException {
        String[] extraBeans;
        ArrayList<ExtraHumanDeleteBeanInterface> extraList = new ArrayList<ExtraHumanDeleteBeanInterface>();
        for (String className : extraBeans = this.mospParams.getApplicationProperties(APP_KEY_BASIC_DELETE_BEANS)) {
            ExtraHumanDeleteBeanInterface extraHumanDeleteBean = (ExtraHumanDeleteBeanInterface)this.createBean(className);
            extraList.add(extraHumanDeleteBean);
        }
        return extraList;
    }

    protected void checkDelete(List<ExtraHumanDeleteBeanInterface> extraList, HumanDtoInterface deleateHumanDto, boolean isAllDelete) throws MospException {
        List list = this.humanReference.getHistory(deleateHumanDto.getPersonalId());
        int deleateIndex = HumanUtility.getHumanTargetIndex((HumanDtoInterface)deleateHumanDto, (List)list);
        int listSize = list.size();
        if (listSize == 1 && !isAllDelete || listSize > 1 && isAllDelete) {
            this.addExclusiveErrorMessage();
            return;
        }
        int deleteCase = this.getDeleteCase(list, deleateIndex);
        switch (deleteCase) {
            case 1: {
                this.oneDelete(deleateHumanDto);
                break;
            }
            case 2: {
                this.oldDelete(deleateIndex, list);
                break;
            }
            case 3: {
                this.betweenDelete(deleateIndex, list);
                break;
            }
            case 4: {
                this.newDelete(deleateIndex, list);
                break;
            }
        }
        for (ExtraHumanDeleteBeanInterface extraBean : extraList) {
            extraBean.checkDelete(list, deleateIndex, deleteCase);
        }
    }

    protected int getDeleteCase(List<HumanDtoInterface> list, int deleateIndex) throws MospException {
        int listSize = list.size();
        if (listSize == 1) {
            return 1;
        }
        if (deleateIndex == 0) {
            return 2;
        }
        if (deleateIndex != listSize - 1) {
            return 3;
        }
        if (deleateIndex == listSize - 1) {
            return 4;
        }
        this.addExclusiveErrorMessage();
        return 0;
    }

    protected void humanDelete(List<ExtraHumanDeleteBeanInterface> extraList, HumanDtoInterface dto, boolean isAllDelete) throws MospException {
        this.humanRegist.delete(dto);
        for (ExtraHumanDeleteBeanInterface extraBean : extraList) {
            extraBean.humanDelete(dto, isAllDelete);
        }
        this.deletePost(dto);
        if (!isAllDelete) {
            return;
        }
        this.deleteRetirement(dto);
        this.deleteSuspension(dto);
        this.deleteConcurrent(dto);
        this.deleteEntrance(dto);
        this.deleteUser(dto);
    }

    protected void oneDelete(HumanDtoInterface deleteHumanDto) throws MospException {
        this.checkWorkflow(deleteHumanDto.getPersonalId(), null, deleteHumanDto);
        this.checkSubApprover(deleteHumanDto, null);
    }

    protected void oldDelete(int deleateIndex, List<HumanDtoInterface> list) throws MospException {
        HumanDtoInterface deleateHumanDto = list.get(deleateIndex);
        HumanDtoInterface afterHumanDto = list.get(deleateIndex + 1);
        Date endDate = DateUtility.addDay((Date)afterHumanDto.getActivateDate(), (int)-1);
        this.checkWorkflow(deleateHumanDto.getPersonalId(), endDate, deleateHumanDto);
        this.checkAccount(deleateHumanDto.getPersonalId(), endDate, deleateHumanDto);
        this.checkSubApprover(deleateHumanDto, endDate);
    }

    protected void betweenDelete(int deleateIndex, List<HumanDtoInterface> list) throws MospException {
        HumanDtoInterface beforeHumanDto = list.get(deleateIndex - 1);
        HumanDtoInterface deleteHumanDto = list.get(deleateIndex);
        HumanDtoInterface afterHumanDto = list.get(deleateIndex + 1);
        Date endDate = DateUtility.addDay((Date)afterHumanDto.getActivateDate(), (int)-1);
        this.checkMaster(endDate, deleteHumanDto, beforeHumanDto);
    }

    protected void newDelete(int deleateIndex, List<HumanDtoInterface> list) throws MospException {
        HumanDtoInterface beforeHumanDto = list.get(deleateIndex - 1);
        HumanDtoInterface deleteHumanDto = list.get(deleateIndex);
        this.checkMaster(null, deleteHumanDto, beforeHumanDto);
    }

    protected void checkMaster(Date endDate, HumanDtoInterface deleteDto, HumanDtoInterface beforeDto) throws MospException {
        Date startDate = deleteDto.getActivateDate();
        this.checkSection(beforeDto.getSectionCode(), startDate, endDate, null);
        this.checkPosition(beforeDto.getPositionCode(), startDate, endDate, null);
        this.checkEmploymentContract(beforeDto.getEmploymentContractCode(), startDate, endDate, null);
        this.checkWorkPlace(beforeDto.getWorkPlaceCode(), startDate, endDate, null);
        if (this.mospParams.getApplicationPropertyBool("UsePost")) {
            this.checkPostMaster(startDate, endDate, deleteDto, beforeDto);
        }
    }

    protected void checkPostMaster(Date startDate, Date endDate, HumanDtoInterface deleteDto, HumanDtoInterface beforeDto) throws MospException {
        List postList = this.humanHistoryReference.findForHistory(deleteDto.getPersonalId(), "post");
        if (postList.isEmpty() || postList.size() == 1) {
            return;
        }
        if (((HumanHistoryDtoInterface)postList.get(0)).getActivateDate().equals(deleteDto.getActivateDate())) {
            return;
        }
        int targetPostIndex = HumanUtility.getTargetIndexPost((List)postList, (Date)deleteDto.getActivateDate());
        if (targetPostIndex == -1) {
            return;
        }
        HumanHistoryDtoInterface humanHistoryDto = (HumanHistoryDtoInterface)postList.get(targetPostIndex - 1);
        if (!humanHistoryDto.getActivateDate().equals(beforeDto.getActivateDate())) {
            return;
        }
        this.checkNaming("post", humanHistoryDto.getHumanItemValue(), startDate, endDate, null);
    }

    protected void checkWorkflow(String personalId, Date endDate, HumanDtoInterface deleteDto) throws MospException {
        if (this.routeApplicationReference.hasPersonalApplication(personalId, deleteDto.getActivateDate(), endDate)) {
            this.addAlreadyDeleteHistoryMessage(deleteDto.getEmployeeCode(), this.mospParams.getName("WorkManage") + this.mospParams.getName("Route") + this.mospParams.getName("Apply"));
        }
        if (this.approvalUnitReference.hasPersonalUnit(deleteDto.getPersonalId(), deleteDto.getActivateDate(), endDate)) {
            this.addAlreadyDeleteHistoryMessage(deleteDto.getEmployeeCode(), this.mospParams.getName("WorkflowUnit"));
        }
    }

    protected void checkAccount(String personalId, Date endDate, HumanDtoInterface deleteDto) throws MospException {
        Date startDate = deleteDto.getActivateDate();
        List userMasterList = this.userMasterReference.getUserHistoryForPersonalId(personalId);
        for (UserMasterDtoInterface userMasterDto : userMasterList) {
            if (!DateUtility.isTermContain((Date)userMasterDto.getActivateDate(), (Date)startDate, (Date)endDate)) continue;
            this.addAlreadyDeleteHistoryMessage(deleteDto.getEmployeeCode(), this.mospParams.getName("Account"));
        }
    }

    protected void checkSubApprover(HumanDtoInterface deleteDto, Date endDate) throws MospException {
        Date startDate = deleteDto.getActivateDate();
        if (this.subApproverReference.hasSubApprover(deleteDto.getPersonalId(), startDate, endDate, 1)) {
            this.addAlreadyDeleteHistoryMessage(deleteDto.getEmployeeCode(), this.mospParams.getName("Substitution") + this.mospParams.getName("Approver"));
        }
    }

    protected void deletePost(HumanDtoInterface humanDto) throws MospException {
        HumanHistoryDtoInterface postDto = this.humanHistoryReference.findForKey(humanDto.getPersonalId(), "post", humanDto.getActivateDate());
        if (postDto != null) {
            this.humanHistoryRegist.delete(postDto);
        }
    }

    protected void deleteRetirement(HumanDtoInterface humanDto) throws MospException {
        RetirementDtoInterface dto = this.retirementReference.getRetireInfo(humanDto.getPersonalId());
        if (dto != null) {
            this.retirementRegist.delete(dto);
        }
    }

    protected void deleteEntrance(HumanDtoInterface humanDto) throws MospException {
        EntranceDtoInterface dto = this.entranceReference.getEntranceInfo(humanDto.getPersonalId());
        if (dto != null) {
            this.entranceRegist.delete(dto);
        }
    }

    protected void deleteUser(HumanDtoInterface humanDto) throws MospException {
        long[] array = this.setDtoFieldsForUser(humanDto);
        if (array.length == 0) {
            return;
        }
        this.userMasterRegist.delete(array);
    }

    protected long[] setDtoFieldsForUser(HumanDtoInterface humanDto) throws MospException {
        List listUser = this.userMasterReference.getUserHistoryForPersonalId(humanDto.getPersonalId());
        if (listUser.size() == 0) {
            return new long[0];
        }
        int idx = 0;
        long[] aryUser = new long[listUser.size()];
        for (UserMasterDtoInterface dto : listUser) {
            aryUser[idx++] = dto.getPfmUserId();
        }
        return aryUser;
    }

    protected void deleteSuspension(HumanDtoInterface humanDto) throws MospException {
        long[] array = this.setDtoFieldsForSuspension(humanDto);
        if (array.length == 0) {
            return;
        }
        this.suspensionRegist.delete(array);
    }

    protected long[] setDtoFieldsForSuspension(HumanDtoInterface humanDto) throws MospException {
        List list = this.suspensionReference.getSuspentionList(humanDto.getPersonalId());
        if (list.size() == 0) {
            return new long[0];
        }
        int idx = 0;
        long[] arySuspension = new long[list.size()];
        for (SuspensionDtoInterface dto : list) {
            arySuspension[idx++] = dto.getPfaHumanSuspensionId();
        }
        return arySuspension;
    }

    protected void deleteConcurrent(HumanDtoInterface humanDto) throws MospException {
        long[] array = this.setDtoFieldsForConcurrent(humanDto);
        if (array.length == 0) {
            return;
        }
        this.concurrentRegist.delete(array);
    }

    protected long[] setDtoFieldsForConcurrent(HumanDtoInterface humanDto) throws MospException {
        List list = this.concurrentReference.getConcurrentHistory(humanDto.getPersonalId());
        if (list.size() == 0) {
            return new long[0];
        }
        int idx = 0;
        long[] aryConcurrent = new long[list.size()];
        for (ConcurrentDtoInterface dto : list) {
            aryConcurrent[idx++] = dto.getPfaHumanConcurrentId();
        }
        return aryConcurrent;
    }

    protected void addAlreadyDeleteHistoryMessage(String personalId, String errorTargetName) {
        this.mospParams.addErrorMessage("PFW9118", new String[]{personalId, errorTargetName});
    }
}

