/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.ViewConfigProperty;
import jp.mosp.framework.xml.TableItemProperty;
import jp.mosp.platform.bean.human.HumanBinaryHistoryRegistBeanInterface;
import jp.mosp.platform.bean.human.HumanGeneralBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.impl.HumanGeneralBean;
import jp.mosp.platform.dao.human.HumanBinaryHistoryDaoInterface;
import jp.mosp.platform.dto.human.HumanBinaryHistoryDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.impl.PfaHumanBinaryHistoryDto;

public class HumanBinaryHistoryRegistBean
extends HumanGeneralBean
implements HumanBinaryHistoryRegistBeanInterface {
    HumanBinaryHistoryDaoInterface dao;
    HumanReferenceBeanInterface humanReference;
    HumanGeneralBeanInterface humanGeneral;

    public HumanBinaryHistoryRegistBean() {
    }

    public HumanBinaryHistoryRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (HumanBinaryHistoryDaoInterface)this.createDao(HumanBinaryHistoryDaoInterface.class);
        this.humanReference = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
        this.humanGeneral = (HumanGeneralBeanInterface)this.createBean(HumanGeneralBeanInterface.class);
    }

    public HumanBinaryHistoryDtoInterface getInitDto() {
        return new PfaHumanBinaryHistoryDto();
    }

    public void delete(HumanBinaryHistoryDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaHumanBinaryHistoryId());
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanBinaryHistoryId());
    }

    public void deleteDeadInputItem(Set<String> divisions, String viewKey) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (String division : divisions) {
            List tableItemList = this.humanGeneral.getTableItemList(division, viewKey);
            for (TableItemProperty tableItem : tableItemList) {
                String[] itemNames;
                for (String itemName : itemNames = tableItem.getItemNames()) {
                    list.add(itemName);
                }
            }
        }
        if (list.isEmpty()) {
            return;
        }
        List listDeleteItem = this.dao.findForInfoNotIn(list);
        for (HumanBinaryHistoryDtoInterface dto : listDeleteItem) {
            this.delete(dto);
        }
    }

    public void update(HumanBinaryHistoryDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanBinaryHistoryId());
        dto.setPfaHumanBinaryHistoryId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void insert(HumanBinaryHistoryDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfaHumanBinaryHistoryId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void validate(HumanBinaryHistoryDtoInterface dto) throws MospException {
        boolean isHumanExist;
        this.checkLength(dto.getFileName(), 50, this.mospParams.getName("File", new String[]{"Name"}), null);
        ViewConfigProperty viewConfig = (ViewConfigProperty)this.mospParams.getProperties().getViewConfigProperties().get(dto.getHumanItemType());
        if (viewConfig != null && (isHumanExist = viewConfig.isHumanExist())) {
            return;
        }
        HumanDtoInterface humanDao = this.humanReference.getHumanInfo(dto.getPersonalId(), dto.getActivateDate());
        if (humanDao != null) {
            return;
        }
        this.humanGeneral.addNotHumanErrorMessage();
    }

    protected void checkAdd(HumanBinaryHistoryDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getPersonalId(), dto.getHumanItemType(), dto.getActivateDate()));
    }

    protected void checkUpdate(HumanBinaryHistoryDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaHumanBinaryHistoryId());
        HumanBinaryHistoryDtoInterface oldDto = this.dao.findForKey(dto.getPersonalId(), dto.getHumanItemType(), dto.getActivateDate());
        dto.setHumanItemBinary(oldDto.getHumanItemBinary());
    }
}

