/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.ConventionProperty;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.xml.ItemProperty;
import jp.mosp.framework.xml.TableItemProperty;
import jp.mosp.platform.bean.human.HumanGeneralBeanInterface;
import jp.mosp.platform.bean.human.HumanGeneralCheckBeanInterface;
import jp.mosp.platform.bean.human.HumanHistoryRegistBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.impl.HumanGeneralBean;
import jp.mosp.platform.dao.human.HumanHistoryDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.HumanHistoryDtoInterface;
import jp.mosp.platform.dto.human.impl.PfaHumanHistoryDto;

public class HumanHistoryRegistBean
extends HumanGeneralBean
implements HumanHistoryRegistBeanInterface {
    HumanHistoryDaoInterface dao;
    HumanReferenceBeanInterface humanReference;
    HumanGeneralCheckBeanInterface humanGeneralCheckBean;
    HumanGeneralBeanInterface humanGeneral;

    public HumanHistoryRegistBean() {
    }

    public HumanHistoryRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (HumanHistoryDaoInterface)this.createDao(HumanHistoryDaoInterface.class);
        this.humanReference = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
        this.humanGeneral = (HumanGeneralBeanInterface)this.createBean(HumanGeneralBeanInterface.class);
        this.humanGeneralCheckBean = (HumanGeneralCheckBeanInterface)this.createBean(HumanGeneralCheckBeanInterface.class);
    }

    public HumanHistoryDtoInterface getInitDto() {
        return new PfaHumanHistoryDto();
    }

    public void add(HumanHistoryDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfaHumanHistoryId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(HumanHistoryDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanHistoryId());
        dto.setPfaHumanHistoryId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            this.checkExclusive((BaseDaoInterface)this.dao, id);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, id);
        }
    }

    public void validate(HumanHistoryDtoInterface dto) throws MospException {
        if (dto.getHumanItemType().equals("post")) {
            List list = this.humanReference.getHistory(dto.getPersonalId());
            Date startDate = dto.getActivateDate();
            Date endDate = null;
            if (!list.isEmpty()) {
                endDate = this.getLastDate(dto.getActivateDate(), list);
            }
            this.checkNaming(dto.getHumanItemType(), dto.getHumanItemValue(), startDate, endDate, null);
        } else {
            HumanDtoInterface humanDao = this.humanReference.getHumanInfo(dto.getPersonalId(), dto.getActivateDate());
            if (humanDao != null) {
                return;
            }
            this.humanGeneral.addNotHumanErrorMessage();
        }
    }

    protected Date getLastDate(Date targetDate, List<HumanDtoInterface> list) throws MospException {
        Date lastDate = null;
        for (HumanDtoInterface dto : list) {
            if (targetDate.compareTo(dto.getActivateDate()) >= 0 || dto.getActivateDate() == null) continue;
            lastDate = DateUtility.addDay((Date)dto.getActivateDate(), (int)-1);
            break;
        }
        return lastDate;
    }

    protected void checkAdd(HumanHistoryDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getPersonalId(), dto.getHumanItemType(), dto.getActivateDate()));
    }

    protected void checkUpdate(HumanHistoryDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaHumanHistoryId());
    }

    public void delete(HumanHistoryDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaHumanHistoryId());
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanHistoryId());
    }

    public void delete(String division, String viewKey, LinkedHashMap<String, Long> recordsMap) throws MospException {
        List tableItemList = this.getTableItemList(division, viewKey);
        for (TableItemProperty tableItem : tableItemList) {
            String[] itemNames;
            for (String itemName : itemNames = tableItem.getItemNames()) {
                Long recordId;
                if (itemName.isEmpty() || (recordId = recordsMap.get(itemName)) == null) continue;
                HumanHistoryDtoInterface dto = (HumanHistoryDtoInterface)this.dao.findForKey(recordId.longValue(), false);
                this.delete(dto);
            }
        }
    }

    public void deleteDeadInputItem(Set<String> divisions, String viewKey) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (String division : divisions) {
            List tableItemList = this.humanGeneral.getTableItemList(division, viewKey);
            for (TableItemProperty tableItem : tableItemList) {
                String[] itemNames;
                for (String itemName : itemNames = tableItem.getItemNames()) {
                    list.add(itemName);
                }
            }
        }
        if (list.isEmpty()) {
            return;
        }
        List listDeleteItem = this.dao.findForInfoNotIn(list);
        for (HumanHistoryDtoInterface dto : listDeleteItem) {
            this.delete(dto);
        }
    }

    public void add(String division, String viewKey, String personalId, Date activeDate) throws MospException {
        this.humanGeneralCheckBean.validate(division, viewKey);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        List tableItemList = this.getTableItemList(division, viewKey);
        for (TableItemProperty tableItem : tableItemList) {
            String[] itemNames = tableItem.getItemNames();
            String[] itemKeys = tableItem.getItemKeys();
            for (int i = 0; i < itemNames.length; ++i) {
                ConventionProperty conventionProperty;
                ItemProperty itemProperty;
                String itemName = itemNames[i];
                if (itemName.isEmpty()) continue;
                String value = this.mospParams.getRequestParam(itemName);
                if (value == null) {
                    value = "";
                }
                if ((itemProperty = (conventionProperty = (ConventionProperty)this.mospParams.getProperties().getConventionProperties().get("Default")).getItem(itemKeys[i])).getType().equals("checkbox") && value.isEmpty()) {
                    value = "0";
                }
                HumanHistoryDtoInterface dto = this.getInitDto();
                dto.setPersonalId(personalId);
                dto.setActivateDate(activeDate);
                dto.setHumanItemType(itemName);
                dto.setHumanItemValue(value);
                this.add(dto);
                if (!this.mospParams.hasErrorMessage()) continue;
                return;
            }
        }
    }

    public void regist(HumanHistoryDtoInterface dto) throws MospException {
        HumanHistoryDtoInterface oldDto = this.dao.findForKey(dto.getPersonalId(), dto.getHumanItemType(), dto.getActivateDate());
        if (oldDto == null) {
            this.add(dto);
        } else {
            oldDto.setHumanItemValue(dto.getHumanItemValue());
            this.update(oldDto);
        }
    }

    public void update(String division, String viewKey, String personalId, Date activeDate, LinkedHashMap<String, Long> recordsMap) throws MospException {
        this.humanGeneralCheckBean.validate(division, viewKey);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        List tableItemList = this.getTableItemList(division, viewKey);
        for (TableItemProperty tableItem : tableItemList) {
            String[] itemNames = tableItem.getItemNames();
            String[] itemKeys = tableItem.getItemKeys();
            for (int i = 0; i < itemNames.length; ++i) {
                ConventionProperty conventionProperty;
                ItemProperty itemProperty;
                String itemName = itemNames[i];
                if (itemName.isEmpty()) continue;
                Long recordId = recordsMap.get(itemName);
                HumanHistoryDtoInterface dto = this.getInitDto();
                String value = this.mospParams.getRequestParam(itemName);
                if (value == null) {
                    value = "";
                }
                if ((itemProperty = (conventionProperty = (ConventionProperty)this.mospParams.getProperties().getConventionProperties().get("Default")).getItem(itemKeys[i])).getType().equals("checkbox") && value.isEmpty()) {
                    value = "0";
                }
                if (recordId == null) {
                    dto.setPersonalId(personalId);
                    dto.setActivateDate(activeDate);
                    dto.setHumanItemType(itemName);
                    dto.setHumanItemValue(value);
                    this.add(dto);
                    if (!this.mospParams.hasErrorMessage()) continue;
                    return;
                }
                dto = (HumanHistoryDtoInterface)this.dao.findForKey(recordId.longValue(), false);
                dto.setHumanItemValue(value);
                this.update(dto);
                if (!this.mospParams.hasErrorMessage()) continue;
                return;
            }
        }
    }
}

