/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.RangeProperty;
import jp.mosp.framework.property.ViewConfigProperty;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.human.ConcurrentReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanArrayReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanBinaryArrayReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanBinaryHistoryReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanBinaryNormalReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanHistoryReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanNormalReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.human.base.PlatformHumanBean;
import jp.mosp.platform.bean.system.EmploymentContractReferenceBeanInterface;
import jp.mosp.platform.bean.system.NamingReferenceBeanInterface;
import jp.mosp.platform.bean.system.PositionReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.system.WorkPlaceReferenceBeanInterface;
import jp.mosp.platform.dao.human.EntranceDaoInterface;
import jp.mosp.platform.dao.human.HumanSearchDaoInterface;
import jp.mosp.platform.dao.human.RetirementDaoInterface;
import jp.mosp.platform.dao.human.SuspensionDaoInterface;
import jp.mosp.platform.dto.human.ConcurrentDtoInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanBinaryArrayDtoInterface;
import jp.mosp.platform.dto.human.HumanBinaryHistoryDtoInterface;
import jp.mosp.platform.dto.human.HumanBinaryNormalDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.HumanHistoryDtoInterface;
import jp.mosp.platform.dto.human.HumanListDtoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;
import jp.mosp.platform.dto.human.SuspensionDtoInterface;
import jp.mosp.platform.dto.human.impl.PfaHumanListDto;
import jp.mosp.platform.dto.system.EmploymentContractDtoInterface;
import jp.mosp.platform.dto.system.NamingDtoInterface;
import jp.mosp.platform.dto.system.WorkPlaceDtoInterface;
import jp.mosp.platform.utils.PlatformUtility;

public class HumanSearchBean
extends PlatformHumanBean
implements HumanSearchBeanInterface {
    public static final String FREE_WORD_SEPARATOR = " ";
    protected HumanSearchDaoInterface dao;
    protected NamingReferenceBeanInterface namingReference;
    protected ConcurrentReferenceBeanInterface concurrentReference;
    protected RetirementReferenceBeanInterface retirementReference;
    protected SuspensionReferenceBeanInterface suspensionReference;
    protected HumanNormalReferenceBeanInterface humanNormalReference;
    protected HumanHistoryReferenceBeanInterface humanHistoryReference;
    protected HumanArrayReferenceBeanInterface humanArrayReference;
    protected HumanBinaryNormalReferenceBeanInterface humanBinaryNormal;
    protected HumanBinaryHistoryReferenceBeanInterface humanBinaryHistory;
    protected HumanBinaryArrayReferenceBeanInterface humanBinaryArray;
    protected PositionReferenceBeanInterface position;
    protected EmploymentContractReferenceBeanInterface employmentContract;
    protected WorkPlaceReferenceBeanInterface workPlace;
    protected SectionReferenceBeanInterface section;
    protected EntranceDaoInterface enreanceDao;
    protected SuspensionDaoInterface suspensionDao;
    protected RetirementDaoInterface retirementDao;
    protected Date targetDate;
    protected String employeeCode;
    protected String fromEmployeeCode;
    protected String toEmployeeCode;
    protected String employeeName;
    protected String lastName;
    protected String firstName;
    protected String lastKana;
    protected String firstKana;
    protected String workPlaceCode;
    protected String employmentContractCode;
    protected String sectionCode;
    protected Boolean needLowerSection;
    protected String positionCode;
    protected String positionGradeRange;
    protected Boolean needConcurrent;
    protected String informationType;
    protected String searchWord;
    protected String stateType;
    protected String employeeCodeType;
    protected String lastNameType;
    protected String firstNameType;
    protected String lastKanaType;
    protected String firstKanaType;
    protected String unnecessaryPersonalId;
    protected Boolean needApproverRole;
    protected String operationType;
    protected Date startDate;
    protected Date endDate;
    public static final String KEY_VIEW_HUMAN_SEARCH = "HumanSearch";

    public HumanSearchBean() {
    }

    public HumanSearchBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (HumanSearchDaoInterface)this.createDao(HumanSearchDaoInterface.class);
        this.concurrentReference = (ConcurrentReferenceBeanInterface)this.createBean(ConcurrentReferenceBeanInterface.class);
        this.retirementReference = (RetirementReferenceBeanInterface)this.createBean(RetirementReferenceBeanInterface.class);
        this.suspensionReference = (SuspensionReferenceBeanInterface)this.createBean(SuspensionReferenceBeanInterface.class);
        this.humanNormalReference = (HumanNormalReferenceBeanInterface)this.createBean(HumanNormalReferenceBeanInterface.class);
        this.humanHistoryReference = (HumanHistoryReferenceBeanInterface)this.createBean(HumanHistoryReferenceBeanInterface.class);
        this.humanArrayReference = (HumanArrayReferenceBeanInterface)this.createBean(HumanArrayReferenceBeanInterface.class);
        this.humanBinaryNormal = (HumanBinaryNormalReferenceBeanInterface)this.createBean(HumanBinaryNormalReferenceBeanInterface.class);
        this.humanBinaryHistory = (HumanBinaryHistoryReferenceBeanInterface)this.createBean(HumanBinaryHistoryReferenceBeanInterface.class);
        this.humanBinaryArray = (HumanBinaryArrayReferenceBeanInterface)this.createBean(HumanBinaryArrayReferenceBeanInterface.class);
        this.position = (PositionReferenceBeanInterface)this.createBean(PositionReferenceBeanInterface.class);
        this.section = (SectionReferenceBeanInterface)this.createBean(SectionReferenceBeanInterface.class);
        this.employmentContract = (EmploymentContractReferenceBeanInterface)this.createBean(EmploymentContractReferenceBeanInterface.class);
        this.workPlace = (WorkPlaceReferenceBeanInterface)this.createBean(WorkPlaceReferenceBeanInterface.class);
        this.namingReference = (NamingReferenceBeanInterface)this.createBean(NamingReferenceBeanInterface.class);
        this.enreanceDao = (EntranceDaoInterface)this.createDao(EntranceDaoInterface.class);
        this.suspensionDao = (SuspensionDaoInterface)this.createDao(SuspensionDaoInterface.class);
        this.retirementDao = (RetirementDaoInterface)this.createDao(RetirementDaoInterface.class);
    }

    public List<HumanDtoInterface> search() throws MospException {
        Map param = this.dao.getParamsMap();
        param.put("targetDate", this.targetDate);
        param.put("employeeCode", this.employeeCode);
        param.put("fromEmployeeCode", this.fromEmployeeCode);
        param.put("toEmployeeCode", this.toEmployeeCode);
        param.put("employeeCodeType", this.employeeCodeType);
        param.put("employeeName", this.employeeName);
        param.put("lastName", this.lastName);
        param.put("lastNameType", this.lastNameType);
        param.put("workPlaceCode", this.workPlaceCode);
        param.put("sectionCode", this.sectionCode);
        param.put("needLowerSection", this.needLowerSection);
        param.put("positionCode", this.positionCode);
        param.put("positionGradeRange", this.positionGradeRange);
        param.put("needConcurrent", this.needConcurrent);
        param.put("employmentContractCode", this.employmentContractCode);
        param.put("firstName", this.firstName);
        param.put("firstNameType", this.firstNameType);
        param.put("lastKana", this.lastKana);
        param.put("lastKanaType", this.lastKanaType);
        param.put("firstKana", this.firstKana);
        param.put("firstKanaType", this.firstKanaType);
        param.put("employeeState", this.stateType);
        param.put("unnecessary", this.unnecessaryPersonalId);
        param.put("needApproverRole", this.needApproverRole);
        param.put("rangeWorkPlace", this.getRangeWorkPlace(this.operationType, this.targetDate));
        param.put("rangeEmploymentContract", this.getRangeEmploymentContract(this.operationType, this.targetDate));
        param.put("rangeSection", this.getRangeSection(this.operationType, this.targetDate));
        param.put("rangePosition", this.getRangePosition(this.operationType, this.targetDate));
        param.put("rangeEmployee", this.getRangeEmployee(this.operationType, this.targetDate));
        param.put("rangeConcurrent", this.getRangeConcurrent(this.operationType, this.targetDate));
        param.put("startDate", this.startDate);
        param.put("endDate", this.endDate);
        List humanList = this.searchForState(this.dao.findForSearch(param));
        return this.searchForFreeWord(humanList);
    }

    protected List<HumanDtoInterface> searchForState(List<HumanDtoInterface> list) throws MospException {
        if (this.stateType == null || this.stateType.isEmpty()) {
            return list;
        }
        ArrayList<HumanDtoInterface> resultList = new ArrayList<HumanDtoInterface>();
        if (this.stateType.equals("presence")) {
            Set enreancedSet = this.enreanceDao.findForEntrancedPersonalIdSet(this.targetDate, this.startDate, this.endDate);
            Set suspendedSet = this.getSuspendedPersonalIdSet();
            Set retirementedSet = this.getRetiredPersonalIdSet();
            for (HumanDtoInterface dto : list) {
                if (!enreancedSet.contains(dto.getPersonalId()) || suspendedSet.contains(dto.getPersonalId()) || retirementedSet.contains(dto.getPersonalId())) continue;
                resultList.add(dto);
            }
        }
        if (this.stateType.equals("suspend")) {
            Set suspendedSet = this.getSuspendedPersonalIdSet();
            for (HumanDtoInterface dto : list) {
                if (!suspendedSet.contains(dto.getPersonalId())) continue;
                resultList.add(dto);
            }
        }
        if (this.stateType.equals("retire")) {
            Set retirementedSet = this.getRetiredPersonalIdSet();
            for (HumanDtoInterface dto : list) {
                if (!retirementedSet.contains(dto.getPersonalId())) continue;
                resultList.add(dto);
            }
        }
        return resultList;
    }

    protected Set<String> getSuspendedPersonalIdSet() throws MospException {
        HashSet<String> termSet = new HashSet<String>();
        Map suspensionMap = this.getSuspentionMap();
        if (this.startDate == null || this.endDate == null) {
            return suspensionMap.keySet();
        }
        for (Map.Entry entry : suspensionMap.entrySet()) {
            String personalId = (String)entry.getKey();
            List personalList = (List)entry.getValue();
            if (((SuspensionDtoInterface)personalList.get(0)).getStartDate().compareTo(this.startDate) > 0) continue;
            Date suspensionEndDate = null;
            for (SuspensionDtoInterface dto : personalList) {
                if (suspensionEndDate != null && dto.getStartDate().compareTo(DateUtility.addDay((Date)suspensionEndDate, (int)1)) != 0) break;
                suspensionEndDate = dto.getEndDate();
                if (suspensionEndDate != null) continue;
                suspensionEndDate = dto.getScheduleEndDate();
            }
            if (suspensionEndDate.compareTo(this.endDate) < 0) continue;
            termSet.add(personalId);
        }
        return termSet;
    }

    protected Map<String, List<SuspensionDtoInterface>> getSuspentionMap() throws MospException {
        List list = this.suspensionDao.findForList(this.targetDate, this.startDate, this.endDate);
        HashMap<String, List<SuspensionDtoInterface>> map = new HashMap<String, List<SuspensionDtoInterface>>();
        for (SuspensionDtoInterface dto : list) {
            ArrayList<SuspensionDtoInterface> personalList = (ArrayList<SuspensionDtoInterface>)map.get(dto.getPersonalId());
            if (personalList == null) {
                personalList = new ArrayList<SuspensionDtoInterface>();
                map.put(dto.getPersonalId(), personalList);
            }
            personalList.add(dto);
        }
        return map;
    }

    protected Set<String> getRetiredPersonalIdSet() throws MospException {
        return this.retirementDao.findForRetiredPersonalIdSet(this.targetDate, this.startDate, this.endDate);
    }

    protected String[][][] getRangeConcurrent(String operationType, Date targetDate) throws MospException {
        if (operationType == null) {
            return new String[0][][];
        }
        RangeProperty range = (RangeProperty)this.mospParams.getStoredInfo().getRangeMap().get(operationType);
        if (range == null) {
            return new String[0][][];
        }
        String rangeSection = range.getSection();
        if (rangeSection == null || rangeSection.isEmpty() || !this.asList(rangeSection, ",").contains("RangeMyself")) {
            return new String[0][][];
        }
        String rangePosition = range.getPosition();
        if (rangePosition == null || rangePosition.isEmpty() || !this.asList(rangePosition, ",").contains("RangeMyself")) {
            return new String[0][][];
        }
        ConcurrentReferenceBeanInterface concurrentRefer = (ConcurrentReferenceBeanInterface)this.createBean(ConcurrentReferenceBeanInterface.class);
        List concurrentList = concurrentRefer.getConcurrentList(this.mospParams.getUser().getPersonalId(), targetDate);
        String[][][] rangeConcurrent = new String[concurrentList.size()][][];
        for (int i = 0; i < rangeConcurrent.length; ++i) {
            ConcurrentDtoInterface concurrent = (ConcurrentDtoInterface)concurrentList.get(i);
            String[][] concurrentArray = new String[][]{{concurrent.getSectionCode()}, {concurrent.getPositionCode()}};
            rangeConcurrent[i] = concurrentArray;
        }
        return rangeConcurrent;
    }

    protected List<HumanDtoInterface> searchForFreeWord(List<HumanDtoInterface> humanList) throws MospException {
        if (this.informationType == null || this.informationType.isEmpty() || this.searchWord == null || this.searchWord.isEmpty()) {
            return humanList;
        }
        String[] arySearchWord = MospUtility.split((String)this.searchWord, (String)FREE_WORD_SEPARATOR);
        ViewConfigProperty viewConfig = (ViewConfigProperty)this.mospParams.getProperties().getViewConfigProperties().get(this.informationType);
        if (this.informationType.equals("human")) {
            return this.searchForFreeWordHuman(humanList, arySearchWord);
        }
        if (this.informationType.equals("suspend")) {
            return this.searchForFreeWordSuspensionInfo(humanList, arySearchWord);
        }
        if (this.informationType.equals("retire")) {
            return this.searchForFreeWordRetirementInfo(humanList, arySearchWord);
        }
        if (this.informationType.equals("concur")) {
            return this.searchForFreeWordConcurrentInfo(humanList, arySearchWord);
        }
        if (viewConfig != null && viewConfig.getType().equals("Normal")) {
            return this.searchForFreeWordHumanNormalInfo(this.informationType, humanList, arySearchWord);
        }
        if (viewConfig != null && viewConfig.getType().equals("History")) {
            return this.searchForFreeWordHumanHistoryInfo(this.informationType, humanList, arySearchWord);
        }
        if (viewConfig != null && viewConfig.getType().equals("Array")) {
            return this.searchForFreeWordHumanArrayInfo(this.informationType, humanList, arySearchWord, this.targetDate);
        }
        if (viewConfig != null && viewConfig.getType().equals("BinaryNormal")) {
            return this.searchForFreeWordHumanBinaryNormalInfo(this.informationType, humanList, arySearchWord);
        }
        if (viewConfig != null && viewConfig.getType().equals("BinaryHistory")) {
            return this.searchForFreeWordHumanBinaryHistoryInfo(this.informationType, humanList, arySearchWord);
        }
        if (viewConfig != null && viewConfig.getType().equals("BinaryArray")) {
            return this.searchForFreeWordHumanBinaryArrayInfo(this.informationType, humanList, arySearchWord);
        }
        return humanList;
    }

    protected List<HumanDtoInterface> searchForFreeWordHuman(List<HumanDtoInterface> humanList, String[] arySearchWord) throws MospException {
        ArrayList<HumanDtoInterface> resultList = new ArrayList<HumanDtoInterface>();
        boolean isPost = false;
        isPost = this.mospParams.getApplicationPropertyBool("UsePost");
        block0: for (HumanDtoInterface humanDto : humanList) {
            Date targetDate = humanDto.getActivateDate();
            for (String searchWord : arySearchWord) {
                String namingItemCode;
                String resultPositionCode;
                if (searchWord.isEmpty()) break;
                String resultWorkPlaceCode = humanDto.getWorkPlaceCode();
                if (!resultWorkPlaceCode.isEmpty()) {
                    WorkPlaceDtoInterface resultWorkPlaceDto = this.workPlace.getWorkPlaceInfo(resultWorkPlaceCode, targetDate);
                    if (this.isBroadMatch(searchWord, resultWorkPlaceDto.getWorkPlaceName())) {
                        resultList.add(humanDto);
                        continue block0;
                    }
                    if (this.isBroadMatch(searchWord, resultWorkPlaceDto.getWorkPlaceAbbr())) {
                        resultList.add(humanDto);
                        continue block0;
                    }
                    if (this.isBroadMatch(searchWord, resultWorkPlaceDto.getWorkPlaceKana())) {
                        resultList.add(humanDto);
                        continue block0;
                    }
                }
                if (this.isSearchPosition(resultPositionCode = humanDto.getPositionCode(), searchWord, targetDate)) {
                    resultList.add(humanDto);
                    continue block0;
                }
                String resultSectionCode = humanDto.getSectionCode();
                if (this.isSearchSecition(resultSectionCode, searchWord, targetDate)) {
                    resultList.add(humanDto);
                    continue block0;
                }
                String resultEmployementCode = humanDto.getEmploymentContractCode();
                if (!resultEmployementCode.isEmpty()) {
                    EmploymentContractDtoInterface resultEmploymentDto = this.employmentContract.getContractInfo(resultEmployementCode, targetDate);
                    if (this.isBroadMatch(searchWord, resultEmploymentDto.getEmploymentContractName())) {
                        resultList.add(humanDto);
                        continue block0;
                    }
                    if (this.isBroadMatch(searchWord, resultEmploymentDto.getEmploymentContractAbbr())) {
                        resultList.add(humanDto);
                        continue block0;
                    }
                }
                if (!isPost) continue;
                HumanHistoryDtoInterface humanHistory = this.humanHistoryReference.findForInfo(humanDto.getPersonalId(), "post", targetDate);
                if (humanHistory == null || (namingItemCode = humanHistory.getHumanItemValue()).isEmpty()) continue block0;
                NamingDtoInterface namingDto = this.namingReference.getNamingItemInfo("post", namingItemCode, targetDate);
                if (this.isBroadMatch(searchWord, namingDto.getNamingItemName())) {
                    resultList.add(humanDto);
                    continue block0;
                }
                if (!this.isBroadMatch(searchWord, namingDto.getNamingItemAbbr())) continue;
                resultList.add(humanDto);
                continue block0;
            }
        }
        return resultList;
    }

    protected List<HumanDtoInterface> searchForFreeWordSuspensionInfo(List<HumanDtoInterface> humanList, String[] arySearchWord) throws MospException {
        ArrayList<HumanDtoInterface> resultList = new ArrayList<HumanDtoInterface>();
        for (HumanDtoInterface humanDto : humanList) {
            List suspensionList = this.suspensionReference.getSuspentionList(humanDto.getPersonalId());
            if (suspensionList.isEmpty()) continue;
            block1: for (SuspensionDtoInterface suspensionDto : suspensionList) {
                for (String searchWord : arySearchWord) {
                    if (searchWord.isEmpty()) break;
                    if (this.isBroadMatch(searchWord, DateUtility.getStringDate((Date)suspensionDto.getStartDate()))) {
                        resultList.add(humanDto);
                        continue block1;
                    }
                    if (this.isBroadMatch(searchWord, DateUtility.getStringDate((Date)suspensionDto.getScheduleEndDate()))) {
                        resultList.add(humanDto);
                        continue block1;
                    }
                    String allwanceType = suspensionDto.getAllowanceType();
                    if (!allwanceType.isEmpty() && this.isBroadMatch(searchWord, allwanceType)) {
                        resultList.add(humanDto);
                        continue block1;
                    }
                    String endDate = DateUtility.getStringDate((Date)suspensionDto.getEndDate());
                    if (!endDate.isEmpty() && this.isBroadMatch(searchWord, endDate)) {
                        resultList.add(humanDto);
                        continue block1;
                    }
                    String suspentionReason = suspensionDto.getSuspensionReason();
                    if (suspentionReason.isEmpty() || !this.isBroadMatch(searchWord, suspentionReason)) continue;
                    resultList.add(humanDto);
                    continue block1;
                }
            }
        }
        return resultList;
    }

    protected List<HumanDtoInterface> searchForFreeWordRetirementInfo(List<HumanDtoInterface> humanList, String[] arySearchWord) throws MospException {
        ArrayList<HumanDtoInterface> resultList = new ArrayList<HumanDtoInterface>();
        block0: for (HumanDtoInterface humanDto : humanList) {
            RetirementDtoInterface retirementDto = this.retirementReference.getRetireInfo(humanDto.getPersonalId());
            if (retirementDto == null) continue;
            for (String searchWord : arySearchWord) {
                if (searchWord.isEmpty()) break;
                if (this.isBroadMatch(searchWord, DateUtility.getStringDate((Date)retirementDto.getRetirementDate()))) {
                    resultList.add(humanDto);
                    continue block0;
                }
                String retirementResonCode = retirementDto.getRetirementReason();
                String retirementReson = this.getCodeName(retirementResonCode, "Retirement");
                if (this.isBroadMatch(searchWord, retirementReson)) {
                    resultList.add(humanDto);
                    continue block0;
                }
                String retirementDetail = retirementDto.getRetirementDetail();
                if (retirementDetail.isEmpty() || !this.isBroadMatch(searchWord, retirementDetail)) continue;
                resultList.add(humanDto);
                continue block0;
            }
        }
        return resultList;
    }

    protected List<HumanDtoInterface> searchForFreeWordConcurrentInfo(List<HumanDtoInterface> humanList, String[] arySearchWord) throws MospException {
        ArrayList<HumanDtoInterface> resultList = new ArrayList<HumanDtoInterface>();
        for (HumanDtoInterface humanDto : humanList) {
            List concurrentList = this.concurrentReference.getConcurrentList(humanDto.getPersonalId(), this.targetDate);
            if (concurrentList.isEmpty()) continue;
            block1: for (ConcurrentDtoInterface concurrentDto : concurrentList) {
                for (String searchWord : arySearchWord) {
                    if (searchWord.isEmpty()) break;
                    if (this.isBroadMatch(searchWord, DateUtility.getStringDate((Date)concurrentDto.getStartDate()))) {
                        resultList.add(humanDto);
                        continue block1;
                    }
                    String concurrentRemark = concurrentDto.getConcurrentRemark();
                    if (!concurrentRemark.isEmpty() && this.isBroadMatch(searchWord, concurrentRemark)) {
                        resultList.add(humanDto);
                        continue block1;
                    }
                    String endDate = DateUtility.getStringDate((Date)concurrentDto.getEndDate());
                    if (!endDate.isEmpty() && this.isBroadMatch(searchWord, endDate)) {
                        resultList.add(humanDto);
                        continue block1;
                    }
                    String resultPositionCode = concurrentDto.getPositionCode();
                    if (this.isSearchPosition(resultPositionCode, searchWord, this.targetDate)) {
                        resultList.add(humanDto);
                        continue block1;
                    }
                    String resultSectionCode = concurrentDto.getSectionCode();
                    if (!this.isSearchSecition(resultSectionCode, searchWord, this.targetDate)) continue;
                    resultList.add(humanDto);
                    continue block1;
                }
            }
        }
        return resultList;
    }

    protected List<HumanDtoInterface> searchForFreeWordHumanNormalInfo(String division, List<HumanDtoInterface> humanList, String[] arySearchWord) throws MospException {
        ArrayList<HumanDtoInterface> resultList = new ArrayList<HumanDtoInterface>();
        for (HumanDtoInterface humanDto : humanList) {
            Date activeDate = humanDto.getActivateDate();
            String personalId = humanDto.getPersonalId();
            Map normalMap = this.humanNormalReference.getShowHumanNormalMapInfo(division, KEY_VIEW_HUMAN_SEARCH, personalId, activeDate, this.targetDate);
            if (normalMap.isEmpty() || !this.isSearchHumanGeneral(arySearchWord, normalMap)) continue;
            resultList.add(humanDto);
        }
        return resultList;
    }

    protected List<HumanDtoInterface> searchForFreeWordHumanHistoryInfo(String division, List<HumanDtoInterface> humanList, String[] arySearchWord) throws MospException {
        ArrayList<HumanDtoInterface> resultList = new ArrayList<HumanDtoInterface>();
        block0: for (HumanDtoInterface humanDto : humanList) {
            String personalId = humanDto.getPersonalId();
            LinkedHashMap historyMap = this.humanHistoryReference.getHumanHistoryMapInfo(division, KEY_VIEW_HUMAN_SEARCH, personalId, this.targetDate, this.targetDate);
            if (historyMap.isEmpty()) continue;
            ArrayList historyList = new ArrayList(historyMap.keySet());
            for (String mapDate : historyList) {
                Map historyItemMap = (Map)historyMap.get(mapDate);
                if (!this.isSearchHumanGeneral(arySearchWord, historyItemMap)) continue;
                resultList.add(humanDto);
                continue block0;
            }
        }
        return resultList;
    }

    protected List<HumanDtoInterface> searchForFreeWordHumanArrayInfo(String division, List<HumanDtoInterface> humanList, String[] arySearchWord, Date targetDate) throws MospException {
        ArrayList<HumanDtoInterface> resultList = new ArrayList<HumanDtoInterface>();
        block0: for (HumanDtoInterface humanDto : humanList) {
            String personalId = humanDto.getPersonalId();
            LinkedHashMap arrayMap = this.humanArrayReference.getRowIdArrayMapInfo(division, KEY_VIEW_HUMAN_SEARCH, personalId, targetDate);
            if (arrayMap.isEmpty()) continue;
            ArrayList rowIdList = new ArrayList(arrayMap.keySet());
            for (String rowId : rowIdList) {
                Map arrayItemMap = (Map)arrayMap.get(rowId);
                if (!this.isSearchHumanGeneral(arySearchWord, arrayItemMap)) continue;
                resultList.add(humanDto);
                continue block0;
            }
        }
        return resultList;
    }

    protected List<HumanDtoInterface> searchForFreeWordHumanBinaryNormalInfo(String division, List<HumanDtoInterface> humanList, String[] arySearchWord) throws MospException {
        ArrayList<HumanDtoInterface> resultList = new ArrayList<HumanDtoInterface>();
        block0: for (HumanDtoInterface humanDto : humanList) {
            String personalId = humanDto.getPersonalId();
            HumanBinaryNormalDtoInterface binarynormal = this.humanBinaryNormal.findForInfo(personalId, division);
            if (binarynormal == null) continue;
            for (String searchWord : arySearchWord) {
                if (searchWord.isEmpty()) break;
                if (!this.isSearchHumanBinaryGeneral(binarynormal.getFileType(), binarynormal.getFileName(), binarynormal.getFileRemark(), searchWord)) continue;
                resultList.add(humanDto);
                continue block0;
            }
        }
        return resultList;
    }

    protected List<HumanDtoInterface> searchForFreeWordHumanBinaryHistoryInfo(String division, List<HumanDtoInterface> humanList, String[] arySearchWord) throws MospException {
        ArrayList<HumanDtoInterface> resultList = new ArrayList<HumanDtoInterface>();
        for (HumanDtoInterface humanDto : humanList) {
            String personalId = humanDto.getPersonalId();
            List binaryHistoryList = this.humanBinaryHistory.findForHistory(personalId, division);
            if (binaryHistoryList.isEmpty()) continue;
            block1: for (HumanBinaryHistoryDtoInterface binaryHistory : binaryHistoryList) {
                for (String searchWord : arySearchWord) {
                    if (searchWord.isEmpty()) break;
                    if (!this.isSearchHumanBinaryGeneral(binaryHistory.getFileType(), binaryHistory.getFileName(), binaryHistory.getFileRemark(), searchWord)) continue;
                    resultList.add(humanDto);
                    continue block1;
                }
            }
        }
        return resultList;
    }

    protected List<HumanDtoInterface> searchForFreeWordHumanBinaryArrayInfo(String division, List<HumanDtoInterface> humanList, String[] arySearchWord) throws MospException {
        ArrayList<HumanDtoInterface> resultList = new ArrayList<HumanDtoInterface>();
        for (HumanDtoInterface humanDto : humanList) {
            String personalId = humanDto.getPersonalId();
            List binaryArrayList = this.humanBinaryArray.findForItemType(personalId, division);
            if (binaryArrayList.isEmpty()) continue;
            block1: for (HumanBinaryArrayDtoInterface binaryArray : binaryArrayList) {
                for (String searchWord : arySearchWord) {
                    if (searchWord.isEmpty()) break;
                    if (!this.isSearchHumanBinaryGeneral(binaryArray.getFileType(), binaryArray.getFileName(), binaryArray.getFileRemark(), searchWord)) continue;
                    resultList.add(humanDto);
                    continue block1;
                }
            }
        }
        return resultList;
    }

    protected boolean isSearchHumanGeneral(String[] arySearchWord, Map<String, String> itemMap) throws MospException {
        ArrayList<String> itemNameList = new ArrayList<String>(itemMap.keySet());
        for (String itemKey : itemNameList) {
            String value = itemMap.get(itemKey);
            for (String searchWord : arySearchWord) {
                if (searchWord.isEmpty()) {
                    return false;
                }
                if (value.isEmpty() || !this.isBroadMatch(searchWord, value)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isSearchHumanBinaryGeneral(String fileType, String fileName, String remark, String searchWord) throws MospException {
        if (!fileType.isEmpty() && this.isBroadMatch(searchWord, this.getCodeName(fileType, "BinaryFileType"))) {
            return true;
        }
        if (this.isBroadMatch(searchWord, fileName)) {
            return true;
        }
        return !remark.isEmpty() && this.isBroadMatch(searchWord, remark);
    }

    protected boolean isSearchPosition(String resultPositionCode, String searchWord, Date targetDate) throws MospException {
        if (!resultPositionCode.isEmpty()) {
            if (this.isBroadMatch(searchWord, this.position.getPositionName(resultPositionCode, targetDate))) {
                return true;
            }
            if (this.isBroadMatch(searchWord, this.position.getPositionAbbr(resultPositionCode, targetDate))) {
                return true;
            }
        }
        return false;
    }

    protected boolean isSearchSecition(String resultSectionCode, String searchWord, Date targetDate) throws MospException {
        if (!resultSectionCode.isEmpty()) {
            if (this.isBroadMatch(searchWord, this.section.getSectionName(resultSectionCode, targetDate))) {
                return true;
            }
            if (this.isBroadMatch(searchWord, this.section.getSectionAbbr(resultSectionCode, targetDate))) {
                return true;
            }
        }
        return false;
    }

    public List<HumanListDtoInterface> getHumanList() throws MospException {
        List list = this.search();
        String[][] aryWorkPlace = this.workPlace.getSelectArray(this.targetDate, true, null);
        String[][] aryEmploymentContract = this.employmentContract.getSelectArray(this.targetDate, true, null);
        String[][] arySection = this.section.getNameSelectArray(this.targetDate, true, null);
        String[][] aryPosition = this.position.getSelectArray(this.targetDate, true, null);
        ArrayList<HumanListDtoInterface> humanList = new ArrayList<HumanListDtoInterface>();
        int count = 0;
        Map retirementMap = null;
        Map suspensionMap = null;
        Map enreanceMap = null;
        for (HumanDtoInterface dto : list) {
            if (count % this.getPersonalIdsMaxIndex() == 0) {
                String[] personalIds = this.getPersonalIds(list, count);
                retirementMap = this.retirementDao.findForPersonalIds(personalIds);
                suspensionMap = this.suspensionDao.findForPersonalIds(personalIds);
                enreanceMap = this.enreanceDao.findForPersonalIds(personalIds);
            }
            PfaHumanListDto humanListDto = new PfaHumanListDto();
            humanListDto.setPfmHumanId(String.valueOf(dto.getPfmHumanId()));
            humanListDto.setPersonalId(dto.getPersonalId());
            humanListDto.setEmployeeCode(dto.getEmployeeCode());
            humanListDto.setLastName(dto.getLastName());
            humanListDto.setFirstName(dto.getFirstName());
            humanListDto.setLastKana(dto.getLastKana());
            humanListDto.setFirstKana(dto.getFirstKana());
            humanListDto.setWorkPlaceCode(dto.getWorkPlaceCode());
            if (!dto.getWorkPlaceCode().isEmpty()) {
                humanListDto.setWorkPlaceAbbr(this.getCodeName(dto.getWorkPlaceCode(), aryWorkPlace));
            }
            humanListDto.setSectionCode(dto.getSectionCode());
            if (!dto.getSectionCode().isEmpty()) {
                humanListDto.setSectionName(this.getCodeName(dto.getSectionCode(), arySection));
            }
            humanListDto.setPositionCode(dto.getPositionCode());
            if (!dto.getPositionCode().isEmpty()) {
                humanListDto.setPositionAbbr(this.getCodeName(dto.getPositionCode(), aryPosition));
            }
            humanListDto.setEmploymentContractCode(dto.getEmploymentContractCode());
            if (!dto.getEmploymentContractCode().isEmpty()) {
                humanListDto.setEmploymentContractAbbr(this.getCodeName(dto.getEmploymentContractCode(), aryEmploymentContract));
            }
            if (this.isRetired((RetirementDtoInterface)retirementMap.get(dto.getPersonalId()), this.targetDate)) {
                humanListDto.setRetireState(this.mospParams.getProperties().getName("RetirementOn"));
            } else if (this.isSuspended((SuspensionDtoInterface)suspensionMap.get(dto.getPersonalId()))) {
                humanListDto.setRetireState(this.mospParams.getProperties().getName("RetirementLeave"));
            } else if (!this.isEntered((EntranceDtoInterface)enreanceMap.get(dto.getPersonalId()), this.targetDate)) {
                humanListDto.setRetireState("");
            } else {
                humanListDto.setRetireState(this.mospParams.getProperties().getName("RetirementOff"));
            }
            humanList.add((HumanListDtoInterface)humanListDto);
            ++count;
        }
        return humanList;
    }

    public Set<String> getPersonalIdSet() throws MospException {
        return PlatformUtility.getPersonalIdSet((List)this.search());
    }

    public String[][] getCodedSelectArray(boolean needBlank) throws MospException {
        return this.getSelectArray(needBlank, true);
    }

    protected String[][] getSelectArray(boolean needBlank, boolean viewCode) throws MospException {
        List list = this.search();
        if (list.size() == 0) {
            return this.getNoObjectDataPulldown();
        }
        int length = this.getMaxCodeLength(list, viewCode);
        String[][] array = this.prepareSelectArray(list.size(), needBlank);
        int idx = needBlank ? 1 : 0;
        for (HumanDtoInterface dto : list) {
            array[idx][0] = dto.getPersonalId();
            if (viewCode) {
                array[idx++][1] = this.getCodedName(dto.getEmployeeCode(), this.getHumanName(dto), length);
                continue;
            }
            array[idx++][1] = this.getHumanName(dto);
        }
        return array;
    }

    public Map<String, HumanDtoInterface> getHumanDtoMap() throws MospException {
        HashMap<String, HumanDtoInterface> map = new HashMap<String, HumanDtoInterface>();
        List list = this.search();
        for (HumanDtoInterface dto : list) {
            map.put(dto.getPersonalId(), dto);
        }
        return map;
    }

    protected int getMaxCodeLength(List<HumanDtoInterface> list, boolean viewCode) {
        if (!viewCode) {
            return 0;
        }
        int length = 0;
        for (HumanDtoInterface dto : list) {
            if (dto.getEmployeeCode().length() <= length) continue;
            length = dto.getEmployeeCode().length();
        }
        return length;
    }

    public void setTargetDate(Date targetDate) {
        this.targetDate = this.getDateClone(targetDate);
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public void setFromEmployeeCode(String fromEmployeeCode) {
        this.fromEmployeeCode = fromEmployeeCode;
    }

    public void setToEmployeeCode(String toEmployeeCode) {
        this.toEmployeeCode = toEmployeeCode;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastKana(String lastKana) {
        this.lastKana = lastKana;
    }

    public void setFirstKana(String firstKana) {
        this.firstKana = firstKana;
    }

    public void setSectionCode(String sectionCode) {
        this.sectionCode = sectionCode;
    }

    public void setNeedLowerSection(boolean needLowerSection) {
        this.needLowerSection = needLowerSection;
    }

    public void setPositionCode(String positionCode) {
        this.positionCode = positionCode;
    }

    public void setPositionGradeRange(String positionGradeRange) {
        this.positionGradeRange = positionGradeRange;
    }

    public void setNeedConcurrent(boolean needConcurrent) {
        this.needConcurrent = needConcurrent;
    }

    public void setEmploymentContractCode(String employmentContractCode) {
        this.employmentContractCode = employmentContractCode;
    }

    public void setWorkPlaceCode(String workPlaceCode) {
        this.workPlaceCode = workPlaceCode;
    }

    public void setInformationType(String informationType) {
        this.informationType = informationType;
    }

    public void setSearchWord(String searchWord) {
        this.searchWord = searchWord;
    }

    public void setStateType(String stateType) {
        this.stateType = stateType;
    }

    public void setEmployeeCodeType(String employeeCodeType) {
        this.employeeCodeType = employeeCodeType;
    }

    public void setLastNameType(String lastNameType) {
        this.lastNameType = lastNameType;
    }

    public void setFirstNameType(String firstNameType) {
        this.firstNameType = firstNameType;
    }

    public void setLastKanaType(String lastKanaType) {
        this.lastKanaType = lastKanaType;
    }

    public void setFirstKanaType(String firstKanaType) {
        this.firstKanaType = firstKanaType;
    }

    public void setUnnecessaryPersonalId(String unnecessaryPersonalId) {
        this.unnecessaryPersonalId = unnecessaryPersonalId;
    }

    public void setNeedApproverRole(boolean needApproverRole) {
        this.needApproverRole = needApproverRole;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public void setStartDate(Date startDate) {
        this.startDate = this.getDateClone(startDate);
    }

    public void setEndDate(Date endDate) {
        this.endDate = this.getDateClone(endDate);
    }

    protected String[] getPersonalIds(List<HumanDtoInterface> humanList, int index) {
        int indexCount = this.getPersonalIdsMaxIndex();
        int lastIndex = index + indexCount;
        if (lastIndex > humanList.size()) {
            lastIndex = humanList.size();
        }
        String[] personalIds = new String[lastIndex - index];
        for (int i = index; i < personalIds.length; ++i) {
            personalIds[i] = humanList.get(index++).getPersonalId();
        }
        return personalIds;
    }

    protected boolean isRetired(RetirementDtoInterface dto, Date targetDate) throws MospException {
        if (dto != null) {
            return targetDate.compareTo(dto.getRetirementDate()) > 0;
        }
        return false;
    }

    protected boolean isSuspended(SuspensionDtoInterface dto) throws MospException {
        return dto != null;
    }

    public boolean isEntered(EntranceDtoInterface dto, Date targetDate) throws MospException {
        if (dto != null) {
            return targetDate.compareTo(dto.getEntranceDate()) >= 0;
        }
        return false;
    }
}

