/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.sql.Connection;
import java.util.Date;
import jp.mosp.framework.base.BaseBean;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.dao.human.RetirementDaoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;

public class RetirementReferenceBean
extends BaseBean
implements RetirementReferenceBeanInterface {
    private RetirementDaoInterface retirementDao;

    public RetirementReferenceBean() {
    }

    protected RetirementReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.retirementDao = (RetirementDaoInterface)this.createDao(RetirementDaoInterface.class);
    }

    public RetirementDtoInterface getRetireInfo(String personalId, Date targetDate) throws MospException {
        return this.retirementDao.findForInfo(personalId, targetDate);
    }

    public RetirementDtoInterface getRetireInfo(String personalId) throws MospException {
        return this.retirementDao.findForInfo(personalId);
    }

    public boolean isRetired(String personalId, Date targetDate) throws MospException {
        RetirementDtoInterface dto = this.getRetireInfo(personalId, targetDate);
        if (dto != null) {
            return targetDate.compareTo(dto.getRetirementDate()) > 0;
        }
        return false;
    }

    public RetirementDtoInterface findForKey(long id) throws MospException {
        BaseDto dto = this.findForKey((BaseDaoInterface)this.retirementDao, id, false);
        if (dto != null) {
            return (RetirementDtoInterface)dto;
        }
        return null;
    }

    public Date getRetireDate(String personalId) throws MospException {
        RetirementDtoInterface dto = this.getRetireInfo(personalId);
        if (dto != null) {
            return dto.getRetirementDate();
        }
        return null;
    }
}

