/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.message.impl;

import java.sql.Connection;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.message.MessageRegistBeanInterface;
import jp.mosp.platform.bean.system.PlatformMasterCheckBeanInterface;
import jp.mosp.platform.dao.message.MessageDaoInterface;
import jp.mosp.platform.dto.message.MessageDtoInterface;
import jp.mosp.platform.dto.message.impl.PftMessageDto;

public class MessageRegistBean
extends PlatformBean
implements MessageRegistBeanInterface {
    protected MessageDaoInterface dao;
    protected PlatformMasterCheckBeanInterface masterCheck;
    protected static final String FORMAT_MESSAGE_NO = "0000000000";

    public MessageRegistBean() {
    }

    protected MessageRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (MessageDaoInterface)this.createDao(MessageDaoInterface.class);
        this.masterCheck = (PlatformMasterCheckBeanInterface)this.createBean(PlatformMasterCheckBeanInterface.class);
    }

    public MessageDtoInterface getInitDto() {
        return new PftMessageDto();
    }

    public void insert(MessageDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setMessageNo(this.issueSequenceNo(this.dao.getMaxMessageNo(), FORMAT_MESSAGE_NO));
        dto.setPftMessageId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(MessageDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPftMessageId());
        dto.setPftMessageId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(MessageDtoInterface dto) throws MospException {
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPftMessageId());
    }

    protected void checkInsert(MessageDtoInterface dto) throws MospException {
        this.masterCheck.isCheckEmploymentContract(dto.getEmploymentContractCode(), dto.getStartDate(), dto.getEndDate());
        this.masterCheck.isCheckPosition(dto.getPositionCode(), dto.getStartDate(), dto.getEndDate());
        this.masterCheck.isCheckSection(dto.getSectionCode(), dto.getStartDate(), dto.getEndDate());
        this.masterCheck.isCheckWorkPlace(dto.getWorkPlaceCode(), dto.getStartDate(), dto.getEndDate());
    }

    protected void checkUpdate(MessageDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPftMessageId());
        this.masterCheck.isCheckEmploymentContract(dto.getEmploymentContractCode(), dto.getStartDate(), dto.getEndDate());
        this.masterCheck.isCheckPosition(dto.getPositionCode(), dto.getStartDate(), dto.getEndDate());
        this.masterCheck.isCheckSection(dto.getSectionCode(), dto.getStartDate(), dto.getEndDate());
        this.masterCheck.isCheckWorkPlace(dto.getWorkPlaceCode(), dto.getStartDate(), dto.getEndDate());
    }

    protected void checkDelete(MessageDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPftMessageId());
    }

    protected void validate(MessageDtoInterface dto) {
        if (!this.checkDateOrder(dto.getStartDate(), dto.getEndDate(), true)) {
            this.addInvalidOrderMessage(this.getNameMessageStartDate(), this.getNameMessageEndDate());
        }
    }

    protected String getNameMessageStartDate() {
        return this.mospParams.getName("Open") + this.mospParams.getName("Start") + this.mospParams.getName("Day");
    }

    protected String getNameMessageEndDate() {
        return this.mospParams.getName("Open") + this.mospParams.getName("End") + this.mospParams.getName("Day");
    }
}

