/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.io.InputStream;
import java.sql.Connection;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.orangesignal.OrangeSignalParams;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.file.CsvImportBeanInterface;
import jp.mosp.platform.bean.system.BankBaseRegistBeanInterface;
import jp.mosp.platform.dao.system.BankBaseDaoInterface;
import jp.mosp.platform.dto.system.BankBaseDtoInterface;
import jp.mosp.platform.dto.system.impl.PfmBankBaseDto;

public class BankBaseRegistBean
extends PlatformBean
implements BankBaseRegistBeanInterface,
CsvImportBeanInterface {
    BankBaseDaoInterface dao;

    public BankBaseRegistBean() {
    }

    public BankBaseRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (BankBaseDaoInterface)this.createDao(BankBaseDaoInterface.class);
    }

    public BankBaseDtoInterface getInitDto() {
        return new PfmBankBaseDto();
    }

    public void insert(BankBaseDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmBankBaseId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(BankBaseDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmBankBaseId());
        dto.setPfmBankBaseId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(BankBaseDtoInterface dto) throws MospException {
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmBankBaseId());
    }

    public int importCsv(InputStream requestedFile) throws MospException {
        List dataList = OrangeSignalUtility.parse((InputStream)requestedFile, (OrangeSignalParams)new OrangeSignalParams());
        for (String[] data : dataList) {
            int idx = 0;
            PfmBankBaseDto dto = new PfmBankBaseDto();
            dto.setBankCode(data[idx++].trim());
            dto.setBankNameKana(data[idx++].trim());
            dto.setBankName(data[idx++].trim());
            dto.setInactivateFlag(this.getInactivateFlag(data[idx++]));
            dto.setDeleteFlag(0);
            this.insert((BankBaseDtoInterface)dto);
        }
        return dataList.size();
    }

    protected int getInactivateFlag(String data) {
        return Integer.parseInt(data.trim()) == 1 ? 0 : 1;
    }

    protected void checkInsert(BankBaseDtoInterface dto) throws MospException {
    }

    protected void checkUpdate(BankBaseDtoInterface dto) throws MospException {
    }

    protected void checkDelete(BankBaseDtoInterface dto) throws MospException {
    }

    protected void validate(BankBaseDtoInterface dto) {
    }
}

