/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.io.InputStream;
import java.sql.Connection;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.orangesignal.OrangeSignalParams;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.file.CsvImportBeanInterface;
import jp.mosp.platform.bean.system.BankBranchRegistBeanInterface;
import jp.mosp.platform.dao.system.BankBranchDaoInterface;
import jp.mosp.platform.dto.system.BankBranchDtoInterface;
import jp.mosp.platform.dto.system.impl.PfmBankBranchDto;

public class BankBranchRegistBean
extends PlatformBean
implements BankBranchRegistBeanInterface,
CsvImportBeanInterface {
    BankBranchDaoInterface dao;

    public BankBranchRegistBean() {
    }

    public BankBranchRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (BankBranchDaoInterface)this.createDao(BankBranchDaoInterface.class);
    }

    public BankBranchDtoInterface getInitDto() {
        return new PfmBankBranchDto();
    }

    public void insert(BankBranchDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmBankBranchId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(BankBranchDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmBankBranchId());
        dto.setPfmBankBranchId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(BankBranchDtoInterface dto) throws MospException {
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmBankBranchId());
    }

    public int importCsv(InputStream requestedFile) throws MospException {
        List dataList = OrangeSignalUtility.parse((InputStream)requestedFile, (OrangeSignalParams)new OrangeSignalParams());
        for (String[] data : dataList) {
            int idx = 0;
            PfmBankBranchDto dto = new PfmBankBranchDto();
            dto.setBankCode(data[idx++].trim());
            dto.setBranchCode(data[idx++].trim());
            dto.setBranchKana(data[idx++].trim());
            dto.setBranchName(data[idx++].trim());
            dto.setBranchAddressKana(data[idx++].trim());
            dto.setBranchAddressName(data[idx++].trim());
            dto.setBranchPhone(data[idx++].trim());
            dto.setInactivateFlag(this.getInactivateFlag(data[idx++].trim()));
            dto.setDeleteFlag(0);
            this.insert((BankBranchDtoInterface)dto);
        }
        return dataList.size();
    }

    protected int getInactivateFlag(String data) {
        return Integer.parseInt(data.trim()) == 1 ? 0 : 1;
    }

    protected void checkInsert(BankBranchDtoInterface dto) throws MospException {
    }

    protected void checkUpdate(BankBranchDtoInterface dto) throws MospException {
    }

    protected void checkDelete(BankBranchDtoInterface dto) throws MospException {
    }

    protected void validate(BankBranchDtoInterface dto) {
    }
}

