/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.PlatformMasterBeanInterface;
import jp.mosp.platform.dao.human.HumanDaoInterface;
import jp.mosp.platform.dao.workflow.RouteApplicationDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.workflow.RouteApplicationDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PlatformUtility;

public class PlatformMasterBean
extends PlatformBean
implements PlatformMasterBeanInterface {
    protected RouteApplicationDaoInterface routeApplicationDao;
    protected HumanDaoInterface humanDao;
    protected Map<Date, Set<RouteApplicationDtoInterface>> applicationPersonMap;
    protected Map<Date, Set<RouteApplicationDtoInterface>> applicationMasterMap;
    protected Map<String, List<HumanDtoInterface>> humanMap;

    public PlatformMasterBean() {
    }

    public PlatformMasterBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.routeApplicationDao = (RouteApplicationDaoInterface)this.createDao(RouteApplicationDaoInterface.class);
        this.humanDao = (HumanDaoInterface)this.createDao(HumanDaoInterface.class);
        this.applicationPersonMap = new HashMap();
        this.applicationMasterMap = new HashMap();
        this.humanMap = new HashMap();
    }

    public RouteApplicationDtoInterface getRouteApplication(HumanDtoInterface humanDto, Date targetDate, int workflowType) throws MospException {
        Set personSet = this.getApplicationPersonSet(targetDate, workflowType);
        Set masterSet = this.getApplicationMasterSet(targetDate, workflowType);
        return (RouteApplicationDtoInterface)PlatformUtility.getApplicationMaster((HumanDtoInterface)humanDto, (Set)personSet, (Set)masterSet);
    }

    public RouteApplicationDtoInterface getRouteApplication(String personalId, Date targetDate, int workflowType) throws MospException {
        HumanDtoInterface humanDto = this.getHuman(personalId, targetDate);
        return this.getRouteApplication(humanDto, targetDate, workflowType);
    }

    protected Set<RouteApplicationDtoInterface> getApplicationPersonSet(Date targetDate, int workflowType) throws MospException {
        if (this.applicationPersonMap.get(targetDate) == null) {
            this.addApplicationSet(targetDate);
        }
        Set set = (Set)this.applicationPersonMap.get(targetDate);
        return this.getApplicationSet(set, workflowType);
    }

    protected Set<RouteApplicationDtoInterface> getApplicationMasterSet(Date targetDate, int workflowType) throws MospException {
        if (this.applicationMasterMap.get(targetDate) == null) {
            this.addApplicationSet(targetDate);
        }
        Set set = (Set)this.applicationMasterMap.get(targetDate);
        return this.getApplicationSet(set, workflowType);
    }

    protected void addApplicationSet(Date targetDate) throws MospException {
        HashSet<RouteApplicationDtoInterface> personSet = new HashSet<RouteApplicationDtoInterface>();
        HashSet<RouteApplicationDtoInterface> masterSet = new HashSet<RouteApplicationDtoInterface>();
        this.applicationPersonMap.put(targetDate, personSet);
        this.applicationMasterMap.put(targetDate, masterSet);
        int person = Integer.parseInt("1");
        int master = Integer.parseInt("0");
        List list = this.routeApplicationDao.findForActivateDate(targetDate);
        for (RouteApplicationDtoInterface dto : list) {
            if (dto.getRouteApplicationType() == person) {
                personSet.add(dto);
            }
            if (dto.getRouteApplicationType() != master) continue;
            masterSet.add(dto);
        }
    }

    protected Set<RouteApplicationDtoInterface> getApplicationSet(Set<RouteApplicationDtoInterface> set, int workflowType) {
        HashSet<RouteApplicationDtoInterface> applicationSet = new HashSet<RouteApplicationDtoInterface>();
        for (RouteApplicationDtoInterface dto : set) {
            if (dto.getWorkflowType() != workflowType) continue;
            applicationSet.add(dto);
        }
        return applicationSet;
    }

    public HumanDtoInterface getHuman(String personalId, Date targetDate) throws MospException {
        List list = this.getHumanHistory(personalId);
        return (HumanDtoInterface)PlatformUtility.getLatestDto((List)list, (Date)targetDate);
    }

    public HumanDtoInterface getHuman(String personalId, int targetYear, int targetMonth) throws MospException {
        Date targetDate = MonthUtility.getYearMonthTargetDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        return this.getHuman(personalId, targetDate);
    }

    public List<HumanDtoInterface> getHumanHistory(String personalId) throws MospException {
        List list = (List)this.humanMap.get(personalId);
        if (list == null) {
            list = this.humanDao.findForHistory(personalId);
            this.humanMap.put(personalId, list);
        }
        return list;
    }
}

