/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.EmploymentContractReferenceBeanInterface;
import jp.mosp.platform.bean.system.NamingReferenceBeanInterface;
import jp.mosp.platform.bean.system.PlatformMasterCheckBeanInterface;
import jp.mosp.platform.bean.system.PositionReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.system.WorkPlaceReferenceBeanInterface;
import jp.mosp.platform.dto.system.EmploymentContractDtoInterface;
import jp.mosp.platform.dto.system.NamingDtoInterface;
import jp.mosp.platform.dto.system.PositionDtoInterface;
import jp.mosp.platform.dto.system.SectionDtoInterface;
import jp.mosp.platform.dto.system.WorkPlaceDtoInterface;

public class PlatformMasterCheckBean
extends PlatformBean
implements PlatformMasterCheckBeanInterface {
    SectionReferenceBeanInterface sectionReference;
    PositionReferenceBeanInterface positionReference;
    EmploymentContractReferenceBeanInterface employmentContractReference;
    WorkPlaceReferenceBeanInterface workPlaceReference;
    NamingReferenceBeanInterface namingReference;

    public PlatformMasterCheckBean() {
    }

    public PlatformMasterCheckBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.sectionReference = (SectionReferenceBeanInterface)this.createBean(SectionReferenceBeanInterface.class);
        this.positionReference = (PositionReferenceBeanInterface)this.createBean(PositionReferenceBeanInterface.class);
        this.employmentContractReference = (EmploymentContractReferenceBeanInterface)this.createBean(EmploymentContractReferenceBeanInterface.class);
        this.workPlaceReference = (WorkPlaceReferenceBeanInterface)this.createBean(WorkPlaceReferenceBeanInterface.class);
        this.namingReference = (NamingReferenceBeanInterface)this.createBean(NamingReferenceBeanInterface.class);
    }

    public boolean isCheckEmploymentContract(String employmentContractCode, Date startDate, Date endDate, Integer row) throws MospException {
        return this.isTermEmploymentContract(employmentContractCode, startDate, endDate);
    }

    public boolean isCheckPosition(String positionCode, Date startDate, Date endDate, Integer row) throws MospException {
        return this.isTermPosition(positionCode, startDate, endDate);
    }

    public boolean isCheckSection(String sectionCode, Date startDate, Date endDate, Integer row) throws MospException {
        return this.isTermSection(sectionCode, startDate, endDate);
    }

    public boolean isCheckWorkPlace(String workPlaceCode, Date startDate, Date endDate, Integer row) throws MospException {
        return this.isTermWorkPlace(workPlaceCode, startDate, endDate);
    }

    public boolean isCheckNaming(String namingType, String namingItemCode, Date startDate, Date endDate, Integer row) throws MospException {
        return this.isTermNaming(namingType, namingItemCode, startDate, endDate);
    }

    public boolean isCheckEmploymentContract(String employmentContractCode, Date startDate, Date endDate) throws MospException {
        return this.isTermEmploymentContract(employmentContractCode, startDate, endDate);
    }

    public boolean isCheckPosition(String positionCode, Date startDate, Date endDate) throws MospException {
        return this.isTermPosition(positionCode, startDate, endDate);
    }

    public boolean isCheckSection(String sectionCode, Date startDate, Date endDate) throws MospException {
        return this.isTermSection(sectionCode, startDate, endDate);
    }

    public boolean isCheckWorkPlace(String workPlaceCode, Date startDate, Date endDate) throws MospException {
        return this.isTermWorkPlace(workPlaceCode, startDate, endDate);
    }

    public boolean isCheckNaming(String namingType, String namingItemCode, Date startDate, Date endDate) throws MospException {
        return this.isTermNaming(namingType, namingItemCode, startDate, endDate);
    }

    public boolean isTermEmploymentContract(String employmentContractCode, Date startDate, Date endDate) throws MospException {
        List employList = this.employmentContractReference.getContractHistory(employmentContractCode);
        for (EmploymentContractDtoInterface employDto : employList) {
            if (!DateUtility.isTermContain((Date)employDto.getActivateDate(), (Date)startDate, (Date)endDate) || employDto.getInactivateFlag() != 1) continue;
            this.addEmploymentContractInactiveMessage(employmentContractCode, null, employDto.getActivateDate());
            return false;
        }
        return true;
    }

    public boolean isTermPosition(String positionCode, Date startDate, Date endDate) throws MospException {
        List positionList = this.positionReference.getPositionHistory(positionCode);
        for (PositionDtoInterface positionDto : positionList) {
            if (!DateUtility.isTermContain((Date)positionDto.getActivateDate(), (Date)startDate, (Date)endDate) || positionDto.getInactivateFlag() != 1) continue;
            this.addPositionInactiveMessage(positionCode, null, positionDto.getActivateDate());
            return false;
        }
        return true;
    }

    public boolean isTermSection(String sectionCode, Date startDate, Date endDate) throws MospException {
        List sectionList = this.sectionReference.getSectionHistory(sectionCode);
        for (SectionDtoInterface sectionDto : sectionList) {
            if (!DateUtility.isTermContain((Date)sectionDto.getActivateDate(), (Date)startDate, (Date)endDate) || sectionDto.getInactivateFlag() != 1) continue;
            this.addSectionInactiveMessage(sectionCode, null, sectionDto.getActivateDate());
            return false;
        }
        return true;
    }

    public boolean isTermWorkPlace(String workPlaceCode, Date startDate, Date endDate) throws MospException {
        List workPlaceList = this.workPlaceReference.getHistory(workPlaceCode);
        for (WorkPlaceDtoInterface workPlaceDto : workPlaceList) {
            if (!DateUtility.isTermContain((Date)workPlaceDto.getActivateDate(), (Date)startDate, (Date)endDate) || workPlaceDto.getInactivateFlag() != 1) continue;
            this.addWorkPlaceInactiveMessage(workPlaceCode, null, workPlaceDto.getActivateDate());
            return false;
        }
        return true;
    }

    public boolean isTermNaming(String namingType, String namingItemCode, Date startDate, Date endDate) throws MospException {
        List namingList = this.namingReference.getNamingItemHistory(namingType, namingItemCode);
        for (NamingDtoInterface namingDto : namingList) {
            if (!DateUtility.isTermContain((Date)namingDto.getActivateDate(), (Date)startDate, (Date)endDate) || namingDto.getInactivateFlag() != 1) continue;
            this.addNamingInactiveMessage(namingType, namingItemCode, null, namingDto.getActivateDate());
            return false;
        }
        return true;
    }

    protected void addWorkPlaceInactiveMessage(String workPlaceCode, Integer row, Date inactivateDate) {
        String targetDate = DateUtility.getStringDate((Date)inactivateDate);
        String[] aryRep = new String[]{this.getRowedFieldName(this.mospParams.getName("WorkPlace"), row), workPlaceCode, targetDate};
        this.mospParams.addErrorMessage("PFW0213", aryRep);
    }

    protected void addPositionInactiveMessage(String positionCode, Integer row, Date inactivateDate) {
        String targetDate = DateUtility.getStringDate((Date)inactivateDate);
        String[] aryRep = new String[]{this.getRowedFieldName(this.getNamePosition(), row), positionCode, targetDate};
        this.mospParams.addErrorMessage("PFW0213", aryRep);
    }

    protected void addSectionInactiveMessage(String sectionCode, Integer row, Date inactivateDate) {
        String targetDate = DateUtility.getStringDate((Date)inactivateDate);
        String[] aryRep = new String[]{this.getRowedFieldName(this.getNameSection(), row), sectionCode, targetDate};
        this.mospParams.addErrorMessage("PFW0213", aryRep);
    }

    protected void addEmploymentContractInactiveMessage(String employmentContractCode, Integer row, Date inactivateDate) {
        String targetDate = DateUtility.getStringDate((Date)inactivateDate);
        String[] aryRep = new String[]{this.getRowedFieldName(this.mospParams.getName("EmploymentContract"), row), employmentContractCode, targetDate};
        this.mospParams.addErrorMessage("PFW0213", aryRep);
    }

    protected void addNamingInactiveMessage(String namingType, String namingItemCode, Integer row, Date inactivateDate) {
        String targetDate = DateUtility.getStringDate((Date)inactivateDate);
        String namingTypeItemName = this.mospParams.getProperties().getCodeItemName("NamingType", namingType);
        String[] aryRep = new String[]{this.getRowedFieldName(namingTypeItemName, row), namingItemCode, targetDate};
        this.mospParams.addErrorMessage("PFW0213", aryRep);
    }
}

