/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.RoleReferenceBeanInterface;
import jp.mosp.platform.bean.system.UserMasterSearchBeanInterface;
import jp.mosp.platform.dao.human.HumanDaoInterface;
import jp.mosp.platform.dao.system.UserMasterDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.system.AccountInfoDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;
import jp.mosp.platform.dto.system.impl.AccountInfoDto;

public class UserMasterSearchBean
extends PlatformBean
implements UserMasterSearchBeanInterface {
    private UserMasterDaoInterface userMasterDao;
    private Date activateDate;
    private String userId;
    private String employeeCode;
    private String employeeName;
    private String roleCode;
    private String inactivateFlag;

    public UserMasterSearchBean() {
    }

    public UserMasterSearchBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.userMasterDao = (UserMasterDaoInterface)this.createDao(UserMasterDaoInterface.class);
    }

    public List<AccountInfoDtoInterface> getSearchList() throws MospException {
        Map param = this.userMasterDao.getParamsMap();
        param.put("activateDate", this.activateDate);
        param.put("userId", this.userId);
        param.put("employeeCode", this.employeeCode);
        param.put("employeeName", this.employeeName);
        param.put("roleCode", this.roleCode);
        param.put("inactivateFlag", this.inactivateFlag);
        List userList = this.userMasterDao.findForSearch(param);
        ArrayList<AccountInfoDtoInterface> accountList = new ArrayList<AccountInfoDtoInterface>();
        if (userList.size() == 0) {
            return accountList;
        }
        HumanDaoInterface humanDao = (HumanDaoInterface)this.createDao(HumanDaoInterface.class);
        RoleReferenceBeanInterface roleReference = (RoleReferenceBeanInterface)this.createBean(RoleReferenceBeanInterface.class);
        String[][] roleArray = roleReference.getSelectArray(this.activateDate, false);
        for (UserMasterDtoInterface userDto : userList) {
            HumanDtoInterface humanDto = humanDao.findForInfo(userDto.getPersonalId(), this.activateDate);
            AccountInfoDto dto = new AccountInfoDto();
            dto.setActivateDate(userDto.getActivateDate());
            dto.setPersonalId(userDto.getPersonalId());
            dto.setUserId(userDto.getUserId());
            dto.setInactivateFlag(userDto.getInactivateFlag());
            dto.setPfmUserId(userDto.getPfmUserId());
            dto.setRoleCode(userDto.getRoleCode());
            dto.setRoleName(this.getCodeName(userDto.getRoleCode(), roleArray));
            dto.setEmployeeCode("");
            dto.setLastName("");
            dto.setFirstName("");
            if (humanDto != null) {
                dto.setEmployeeCode(humanDto.getEmployeeCode());
                dto.setLastName(humanDto.getLastName());
                dto.setFirstName(humanDto.getFirstName());
            }
            accountList.add((AccountInfoDtoInterface)dto);
        }
        return accountList;
    }

    public void setActivateDate(Date activateDate) {
        this.activateDate = this.getDateClone(activateDate);
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public void setInactivateFlag(String inactivateFlag) {
        this.inactivateFlag = inactivateFlag;
    }
}

