/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.SeUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.portal.PasswordCheckBeanInterface;
import jp.mosp.platform.bean.system.UserMasterReferenceBeanInterface;
import jp.mosp.platform.bean.system.UserPasswordRegistBeanInterface;
import jp.mosp.platform.dao.system.UserPasswordDaoInterface;
import jp.mosp.platform.dto.system.UserPasswordDtoInterface;
import jp.mosp.platform.dto.system.impl.PfaUserPasswordDto;
import jp.mosp.platform.utils.PlatformMessageUtility;

public class UserPasswordRegistBean
extends PlatformBean
implements UserPasswordRegistBeanInterface {
    protected static final int LEN_PASSWORD = 50;
    protected UserPasswordDaoInterface dao;
    protected UserMasterReferenceBeanInterface userRefer;

    public UserPasswordRegistBean() {
    }

    public UserPasswordRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (UserPasswordDaoInterface)this.createDao(UserPasswordDaoInterface.class);
        this.userRefer = (UserMasterReferenceBeanInterface)this.createBean(UserMasterReferenceBeanInterface.class);
    }

    public UserPasswordDtoInterface getInitDto() {
        return new PfaUserPasswordDto();
    }

    public void regist(UserPasswordDtoInterface dto) throws MospException {
        UserPasswordDtoInterface currentDto = this.dao.findForInfo(dto.getUserId());
        if (currentDto != null) {
            this.delete(currentDto);
        }
        dto.setPfaUserPasswordId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(UserPasswordDtoInterface dto) throws MospException {
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaUserPasswordId());
    }

    public void initPassword(List<String> userIdList) throws MospException {
        Date systemDate = this.getSystemDate();
        PasswordCheckBeanInterface passwordCheck = (PasswordCheckBeanInterface)this.createBean(PasswordCheckBeanInterface.class);
        for (String userId : userIdList) {
            String initialPassword = passwordCheck.getInitialPassword(userId);
            String password = SeUtility.encrypt((String)SeUtility.encrypt((String)initialPassword));
            UserPasswordDtoInterface dto = this.dao.findForInfo(userId);
            if (dto != null) {
                this.delete(dto);
            }
            dto = this.getInitDto();
            dto.setUserId(userId);
            dto.setChangeDate(systemDate);
            dto.setPassword(password);
            dto.setPfaUserPasswordId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void validate(UserPasswordDtoInterface dto, Integer row) throws MospException {
        this.checkRequired((Object)dto.getUserId(), this.getNameUserId(), row);
        this.checkRequired((Object)dto.getChangeDate(), this.getNameChangeDate(), row);
        this.checkRequired((Object)dto.getPassword(), this.getNamePassword(), row);
        this.checkLength(dto.getPassword(), 50, this.getNamePassword(), row);
        this.checkUser(dto.getUserId(), row);
    }

    protected void checkUser(String userId, Integer row) throws MospException {
        if (this.userRefer.getUserHistory(userId).size() == 0) {
            PlatformMessageUtility.addErrorSelectedUserIdNotExist((MospParams)this.mospParams, (String)userId, (Integer)row);
        }
    }

    protected String getNameUserId() {
        return this.mospParams.getName("User", new String[]{"Id"});
    }

    protected String getNameChangeDate() {
        return this.mospParams.getName("Change", new String[]{"Day"});
    }

    protected String getNamePassword() {
        return this.mospParams.getName("Password");
    }
}

