/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.workflow.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteRegistBeanInterface;
import jp.mosp.platform.dao.workflow.ApprovalRouteDaoInterface;
import jp.mosp.platform.dao.workflow.RouteApplicationDaoInterface;
import jp.mosp.platform.dto.workflow.ApprovalRouteDtoInterface;
import jp.mosp.platform.dto.workflow.RouteApplicationDtoInterface;
import jp.mosp.platform.dto.workflow.impl.PfmApprovalRouteDto;

public class ApprovalRouteRegistBean
extends PlatformBean
implements ApprovalRouteRegistBeanInterface {
    private ApprovalRouteDaoInterface dao;
    RouteApplicationDaoInterface routeAppDao;

    public ApprovalRouteRegistBean() {
    }

    public ApprovalRouteRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (ApprovalRouteDaoInterface)this.createDao(ApprovalRouteDaoInterface.class);
        this.routeAppDao = (RouteApplicationDaoInterface)this.createDao(RouteApplicationDaoInterface.class);
    }

    public ApprovalRouteDtoInterface getInitDto() {
        return new PfmApprovalRouteDto();
    }

    public void add(ApprovalRouteDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmApprovalRouteId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(ApprovalRouteDtoInterface dto) throws MospException {
        dto.setPfmApprovalRouteId(this.getRecordID(dto));
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmApprovalRouteId());
    }

    public void insert(ApprovalRouteDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmApprovalRouteId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(ApprovalRouteDtoInterface dto) throws MospException {
        dto.setPfmApprovalRouteId(this.getRecordID(dto));
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmApprovalRouteId());
        dto.setPfmApprovalRouteId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            ApprovalRouteDtoInterface dto = this.dao.findForKey(code, activateDate);
            if (dto == null) {
                dto = this.dao.findForInfo(code, activateDate);
                if (dto == null) {
                    this.addNoCodeBeforeActivateDateMessage(code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setInactivateFlag(inactivateFlag);
                this.checkAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setPfmApprovalRouteId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setInactivateFlag(inactivateFlag);
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmApprovalRouteId());
            dto.setPfmApprovalRouteId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            ApprovalRouteDtoInterface dto = (ApprovalRouteDtoInterface)this.dao.findForKey(id, false);
            this.checkExclusive((BaseDtoInterface)dto);
            list.add(dto.getRouteCode());
        }
        return list;
    }

    private void checkAdd(ApprovalRouteDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getRouteCode(), dto.getActivateDate()));
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getRouteCode());
        if (!this.needCheckTermForAdd((PlatformDtoInterface)dto, list)) {
            return;
        }
        List applicationList = this.getRouteApplicationListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getRouteCode(), applicationList);
    }

    private void validate(ApprovalRouteDtoInterface dto) {
    }

    private long getRecordID(ApprovalRouteDtoInterface dto) throws MospException {
        ApprovalRouteDtoInterface subDto = this.dao.findForKey(dto.getRouteCode(), dto.getActivateDate());
        return subDto.getPfmApprovalRouteId();
    }

    private void checkDelete(ApprovalRouteDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmApprovalRouteId());
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getPfmApprovalRouteId(), true))) {
            return;
        }
        List list = this.dao.findForHistory(dto.getRouteCode());
        if (!this.needCheckTermForDelete((PlatformDtoInterface)dto, list)) {
            return;
        }
        List routeApplicationList = this.getRouteApplicationListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getRouteCode(), routeApplicationList);
    }

    private void checkInsert(ApprovalRouteDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getRouteCode()));
    }

    private void checkUpdate(ApprovalRouteDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmApprovalRouteId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getPfmApprovalRouteId(), true))) {
            return;
        }
        List list = this.dao.findForHistory(dto.getRouteCode());
        List routeApplicationList = this.getRouteApplicationListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getRouteCode(), routeApplicationList);
    }

    protected void checkCodeIsUsed(String code, List<RouteApplicationDtoInterface> list) {
        String codeAdded = "";
        for (RouteApplicationDtoInterface dto : list) {
            if (!code.equals(dto.getRouteCode()) || !this.isDtoActivate((BaseDtoInterface)dto) || codeAdded.equals(dto.getRouteApplicationCode())) continue;
            this.addRouteCodeIsUsedMessage(code, dto);
            codeAdded = dto.getRouteApplicationCode();
        }
    }

    protected List<RouteApplicationDtoInterface> getRouteApplicationListForCheck(PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) throws MospException {
        List applicationList = this.routeAppDao.findForActivateDate(dto.getActivateDate());
        applicationList.addAll(this.routeAppDao.findForTerm(dto.getActivateDate(), this.getNextActivateDate(dto.getActivateDate(), list)));
        return applicationList;
    }

    protected void addRouteCodeIsUsedMessage(String code, RouteApplicationDtoInterface dto) {
        this.mospParams.addErrorMessage("PFW0223", new String[]{code, dto.getRouteApplicationCode()});
    }
}

