/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.workflow.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.PlatformMasterBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.platform.dto.workflow.ApprovalRouteDtoInterface;
import jp.mosp.platform.dto.workflow.RouteApplicationDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.dto.workflow.impl.PftWorkflowDto;
import jp.mosp.platform.utils.PlatformMessageUtility;

public class WorkflowRegistBean
extends PlatformBean
implements WorkflowRegistBeanInterface {
    protected WorkflowDaoInterface dao;
    protected ApprovalRouteReferenceBeanInterface routeReference;
    protected PlatformMasterBeanInterface platformMaster;
    protected WorkflowCommentReferenceBeanInterface workflowCommentRefer;
    protected WorkflowCommentRegistBeanInterface workflowCommentRegist;

    public WorkflowRegistBean() {
    }

    public WorkflowRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (WorkflowDaoInterface)this.createDao(WorkflowDaoInterface.class);
        this.routeReference = (ApprovalRouteReferenceBeanInterface)this.createBean(ApprovalRouteReferenceBeanInterface.class);
        this.platformMaster = (PlatformMasterBeanInterface)this.createBean(PlatformMasterBeanInterface.class);
        this.workflowCommentRefer = (WorkflowCommentReferenceBeanInterface)this.createBean(WorkflowCommentReferenceBeanInterface.class);
        this.workflowCommentRegist = (WorkflowCommentRegistBeanInterface)this.createBean(WorkflowCommentRegistBeanInterface.class);
    }

    public WorkflowDtoInterface getInitDto() {
        PftWorkflowDto dto = new PftWorkflowDto();
        dto.setWorkflowStatus("");
        dto.setRouteCode("");
        dto.setApproverId("");
        dto.setFunctionCode("");
        return dto;
    }

    public WorkflowDtoInterface draft(WorkflowDtoInterface dto, String personalId, Date targetDate, int workflowType) throws MospException {
        dto.setPersonalId(personalId);
        dto.setWorkflowDate(targetDate);
        this.validate(dto);
        this.checkDraft(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.setApprovalRoute(dto, personalId, targetDate, workflowType);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        if (dto.getWorkflow() > 0L) {
            return dto;
        }
        dto.setWorkflowStatus("0");
        dto.setWorkflowStage(0);
        return this.insert(dto);
    }

    public WorkflowDtoInterface withdrawn(WorkflowDtoInterface dto) throws MospException {
        this.validate(dto);
        this.checkWithdrawn(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        dto.setWorkflowStatus("5");
        return this.add(dto);
    }

    public WorkflowDtoInterface appli(WorkflowDtoInterface dto, String personalId, Date targetDate, int workflowType, String workflowComment) throws MospException {
        dto.setPersonalId(personalId);
        dto.setWorkflowDate(targetDate);
        this.validate(dto);
        this.checkAppli(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.setApprovalRoute(dto, personalId, targetDate, workflowType);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        if (this.isSelfApproval(dto)) {
            dto.setWorkflowStatus("9");
            dto.setWorkflowStage(0);
        } else {
            dto.setWorkflowStatus("1");
            dto.setWorkflowStage(1);
        }
        WorkflowDtoInterface workflowDto = null;
        workflowDto = dto.getWorkflow() == 0L ? this.insert(dto) : this.add(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        String comment = workflowComment;
        if (workflowComment == null || workflowComment.isEmpty()) {
            comment = this.isSelfApproval(dto) ? this.getDefaultApproveComment() : this.getDefaultApplyComment();
        }
        this.addWorkflowComment(workflowDto, comment);
        return workflowDto;
    }

    public WorkflowDtoInterface cancelAppli(WorkflowDtoInterface dto, String workflowComment, String ckbWithdrawn) throws MospException {
        this.validate(dto);
        this.checkCancelAppli(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        if (ckbWithdrawn.equals("1")) {
            dto.setWorkflowStatus("7");
        } else {
            dto.setWorkflowStatus("6");
        }
        if (this.isSelfApproval(dto)) {
            if (dto.getWorkflowStatus().equals("7")) {
                dto.setWorkflowStatus("5");
            } else {
                dto.setWorkflowStatus("3");
            }
        }
        WorkflowDtoInterface workflowDto = this.add(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.addWorkflowComment(workflowDto, workflowComment);
        return workflowDto;
    }

    public WorkflowDtoInterface cancelAttendanceAppli(WorkflowDtoInterface dto, String workflowComment, String ckbWithdrawn) throws MospException {
        this.validate(dto);
        this.checkCancelAppli(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        if (ckbWithdrawn.equals("1")) {
            dto.setWorkflowStatus("7");
        } else {
            dto.setWorkflowStatus("6");
        }
        if (this.isSelfApproval(dto) && dto.getWorkflowStatus().equals("6")) {
            dto.setWorkflowStatus("3");
        }
        WorkflowDtoInterface workflowDto = this.add(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.addWorkflowComment(workflowDto, workflowComment);
        return workflowDto;
    }

    public WorkflowDtoInterface approve(WorkflowDtoInterface dto, int workflowType, String workflowComment) throws MospException {
        return this.approveWorkflow(dto, workflowType, workflowComment);
    }

    protected WorkflowDtoInterface approveWorkflow(WorkflowDtoInterface dto, int workflowType, String workflowComment) throws MospException {
        this.validate(dto);
        this.checkApproval(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        int workflowStage = dto.getWorkflowStage();
        if (workflowStage == this.getWorkflowApprovalCount(dto)) {
            dto.setWorkflowStatus("9");
        } else {
            dto.setWorkflowStage(++workflowStage);
            dto.setWorkflowStatus("2");
        }
        WorkflowDtoInterface workflowDto = this.add(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        String comment = workflowComment;
        if (workflowComment == null || workflowComment.isEmpty()) {
            comment = this.getDefaultApproveComment();
        }
        this.addWorkflowComment(workflowDto, comment);
        return workflowDto;
    }

    public WorkflowDtoInterface revert(WorkflowDtoInterface dto, int workflowType, String workflowComment) throws MospException {
        this.validate(dto);
        this.checkRevert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        int workflowStage = dto.getWorkflowStage();
        dto.setWorkflowStage(--workflowStage);
        dto.setWorkflowStatus("3");
        WorkflowDtoInterface workflowDto = this.add(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        String comment = workflowComment;
        if (workflowComment == null || workflowComment.isEmpty()) {
            comment = this.getDefaultRevertComment();
        }
        this.addWorkflowComment(workflowDto, comment);
        return workflowDto;
    }

    public WorkflowDtoInterface cancelRevert(WorkflowDtoInterface dto, String workflowComment) throws MospException {
        this.validate(dto);
        this.checkCancelRevert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        int workflowStage = dto.getWorkflowStage();
        if (workflowStage == this.getWorkflowApprovalCount(dto)) {
            dto.setWorkflowStatus("9");
        } else {
            dto.setWorkflowStage(++workflowStage);
            dto.setWorkflowStatus("2");
        }
        WorkflowDtoInterface workflowDto = this.add(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        String comment = workflowComment;
        if (workflowComment == null || workflowComment.isEmpty()) {
            comment = this.getDefaultApproveComment();
        }
        this.addWorkflowComment(workflowDto, comment);
        return workflowDto;
    }

    public WorkflowDtoInterface cancel(WorkflowDtoInterface dto, int workflowType, String workflowComment) throws MospException {
        this.validate(dto);
        this.checkCancel(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        int workflowStage = dto.getWorkflowStage();
        dto.setWorkflowStage(workflowStage);
        dto.setWorkflowStatus("4");
        if (this.isSelfApproval(dto)) {
            dto.setWorkflowStatus("3");
        }
        WorkflowDtoInterface workflowDto = this.add(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        String comment = workflowComment;
        if (workflowComment == null || workflowComment.isEmpty()) {
            comment = this.getDefaultCancelComment();
        }
        this.addWorkflowComment(workflowDto, comment);
        if (!this.isSelfApproval(dto)) {
            this.revert(workflowDto, workflowType, this.getDefaultCancelComment());
            if (this.mospParams.hasErrorMessage()) {
                return null;
            }
        }
        return workflowDto;
    }

    public WorkflowDtoInterface cancelApprove(WorkflowDtoInterface dto, String workflowComment) throws MospException {
        this.validate(dto);
        this.checkCancelApproval(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        dto.setWorkflowStatus("4");
        WorkflowDtoInterface workflowDto = this.add(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        String comment = workflowComment;
        if (workflowComment == null || workflowComment.isEmpty()) {
            comment = this.getDefaultCancelComment();
        }
        this.addWorkflowComment(workflowDto, comment);
        this.revert(workflowDto, 1, this.getDefaultCancelComment());
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        return workflowDto;
    }

    public WorkflowDtoInterface cancelWithdrawnApprove(WorkflowDtoInterface dto, String workflowComment) throws MospException {
        this.validate(dto);
        this.checkCancelWithdrawnApproval(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        dto.setWorkflowStatus("4");
        WorkflowDtoInterface workflowDto = this.add(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        String comment = workflowComment;
        if (workflowComment == null || workflowComment.isEmpty()) {
            comment = this.getDefaultCancelComment();
        }
        this.addWorkflowComment(workflowDto, comment);
        this.withdrawn(workflowDto);
        if (workflowDto != null) {
            this.workflowCommentRegist.addComment(dto, this.mospParams.getUser().getPersonalId(), this.mospParams.getProperties().getMessage("PFI0001", new String[]{this.mospParams.getName("TakeDown")}));
        }
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        return workflowDto;
    }

    protected WorkflowDtoInterface insert(WorkflowDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        long workflow = this.dao.nextWorkflow();
        dto.setWorkflow(workflow);
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        dto.setPftWorkflowId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
        return dto;
    }

    protected WorkflowDtoInterface add(WorkflowDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPftWorkflowId());
        dto.setPftWorkflowId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
        return dto;
    }

    protected void validate(WorkflowDtoInterface dto) {
        if (dto.getFunctionCode() == null || dto.getFunctionCode().isEmpty()) {
            this.addInputDataInvalidErrorMessage();
        }
    }

    protected void checkInsert(WorkflowDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getWorkflow()));
    }

    protected void checkAdd(WorkflowDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPftWorkflowId());
    }

    protected void checkDraft(WorkflowDtoInterface dto) {
        if (dto.getWorkflowStatus().isEmpty()) {
            return;
        }
        if (dto.getWorkflowStatus().equals("0")) {
            return;
        }
        this.addWorkflowProcessFailedErrorMessage();
    }

    protected void checkWithdrawn(WorkflowDtoInterface dto) {
        if ("1".equals(dto.getWorkflowStatus())) {
            return;
        }
        if (dto.getWorkflowStage() == 0 && dto.getWorkflowStatus().equals("3")) {
            return;
        }
        if ("7".equals(dto.getWorkflowStatus())) {
            return;
        }
        if ("4".equals(dto.getWorkflowStatus())) {
            return;
        }
        this.addWorkflowProcessFailedErrorMessage();
    }

    protected void checkAppli(WorkflowDtoInterface dto) {
        if (dto.getWorkflowStatus().isEmpty()) {
            return;
        }
        if (dto.getWorkflowStatus().equals("0")) {
            return;
        }
        if (dto.getWorkflowStage() == 0 && dto.getWorkflowStatus().equals("3")) {
            return;
        }
        this.addWorkflowProcessFailedErrorMessage();
    }

    protected void checkApproval(WorkflowDtoInterface dto) {
        if (dto.getWorkflowStage() == 0) {
            this.addWorkflowProcessFailedErrorMessage();
            return;
        }
        if (dto.getWorkflowStatus().equals("1")) {
            return;
        }
        if (dto.getWorkflowStatus().equals("2")) {
            return;
        }
        if (dto.getWorkflowStatus().equals("3")) {
            return;
        }
        if (dto.getWorkflowStatus().equals("4")) {
            return;
        }
        this.addWorkflowProcessFailedErrorMessage();
    }

    protected void checkCancelApproval(WorkflowDtoInterface dto) {
        if (dto.getWorkflowStatus().equals("6")) {
            return;
        }
        this.addWorkflowProcessFailedErrorMessage();
    }

    protected void checkCancelWithdrawnApproval(WorkflowDtoInterface dto) {
        if (dto.getWorkflowStatus().equals("7")) {
            return;
        }
        this.addWorkflowProcessFailedErrorMessage();
    }

    protected void checkRevert(WorkflowDtoInterface dto) {
        if (dto.getWorkflowStage() == 0) {
            this.addWorkflowProcessFailedErrorMessage();
            return;
        }
        if (dto.getWorkflowStatus().equals("1")) {
            return;
        }
        if (dto.getWorkflowStatus().equals("2")) {
            return;
        }
        if (dto.getWorkflowStatus().equals("4")) {
            return;
        }
        if (dto.getWorkflowStatus().equals("3")) {
            return;
        }
        this.addWorkflowProcessFailedErrorMessage();
    }

    protected void checkCancelRevert(WorkflowDtoInterface dto) {
        if (dto.getWorkflowStatus().equals("6") || dto.getWorkflowStatus().equals("7")) {
            return;
        }
        this.addWorkflowProcessFailedErrorMessage();
    }

    protected void checkCancel(WorkflowDtoInterface dto) throws MospException {
        if (dto.getWorkflowStatus().equals("9")) {
            return;
        }
        this.addWorkflowProcessFailedErrorMessage();
    }

    protected void checkCancelAppli(WorkflowDtoInterface dto) throws MospException {
        if (dto.getWorkflowStatus().equals("9")) {
            return;
        }
        this.addWorkflowProcessFailedErrorMessage();
    }

    public void setDtoApproverIds(WorkflowDtoInterface dto, String[] aryApproverId) {
        if (this.mospParams.isTargetApprovalUnit()) {
            dto.setApproverId("");
            return;
        }
        if (aryApproverId == null) {
            dto.setApproverId("");
            return;
        }
        dto.setApproverId(MospUtility.toSeparatedString((String[])aryApproverId, (String)","));
        dto.setRouteCode("");
    }

    public void setSelfApproval(WorkflowDtoInterface dto) {
        dto.setApproverId("SELF_APPRO");
        dto.setRouteCode("");
    }

    protected int getWorkflowApprovalCount(WorkflowDtoInterface dto) throws MospException {
        if (!dto.getApproverId().isEmpty()) {
            String[] approvers = this.split(dto.getApproverId(), ",");
            return approvers.length;
        }
        ApprovalRouteDtoInterface route = this.routeReference.getApprovalRouteInfo(dto.getRouteCode(), dto.getWorkflowDate());
        if (route == null) {
            return 0;
        }
        return route.getApprovalCount();
    }

    protected boolean isSelfApproval(WorkflowDtoInterface dto) {
        if (dto.getApproverId().equals("SELF_APPRO")) {
            return true;
        }
        return dto.getRouteCode().equals("SELF_APPRO");
    }

    protected void setApprovalRoute(WorkflowDtoInterface dto, String personalId, Date targetDate, int workflowType) throws MospException {
        if (!dto.getApproverId().isEmpty()) {
            return;
        }
        RouteApplicationDtoInterface routeApp = this.platformMaster.getRouteApplication(personalId, targetDate, workflowType);
        if (routeApp == null) {
            this.addNoApprovalRouteErrorMessage();
            return;
        }
        dto.setRouteCode(routeApp.getRouteCode());
    }

    public void delete(WorkflowDtoInterface dto) throws MospException {
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPftWorkflowId());
    }

    public void delete(long workflow) throws MospException {
        WorkflowDtoInterface workflowDto = this.dao.findForKey(workflow);
        List commentList = this.workflowCommentRefer.getWorkflowCommentList(workflow);
        if (workflowDto != null) {
            this.delete(workflowDto);
        }
        this.workflowCommentRegist.deleteList(commentList);
    }

    protected void addWorkflowComment(WorkflowDtoInterface dto, String workflowComment) throws MospException {
        this.workflowCommentRegist.addComment(dto, this.mospParams.getUser().getPersonalId(), workflowComment);
    }

    protected String getDefaultApplyComment() {
        return this.mospParams.getMessage("PFI0001", new String[]{this.mospParams.getName("Application")});
    }

    protected String getDefaultApproveComment() {
        return this.mospParams.getMessage("PFI0001", new String[]{this.mospParams.getName("Approval")});
    }

    protected String getDefaultRevertComment() {
        return this.mospParams.getMessage("PFI0001", new String[]{this.mospParams.getName("SendingBack")});
    }

    protected String getDefaultCancelComment() {
        return this.mospParams.getMessage("PFI0001", new String[]{this.mospParams.getName("Approval", new String[]{"Release"})});
    }

    protected void addNoApprovalRouteErrorMessage() {
        String message = this.mospParams.getName("Approval", new String[]{"Route"});
        this.mospParams.addErrorMessage("PFW0201", new String[]{message});
    }

    protected void addWorkflowProcessFailedErrorMessage() {
        PlatformMessageUtility.addErrorWorkflowProcessFailed((MospParams)this.mospParams);
    }
}

