/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.comparator.human;

import java.util.Comparator;
import java.util.Map;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.system.PositionDtoInterface;

public class HumanPositionGradeComparator
implements Comparator<HumanDtoInterface> {
    protected Map<String, PositionDtoInterface> positionMap;
    protected boolean hasLowGradeAdvantage;

    public HumanPositionGradeComparator(Map<String, PositionDtoInterface> positionMap, boolean hasLowGradeAdvantage) {
        this.positionMap = positionMap;
    }

    @Override
    public int compare(HumanDtoInterface dto1, HumanDtoInterface dto2) {
        int grade1 = 0;
        int grade2 = 0;
        PositionDtoInterface position1 = (PositionDtoInterface)this.positionMap.get(dto1.getPositionCode());
        PositionDtoInterface position2 = (PositionDtoInterface)this.positionMap.get(dto2.getPositionCode());
        if (position1 != null) {
            grade1 = position1.getPositionGrade();
        }
        if (position2 != null) {
            grade2 = position2.getPositionGrade();
        }
        if (this.hasLowGradeAdvantage) {
            return grade1 - grade2;
        }
        return grade2 - grade1;
    }
}

