/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.dao.human.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.platform.dao.human.RetirementDaoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;
import jp.mosp.platform.dto.human.impl.PfaHumanRetirementDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class PfaHumanRetirementDao
extends PlatformDao
implements RetirementDaoInterface {
    public static final String TABLE = "pfa_human_retirement";
    public static final String COL_PFA_HUMAN_RETIREMENT_ID = "pfa_human_retirement_id";
    public static final String COL_PERSONAL_ID = "personal_id";
    public static final String COL_RETIREMENT_DATE = "retirement_date";
    public static final String COL_RETIREMENT_REASON = "retirement_reason";
    public static final String COL_RETIREMENT_DETAIL = "retirement_detail";
    public static final String KEY_1 = "pfa_human_retirement_id";

    public void initDao() throws MospException {
    }

    public BaseDto mapping() throws MospException {
        PfaHumanRetirementDto dto = new PfaHumanRetirementDto();
        dto.setPfaHumanRetirementId(this.getLong("pfa_human_retirement_id"));
        dto.setPersonalId(this.getString("personal_id"));
        dto.setRetirementDate(this.getDate("retirement_date"));
        dto.setRetirementReason(this.getString("retirement_reason"));
        dto.setRetirementDetail(this.getString("retirement_detail"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<RetirementDtoInterface> mappingAll() throws MospException {
        ArrayList<RetirementDtoInterface> all = new ArrayList<RetirementDtoInterface>();
        while (this.next()) {
            all.add(this.castDto((BaseDtoInterface)this.mapping()));
        }
        return all;
    }

    public RetirementDtoInterface findForInfo(String personalId, Date retirementDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfaHumanRetirementDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfaHumanRetirementDao.and());
            sb.append(PfaHumanRetirementDao.equal((String)"personal_id"));
            sb.append(PfaHumanRetirementDao.and());
            sb.append(PfaHumanRetirementDao.lessEqual((String)"retirement_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, retirementDate);
            this.executeQuery();
            RetirementDtoInterface dto = null;
            if (this.rs.next()) {
                dto = this.castDto((BaseDtoInterface)this.mapping());
            }
            RetirementDtoInterface retirementDtoInterface = dto;
            return retirementDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public RetirementDtoInterface findForInfo(String personalId) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfaHumanRetirementDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfaHumanRetirementDao.and());
            sb.append(PfaHumanRetirementDao.equal((String)"personal_id"));
            sb.append(PfaHumanRetirementDao.getOrderByColumnDescLimit1((String)"retirement_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.executeQuery();
            RetirementDtoInterface dto = null;
            if (this.rs.next()) {
                dto = this.castDto((BaseDtoInterface)this.mapping());
            }
            RetirementDtoInterface retirementDtoInterface = dto;
            return retirementDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            RetirementDtoInterface dto = this.castDto(baseDto);
            this.setParam(this.index++, dto.getPfaHumanRetirementId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            RetirementDtoInterface dto = this.castDto(baseDto);
            this.setParam(this.index++, dto.getPfaHumanRetirementId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        RetirementDtoInterface dto = this.castDto(baseDto);
        this.setParam(this.index++, dto.getPfaHumanRetirementId());
        this.setParam(this.index++, dto.getPersonalId());
        this.setParam(this.index++, dto.getRetirementDate());
        this.setParam(this.index++, dto.getRetirementReason());
        this.setParam(this.index++, dto.getRetirementDetail());
        this.setCommonParams(baseDto, isInsert);
    }

    public Set<String> findForRetiredPersonalIdSet(Date targetDate, Date startDate, Date endDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = new StringBuffer();
            sb.append(PfaHumanRetirementDao.select());
            sb.append("personal_id");
            sb.append(PfaHumanRetirementDao.from((String)"pfa_human_retirement"));
            sb.append(PfaHumanRetirementDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfaHumanRetirementDao.and());
            sb.append(PfaHumanRetirementDao.less((String)"retirement_date"));
            this.prepareStatement(sb.toString());
            if (startDate != null && endDate != null) {
                this.setParam(this.index++, startDate);
            } else {
                this.setParam(this.index++, targetDate);
            }
            this.executeQuery();
            Set set = this.getResultAsSet("personal_id");
            return set;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public Map<String, RetirementDtoInterface> findForPersonalIds(String[] personalIds) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfaHumanRetirementDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfaHumanRetirementDao.in((String)"personal_id", (int)personalIds.length));
            this.prepareStatement(sb.toString());
            this.setParamsIn(personalIds);
            this.executeQuery();
            HashMap<String, RetirementDtoInterface> allmap = new HashMap<String, RetirementDtoInterface>();
            while (this.next()) {
                RetirementDtoInterface dto = this.castDto((BaseDtoInterface)this.mapping());
                allmap.put(dto.getPersonalId(), dto);
            }
            HashMap<String, RetirementDtoInterface> hashMap = allmap;
            return hashMap;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    protected RetirementDtoInterface castDto(BaseDtoInterface baseDto) {
        return (RetirementDtoInterface)baseDto;
    }
}

