/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.dao.human.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.platform.dao.human.SuspensionDaoInterface;
import jp.mosp.platform.dto.human.SuspensionDtoInterface;
import jp.mosp.platform.dto.human.impl.PfaHumanSuspensionDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class PfaHumanSuspensionDao
extends PlatformDao
implements SuspensionDaoInterface {
    public static final String TABLE = "pfa_human_suspension";
    public static final String COL_PFA_HUMAN_SUSPENSION_ID = "pfa_human_suspension_id";
    public static final String COL_PERSONAL_ID = "personal_id";
    public static final String COL_START_DATE = "start_date";
    public static final String COL_END_DATE = "end_date";
    public static final String COL_SCHEDULE_END_DATE = "schedule_end_date";
    public static final String COL_ALLOWANCE_TYPE = "allowance_type";
    public static final String COL_SUSPENSION_REASON = "suspension_reason";
    public static final String KEY_1 = "pfa_human_suspension_id";

    public void initDao() {
    }

    public BaseDto mapping() throws MospException {
        PfaHumanSuspensionDto dto = new PfaHumanSuspensionDto();
        dto.setPfaHumanSuspensionId(this.getLong("pfa_human_suspension_id"));
        dto.setPersonalId(this.getString("personal_id"));
        dto.setStartDate(this.getDate("start_date"));
        dto.setEndDate(this.getDate("end_date"));
        dto.setScheduleEndDate(this.getDate("schedule_end_date"));
        dto.setAllowanceType(this.getString("allowance_type"));
        dto.setSuspensionReason(this.getString("suspension_reason"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<SuspensionDtoInterface> mappingAll() throws MospException {
        ArrayList<SuspensionDtoInterface> all = new ArrayList<SuspensionDtoInterface>();
        while (this.next()) {
            all.add(this.castDto((BaseDtoInterface)this.mapping()));
        }
        return all;
    }

    public List<SuspensionDtoInterface> findForHistory(String personalId) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfaHumanSuspensionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfaHumanSuspensionDao.and());
            sb.append(PfaHumanSuspensionDao.equal((String)"personal_id"));
            sb.append(PfaHumanSuspensionDao.getOrderByColumn((String)"start_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public SuspensionDtoInterface findForInfo(String personalId, Date suspensionDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfaHumanSuspensionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfaHumanSuspensionDao.and());
            sb.append(PfaHumanSuspensionDao.equal((String)"personal_id"));
            sb.append(PfaHumanSuspensionDao.and());
            sb.append("start_date");
            sb.append(" <= ?");
            sb.append(PfaHumanSuspensionDao.and());
            sb.append("((");
            sb.append("end_date");
            sb.append(" IS NULL");
            sb.append(PfaHumanSuspensionDao.and());
            sb.append("schedule_end_date");
            sb.append(" >= ?) OR (");
            sb.append("end_date");
            sb.append(" >= ?))");
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, suspensionDate);
            this.setParam(this.index++, suspensionDate);
            this.setParam(this.index++, suspensionDate);
            this.executeQuery();
            SuspensionDtoInterface dto = null;
            if (this.rs.next()) {
                dto = this.castDto((BaseDtoInterface)this.mapping());
            }
            SuspensionDtoInterface suspensionDtoInterface = dto;
            return suspensionDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            SuspensionDtoInterface dto = this.castDto(baseDto);
            this.setParam(this.index++, dto.getPfaHumanSuspensionId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            SuspensionDtoInterface dto = this.castDto(baseDto);
            this.setParam(this.index++, dto.getPfaHumanSuspensionId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        SuspensionDtoInterface dto = this.castDto(baseDto);
        this.setParam(this.index++, dto.getPfaHumanSuspensionId());
        this.setParam(this.index++, dto.getPersonalId());
        this.setParam(this.index++, dto.getStartDate());
        this.setParam(this.index++, dto.getEndDate());
        this.setParam(this.index++, dto.getScheduleEndDate());
        this.setParam(this.index++, dto.getAllowanceType());
        this.setParam(this.index++, dto.getSuspensionReason());
        this.setCommonParams(baseDto, isInsert);
    }

    protected SuspensionDtoInterface castDto(BaseDtoInterface baseDto) {
        return (SuspensionDtoInterface)baseDto;
    }

    public List<SuspensionDtoInterface> findForList(Date targetDate, Date startDate, Date endDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfaHumanSuspensionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfaHumanSuspensionDao.and());
            sb.append(PfaHumanSuspensionDao.lessEqual((String)"start_date"));
            sb.append(PfaHumanSuspensionDao.and());
            sb.append(PfaHumanSuspensionDao.leftParenthesis());
            sb.append(PfaHumanSuspensionDao.leftParenthesis());
            sb.append(PfaHumanSuspensionDao.isNull((String)"end_date"));
            sb.append(PfaHumanSuspensionDao.and());
            sb.append(PfaHumanSuspensionDao.greaterEqual((String)"schedule_end_date"));
            sb.append(PfaHumanSuspensionDao.rightParenthesis());
            sb.append(PfaHumanSuspensionDao.or());
            sb.append(PfaHumanSuspensionDao.leftParenthesis());
            sb.append(PfaHumanSuspensionDao.isNotNull((String)"end_date"));
            sb.append(PfaHumanSuspensionDao.and());
            sb.append(PfaHumanSuspensionDao.greaterEqual((String)"end_date"));
            sb.append(PfaHumanSuspensionDao.rightParenthesis());
            sb.append(PfaHumanSuspensionDao.rightParenthesis());
            sb.append(PfaHumanSuspensionDao.getOrderByColumn((String)"personal_id", (String)"start_date"));
            this.prepareStatement(sb.toString());
            if (startDate != null && endDate != null) {
                this.setParam(this.index++, endDate);
                this.setParam(this.index++, startDate);
                this.setParam(this.index++, startDate);
            } else {
                this.setParam(this.index++, targetDate);
                this.setParam(this.index++, targetDate);
                this.setParam(this.index++, targetDate);
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public Map<String, SuspensionDtoInterface> findForPersonalIds(String[] personalIds) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfaHumanSuspensionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfaHumanSuspensionDao.in((String)"personal_id", (int)personalIds.length));
            this.prepareStatement(sb.toString());
            this.setParamsIn(personalIds);
            this.executeQuery();
            HashMap<String, SuspensionDtoInterface> allmap = new HashMap<String, SuspensionDtoInterface>();
            while (this.next()) {
                SuspensionDtoInterface dto = this.castDto((BaseDtoInterface)this.mapping());
                allmap.put(dto.getPersonalId(), dto);
            }
            HashMap<String, SuspensionDtoInterface> hashMap = allmap;
            return hashMap;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }
}

