/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.dao.system.impl;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.platform.dao.system.SectionDaoInterface;
import jp.mosp.platform.dto.system.SectionDtoInterface;
import jp.mosp.platform.dto.system.impl.PfmSectionDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class PfmSectionDao
extends PlatformDao
implements SectionDaoInterface {
    public static final String TABLE = "pfm_section";
    public static final String COL_PFM_SECTION_ID = "pfm_section_id";
    public static final String COL_SECTION_CODE = "section_code";
    public static final String COL_ACTIVATE_DATE = "activate_date";
    public static final String COL_SECTION_NAME = "section_name";
    public static final String COL_SECTION_ABBR = "section_abbr";
    public static final String COL_SECTION_DISPLAY = "section_display";
    public static final String COL_CLASS_ROUTE = "class_route";
    public static final String COL_CLOSE_FLAG = "close_flag";
    public static final String KEY_1 = "pfm_section_id";
    protected static final String TMP_TALBE_LOWERE_SECTION_RANGE = "tmp_pfm_section_range";

    public void initDao() {
    }

    public BaseDto mapping() throws MospException {
        PfmSectionDto dto = new PfmSectionDto();
        dto.setPfmSectionId(this.getLong("pfm_section_id"));
        dto.setSectionCode(this.getString("section_code"));
        dto.setActivateDate(this.getDate("activate_date"));
        dto.setSectionName(this.getString("section_name"));
        dto.setSectionAbbr(this.getString("section_abbr"));
        dto.setSectionDisplay(this.getString("section_display"));
        dto.setClassRoute(this.getString("class_route"));
        dto.setCloseFlag(this.getInt("close_flag"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<SectionDtoInterface> mappingAll() throws MospException {
        ArrayList<SectionDtoInterface> all = new ArrayList<SectionDtoInterface>();
        while (this.next()) {
            all.add(this.castDto((BaseDtoInterface)this.mapping()));
        }
        return all;
    }

    public SectionDtoInterface findForKey(String sectionCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmSectionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmSectionDao.and());
            sb.append(PfmSectionDao.equal((String)"section_code"));
            sb.append(PfmSectionDao.and());
            sb.append(PfmSectionDao.equal((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, sectionCode);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            SectionDtoInterface dto = null;
            if (this.next()) {
                dto = this.castDto((BaseDtoInterface)this.mapping());
            }
            SectionDtoInterface sectionDtoInterface = dto;
            return sectionDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SectionDtoInterface> findForActivateDate(Date activateDate, String[] rangeArray) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(this.getQueryForMaxActivateDate("pfm_section", "section_code", "activate_date"));
            sb.append(PfmSectionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmSectionDao.and());
            sb.append(PfmSectionDao.deleteFlagOff((String)"close_flag"));
            sb.append(this.getQueryForRange(rangeArray, "section_code"));
            sb.append(PfmSectionDao.getOrderByColumn((String)PfmSectionDao.concat((String)"class_route", (String)"section_code")));
            this.prepareStatement(sb.toString());
            this.index = this.setParamsForMaxActivateDate(this.index, activateDate, this.ps);
            this.index = this.setParamsForRange(this.index, rangeArray, activateDate, this.ps);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SectionDtoInterface> findForHistory(String sectionCode) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmSectionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmSectionDao.and());
            sb.append(PfmSectionDao.equal((String)"section_code"));
            sb.append(PfmSectionDao.getOrderByColumn((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, sectionCode);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public SectionDtoInterface findForInfo(String sectionCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmSectionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmSectionDao.and());
            sb.append(PfmSectionDao.equal((String)"section_code"));
            sb.append(PfmSectionDao.and());
            sb.append(PfmSectionDao.lessEqual((String)"activate_date"));
            sb.append(PfmSectionDao.getOrderByColumnDescLimit1((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, sectionCode);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            SectionDtoInterface dto = null;
            if (this.rs.next()) {
                dto = this.castDto((BaseDtoInterface)this.mapping());
            }
            SectionDtoInterface sectionDtoInterface = dto;
            return sectionDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SectionDtoInterface> findForTerm(Date fromActivateDate, Date toActivateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmSectionDao.where());
            sb.append(this.deleteFlagOff());
            if (fromActivateDate != null) {
                sb.append(PfmSectionDao.and());
                sb.append(PfmSectionDao.greater((String)"activate_date"));
            }
            if (toActivateDate != null) {
                sb.append(PfmSectionDao.and());
                sb.append(PfmSectionDao.less((String)"activate_date"));
            }
            sb.append(PfmSectionDao.getOrderByColumn((String)"section_code", (String)"activate_date"));
            this.prepareStatement(sb.toString());
            if (fromActivateDate != null) {
                this.setParam(this.index++, fromActivateDate);
            }
            if (toActivateDate != null) {
                this.setParam(this.index++, toActivateDate);
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SectionDtoInterface> findForCodeRange(String sectionCodeFrom, String sectionCodeTo, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(this.getQueryForMaxActivateDate("pfm_section", "section_code", "activate_date"));
            sb.append(PfmSectionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmSectionDao.and());
            sb.append(PfmSectionDao.deleteFlagOff((String)"close_flag"));
            if (sectionCodeTo != null && !sectionCodeTo.isEmpty()) {
                sb.append(PfmSectionDao.and());
                sb.append(PfmSectionDao.lessEqual((String)"section_code"));
            }
            if (sectionCodeFrom != null && !sectionCodeFrom.isEmpty()) {
                sb.append(PfmSectionDao.and());
                sb.append(PfmSectionDao.greaterEqual((String)"section_code"));
            }
            sb.append(PfmSectionDao.getOrderByColumn((String)"section_code"));
            this.prepareStatement(sb.toString());
            this.index = this.setParamsForMaxActivateDate(this.index, activateDate, this.ps);
            if (sectionCodeTo != null && !sectionCodeTo.isEmpty()) {
                this.setParam(this.index++, sectionCodeTo);
            }
            if (sectionCodeFrom != null && !sectionCodeFrom.isEmpty()) {
                this.setParam(this.index++, sectionCodeFrom);
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SectionDtoInterface> findForSearch(Map<String, Object> param) throws MospException {
        try {
            Date targetDate = (Date)param.get("targetDate");
            String sectionType = String.valueOf(param.get("sectionType"));
            String sectionCode = String.valueOf(param.get("sectionCode"));
            String sectionName = String.valueOf(param.get("sectionName"));
            String sectionAbbr = String.valueOf(param.get("sectionAbbr"));
            String closeFlag = String.valueOf(param.get("closeFlag"));
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(this.getQueryForMaxActivateDate("pfm_section", "section_code", "activate_date"));
            sb.append(PfmSectionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmSectionDao.and());
            sb.append(PfmSectionDao.leftParenthesis());
            sb.append(PfmSectionDao.like((String)"section_code"));
            sb.append(PfmSectionDao.and());
            sb.append(PfmSectionDao.like((String)"section_name"));
            sb.append(PfmSectionDao.and());
            sb.append(PfmSectionDao.like((String)"section_abbr"));
            if (sectionType.equals("route")) {
                sb.append(PfmSectionDao.or());
                sb.append(PfmSectionDao.leftParenthesis());
                sb.append(PfmSectionDao.exists());
                sb.append(PfmSectionDao.leftParenthesis());
                sb.append(this.getSelectQuery(this.getClass()));
                sb.append(PfmSectionDao.asTmpTable((String)"pfm_section"));
                sb.append(PfmSectionDao.where());
                sb.append(PfmSectionDao.like((String)PfmSectionDao.getTmpTableColumn((String)"pfm_section", (String)"section_code")));
                sb.append(PfmSectionDao.and());
                sb.append(PfmSectionDao.like((String)PfmSectionDao.getTmpTableColumn((String)"pfm_section", (String)"section_name")));
                sb.append(PfmSectionDao.and());
                sb.append(PfmSectionDao.like((String)PfmSectionDao.getTmpTableColumn((String)"pfm_section", (String)"section_abbr")));
                sb.append(PfmSectionDao.and());
                sb.append(PfmSectionDao.getExplicitTableColumn((String)"pfm_section", (String)"class_route"));
                sb.append(PfmSectionDao.like());
                sb.append(PfmSectionDao.concat((String)"'%,'", (String)PfmSectionDao.getTmpTableColumn((String)"pfm_section", (String)"section_code"), (String)"',%'"));
                sb.append(PfmSectionDao.rightParenthesis());
                sb.append(PfmSectionDao.rightParenthesis());
            }
            sb.append(PfmSectionDao.rightParenthesis());
            if (!closeFlag.isEmpty()) {
                sb.append(PfmSectionDao.and());
                sb.append(PfmSectionDao.equal((String)"close_flag"));
            }
            sb.append(PfmSectionDao.getOrderByColumn((String)"section_code"));
            this.prepareStatement(sb.toString());
            this.index = this.setParamsForMaxActivateDate(this.index, targetDate, this.ps);
            this.setParam(this.index++, PfmSectionDao.startWithParam((String)sectionCode));
            this.setParam(this.index++, PfmSectionDao.containsParam((String)sectionName));
            this.setParam(this.index++, PfmSectionDao.containsParam((String)sectionAbbr));
            if (sectionType.equals("route")) {
                this.setParam(this.index++, PfmSectionDao.startWithParam((String)sectionCode));
                this.setParam(this.index++, PfmSectionDao.containsParam((String)sectionName));
                this.setParam(this.index++, PfmSectionDao.containsParam((String)sectionAbbr));
            }
            if (!closeFlag.isEmpty()) {
                this.setParam(this.index++, Integer.parseInt(closeFlag));
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SectionDtoInterface> findForExport(Map<String, Object> param) throws MospException {
        try {
            Date targetDate = (Date)param.get("targetDate");
            String sectionCode = String.valueOf(param.get("sectionCode"));
            String closeFlag = String.valueOf(param.get("closeFlag"));
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(this.getQueryForMaxActivateDate("pfm_section", "section_code", "activate_date"));
            sb.append(PfmSectionDao.where());
            sb.append(this.deleteFlagOff());
            if (!sectionCode.isEmpty()) {
                sb.append(PfmSectionDao.and());
                sb.append(PfmSectionDao.leftParenthesis());
                sb.append(PfmSectionDao.equal((String)"section_code"));
                sb.append(PfmSectionDao.or());
                sb.append(PfmSectionDao.like((String)"class_route"));
                sb.append(PfmSectionDao.rightParenthesis());
            }
            if (!closeFlag.isEmpty()) {
                sb.append(PfmSectionDao.and());
                sb.append(PfmSectionDao.equal((String)"close_flag"));
            }
            sb.append(PfmSectionDao.getOrderByColumn((String)"section_code"));
            this.prepareStatement(sb.toString());
            this.index = this.setParamsForMaxActivateDate(this.index, targetDate, this.ps);
            if (!sectionCode.isEmpty()) {
                this.setParam(this.index++, sectionCode);
                this.setParam(this.index++, PfmSectionDao.containsParam((String)this.getClassRouteParam(sectionCode)));
            }
            if (!closeFlag.isEmpty()) {
                this.setParam(this.index++, Integer.parseInt(closeFlag));
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            SectionDtoInterface dto = this.castDto(baseDto);
            this.setParam(this.index++, dto.getPfmSectionId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            SectionDtoInterface dto = this.castDto(baseDto);
            this.setParam(this.index++, dto.getPfmSectionId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        SectionDtoInterface dto = this.castDto(baseDto);
        this.setParam(this.index++, dto.getPfmSectionId());
        this.setParam(this.index++, dto.getSectionCode());
        this.setParam(this.index++, dto.getActivateDate());
        this.setParam(this.index++, dto.getSectionName());
        this.setParam(this.index++, dto.getSectionAbbr());
        this.setParam(this.index++, dto.getSectionDisplay());
        this.setParam(this.index++, dto.getClassRoute());
        this.setParam(this.index++, dto.getCloseFlag());
        this.setCommonParams(baseDto, isInsert);
    }

    public Map<String, Object> getParamsMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        return map;
    }

    public String getQueryForSectionName() {
        StringBuffer sb = new StringBuffer();
        sb.append(PfmSectionDao.select());
        sb.append("section_code");
        sb.append(PfmSectionDao.from((String)"pfm_section"));
        sb.append(this.getQueryForMaxActivateDate("pfm_section", "section_code", "activate_date"));
        sb.append(PfmSectionDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(PfmSectionDao.and());
        sb.append(PfmSectionDao.leftParenthesis());
        sb.append(PfmSectionDao.like((String)"section_name"));
        sb.append(PfmSectionDao.or());
        sb.append(PfmSectionDao.like((String)"section_abbr"));
        sb.append(PfmSectionDao.or());
        sb.append(PfmSectionDao.like((String)"section_display"));
        sb.append(PfmSectionDao.rightParenthesis());
        return sb.toString();
    }

    public StringBuffer getQueryForLowerSection(String targetColumn) {
        StringBuffer sb = new StringBuffer();
        sb.append(targetColumn);
        sb.append(PfmSectionDao.in());
        sb.append(PfmSectionDao.leftParenthesis());
        sb.append(PfmSectionDao.select());
        sb.append("section_code");
        sb.append(PfmSectionDao.from((String)"pfm_section"));
        sb.append(this.getQueryForMaxActivateDate("pfm_section", "section_code", "activate_date"));
        sb.append(PfmSectionDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(PfmSectionDao.and());
        sb.append(PfmSectionDao.leftParenthesis());
        sb.append(PfmSectionDao.equal((String)"section_code"));
        sb.append(PfmSectionDao.or());
        sb.append(PfmSectionDao.leftParenthesis());
        sb.append(PfmSectionDao.equal((String)"close_flag", (long)0L));
        sb.append(PfmSectionDao.and());
        sb.append(PfmSectionDao.like((String)"class_route"));
        sb.append(PfmSectionDao.rightParenthesis());
        sb.append(PfmSectionDao.rightParenthesis());
        sb.append(PfmSectionDao.rightParenthesis());
        return sb;
    }

    public int setParamsForLowerSection(int index, String sectionCode, Date targetDate, PreparedStatement ps) throws MospException {
        int idx = index;
        this.setParam(idx++, targetDate, false, ps);
        this.setParam(idx++, sectionCode, ps);
        this.setParam(idx++, PfmSectionDao.containsParam((String)this.getClassRouteParam(sectionCode)), ps);
        return idx;
    }

    public String getQueryForRange(String[] rangeArray, String targetColumn) {
        StringBuffer sb = new StringBuffer();
        int rangeArrayLength = rangeArray.length;
        if (rangeArrayLength == 0) {
            return sb.toString();
        }
        sb.append(PfmSectionDao.and());
        sb.append(PfmSectionDao.leftParenthesis());
        for (int i = 0; i < rangeArrayLength; ++i) {
            sb.append(this.getQueryForLowerSection(targetColumn));
            if (i >= rangeArrayLength - 1) continue;
            sb.append(PfmSectionDao.or());
        }
        sb.append(PfmSectionDao.rightParenthesis());
        return sb.toString();
    }

    public int setParamsForRange(int index, String[] rangeArray, Date targetDate, PreparedStatement ps) throws MospException {
        int idx = index;
        for (String range : rangeArray) {
            idx = this.setParamsForLowerSection(idx, range, targetDate, ps);
        }
        return idx;
    }

    public String getClassRouteParam(String sectionCode) {
        return "," + sectionCode + ",";
    }

    protected SectionDtoInterface castDto(BaseDtoInterface baseDto) {
        return (SectionDtoInterface)baseDto;
    }

    public StringBuffer getQueryForLowerSectionRange(String targetColumn, boolean fromExist, boolean toExist) {
        StringBuffer sb = new StringBuffer();
        sb.append(targetColumn);
        sb.append(PfmSectionDao.in());
        sb.append(PfmSectionDao.leftParenthesis());
        sb.append(PfmSectionDao.select());
        sb.append("section_code");
        sb.append(PfmSectionDao.from((String)"pfm_section"));
        sb.append(this.getQueryForMaxActivateDate("pfm_section", "section_code", "activate_date"));
        sb.append(PfmSectionDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(PfmSectionDao.and());
        sb.append(PfmSectionDao.leftParenthesis());
        sb.append(PfmSectionDao.leftParenthesis());
        if (fromExist) {
            sb.append(PfmSectionDao.greaterEqual((String)"section_code"));
            if (toExist) {
                sb.append(PfmSectionDao.and());
            }
        }
        if (toExist) {
            sb.append(PfmSectionDao.lessEqual((String)"section_code"));
        }
        sb.append(PfmSectionDao.rightParenthesis());
        sb.append(PfmSectionDao.or());
        sb.append(PfmSectionDao.exists());
        sb.append(PfmSectionDao.leftParenthesis());
        sb.append(PfmSectionDao.select());
        sb.append(" * ");
        sb.append(PfmSectionDao.from((String)"pfm_section"));
        sb.append(PfmSectionDao.as((String)"tmp_pfm_section_range"));
        sb.append(this.getQueryForMaxActivateDate("pfm_section", "section_code", "activate_date"));
        sb.append(PfmSectionDao.where());
        sb.append(PfmSectionDao.deleteFlagOff((String)PfmSectionDao.getExplicitTableColumn((String)"tmp_pfm_section_range", (String)this.colDeleteFlag)));
        if (fromExist) {
            sb.append(PfmSectionDao.and());
            sb.append(PfmSectionDao.greaterEqual((String)PfmSectionDao.getExplicitTableColumn((String)"tmp_pfm_section_range", (String)"section_code")));
        }
        if (toExist) {
            sb.append(PfmSectionDao.and());
            sb.append(PfmSectionDao.lessEqual((String)PfmSectionDao.getExplicitTableColumn((String)"tmp_pfm_section_range", (String)"section_code")));
        }
        sb.append(PfmSectionDao.and());
        sb.append(PfmSectionDao.equal((String)PfmSectionDao.getExplicitTableColumn((String)"pfm_section", (String)"close_flag"), (long)0L));
        sb.append(PfmSectionDao.and());
        sb.append(PfmSectionDao.getExplicitTableColumn((String)"pfm_section", (String)"class_route"));
        sb.append(PfmSectionDao.like());
        sb.append(PfmSectionDao.concat((String)"'%,'", (String)PfmSectionDao.getExplicitTableColumn((String)"tmp_pfm_section_range", (String)"section_code"), (String)"',%'"));
        sb.append(PfmSectionDao.rightParenthesis());
        sb.append(PfmSectionDao.rightParenthesis());
        sb.append(PfmSectionDao.rightParenthesis());
        return sb;
    }

    public int setParamsForLowerSectionRange(int index, String sectionCodeFrom, String sectionCodeTo, Date targetDate, PreparedStatement ps) throws MospException {
        int idx = index;
        this.setParam(idx++, targetDate, false, ps);
        if (!sectionCodeFrom.isEmpty()) {
            this.setParam(idx++, sectionCodeFrom, ps);
        }
        if (!sectionCodeTo.isEmpty()) {
            this.setParam(idx++, sectionCodeTo, ps);
        }
        this.setParam(idx++, targetDate, false, ps);
        if (!sectionCodeFrom.isEmpty()) {
            this.setParam(idx++, sectionCodeFrom, ps);
        }
        if (!sectionCodeTo.isEmpty()) {
            this.setParam(idx++, sectionCodeTo, ps);
        }
        return idx;
    }
}

