/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.dao.workflow.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.platform.dao.system.PositionDaoInterface;
import jp.mosp.platform.dao.system.SectionDaoInterface;
import jp.mosp.platform.dao.workflow.ApprovalUnitDaoInterface;
import jp.mosp.platform.dto.workflow.ApprovalUnitDtoInterface;
import jp.mosp.platform.dto.workflow.impl.PfmApprovalUnitDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class PfmApprovalUnitDao
extends PlatformDao
implements ApprovalUnitDaoInterface {
    public static final String TABLE = "pfm_approval_unit";
    public static final String COL_PFM_APPROVAL_UNIT_ID = "pfm_approval_unit_id";
    public static final String COL_UNIT_CODE = "unit_code";
    public static final String COL_ACTIVATE_DATE = "activate_date";
    public static final String COL_UNIT_NAME = "unit_name";
    public static final String COL_UNIT_TYPE = "unit_type";
    public static final String COL_APPROVER_PERSONAL_ID = "approver_personal_id";
    public static final String COL_APPROVER_SECTION_CODE = "approver_section_code";
    public static final String COL_APPROVER_POSITION_CODE = "approver_position_code";
    public static final String COL_APPROVER_POSITION_GRADE = "approver_position_grade";
    public static final String COL_ROUTE_STAGE = "route_stage";
    public static final String COL_INACTIVATE_FLAG = "inactivate_flag";
    public static final String KEY_1 = "pfm_approval_unit_id";
    protected PositionDaoInterface positionDao;

    public void initDao() throws MospException {
        this.positionDao = (PositionDaoInterface)this.loadDao(PositionDaoInterface.class);
    }

    public List<ApprovalUnitDtoInterface> findForActivateDate(Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(this.getQueryForMaxActivateDate("pfm_approval_unit", "unit_code", "activate_date"));
            sb.append(PfmApprovalUnitDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmApprovalUnitDao.and());
            sb.append("inactivate_flag");
            sb.append(" = ");
            sb.append(0);
            sb.append(" ");
            sb.append(PfmApprovalUnitDao.getOrderByColumn((String)"unit_code"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<ApprovalUnitDtoInterface> findForHistory(String unitCode) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmApprovalUnitDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmApprovalUnitDao.and());
            sb.append(PfmApprovalUnitDao.equal((String)"unit_code"));
            sb.append(PfmApprovalUnitDao.getOrderByColumn((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, unitCode);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public ApprovalUnitDtoInterface findForInfo(String unitCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmApprovalUnitDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmApprovalUnitDao.and());
            sb.append(PfmApprovalUnitDao.equal((String)"unit_code"));
            sb.append(PfmApprovalUnitDao.and());
            sb.append(PfmApprovalUnitDao.lessEqual((String)"activate_date"));
            sb.append(PfmApprovalUnitDao.getOrderByColumnDescLimit1((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, unitCode);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            ApprovalUnitDtoInterface dto = null;
            if (this.next()) {
                dto = this.castDto((BaseDtoInterface)this.mapping());
            }
            ApprovalUnitDtoInterface approvalUnitDtoInterface = dto;
            return approvalUnitDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public ApprovalUnitDtoInterface findForKey(String unitCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmApprovalUnitDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmApprovalUnitDao.and());
            sb.append(PfmApprovalUnitDao.equal((String)"unit_code"));
            sb.append(PfmApprovalUnitDao.and());
            sb.append(PfmApprovalUnitDao.equal((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, unitCode);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            ApprovalUnitDtoInterface dto = null;
            if (this.next()) {
                dto = this.castDto((BaseDtoInterface)this.mapping());
            }
            ApprovalUnitDtoInterface approvalUnitDtoInterface = dto;
            return approvalUnitDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<ApprovalUnitDtoInterface> findForSearch(Map<String, Object> param) throws MospException {
        try {
            SectionDaoInterface sectionDao = (SectionDaoInterface)this.loadDao(SectionDaoInterface.class);
            PositionDaoInterface positionDao = (PositionDaoInterface)this.loadDao(PositionDaoInterface.class);
            Date activateDate = (Date)param.get("activateDate");
            String unitCode = String.valueOf(param.get("unitCode"));
            String unitName = String.valueOf(param.get("unitName"));
            String unitType = String.valueOf(param.get("unitType"));
            String sectionName = String.valueOf(param.get("sectionName"));
            String positionName = String.valueOf(param.get("positionName"));
            String inactivateFlag = String.valueOf(param.get("inactivateFlag"));
            Date targetDate = activateDate != null ? activateDate : DateUtility.getSystemDate();
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            if (activateDate != null) {
                sb.append(this.getQueryForMaxActivateDate("pfm_approval_unit", "unit_code", "activate_date"));
            }
            sb.append(PfmApprovalUnitDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmApprovalUnitDao.and());
            sb.append(PfmApprovalUnitDao.like((String)"unit_code"));
            sb.append(PfmApprovalUnitDao.and());
            sb.append(PfmApprovalUnitDao.like((String)"unit_name"));
            sb.append(PfmApprovalUnitDao.and());
            sb.append(PfmApprovalUnitDao.equal((String)"unit_type"));
            if (!inactivateFlag.isEmpty()) {
                sb.append(PfmApprovalUnitDao.and());
                sb.append(PfmApprovalUnitDao.equal((String)"inactivate_flag"));
            }
            if (unitType.equals("section")) {
                if (!sectionName.isEmpty()) {
                    sb.append(PfmApprovalUnitDao.and());
                    sb.append("approver_section_code");
                    sb.append(PfmApprovalUnitDao.in());
                    sb.append(PfmApprovalUnitDao.leftParenthesis());
                    sb.append(sectionDao.getQueryForSectionName());
                    sb.append(PfmApprovalUnitDao.rightParenthesis());
                }
                if (!positionName.isEmpty()) {
                    sb.append(positionDao.getQueryForPositionName("approver_position_code"));
                }
            }
            this.prepareStatement(sb.toString());
            if (activateDate != null) {
                this.index = this.setParamsForMaxActivateDate(this.index, activateDate, this.ps);
            }
            this.setParam(this.index++, PfmApprovalUnitDao.startWithParam((String)unitCode));
            this.setParam(this.index++, PfmApprovalUnitDao.containsParam((String)unitName));
            this.setParam(this.index++, unitType);
            if (!inactivateFlag.isEmpty()) {
                this.setParam(this.index++, Integer.parseInt(inactivateFlag));
            }
            if (unitType.equals("section")) {
                if (!sectionName.isEmpty()) {
                    this.setParam(this.index++, targetDate);
                    this.setParam(this.index++, PfmApprovalUnitDao.containsParam((String)sectionName));
                    this.setParam(this.index++, PfmApprovalUnitDao.containsParam((String)sectionName));
                    this.setParam(this.index++, PfmApprovalUnitDao.containsParam((String)sectionName));
                }
                if (!positionName.isEmpty()) {
                    this.index = positionDao.setParamsForPositionName(this.index, positionName, targetDate, this.ps);
                }
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public Map<String, Object> getParamsMap() {
        return new HashMap<String, Object>();
    }

    public List<ApprovalUnitDtoInterface> findForApproverPersonalId(String approverPersonalId, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(this.getQueryForMaxActivateDate("pfm_approval_unit", "unit_code", "activate_date"));
            sb.append(PfmApprovalUnitDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmApprovalUnitDao.and());
            sb.append(PfmApprovalUnitDao.equal((String)"unit_type"));
            sb.append(PfmApprovalUnitDao.and());
            sb.append(PfmApprovalUnitDao.like((String)"approver_personal_id"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, activateDate);
            this.setParam(this.index++, "person");
            this.setParam(this.index++, PfmApprovalUnitDao.containsParam((String)approverPersonalId));
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<ApprovalUnitDtoInterface> findForApproverSection(String approverSectionCode, String approverPositionCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(this.getQueryForMaxActivateDate("pfm_approval_unit", "unit_code", "activate_date"));
            sb.append(PfmApprovalUnitDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmApprovalUnitDao.and());
            sb.append(PfmApprovalUnitDao.equal((String)"unit_type"));
            sb.append(PfmApprovalUnitDao.and());
            sb.append(PfmApprovalUnitDao.equal((String)"approver_section_code"));
            sb.append(PfmApprovalUnitDao.and());
            sb.append(PfmApprovalUnitDao.leftParenthesis());
            sb.append(PfmApprovalUnitDao.equal((String)"approver_position_code"));
            sb.append(PfmApprovalUnitDao.or());
            sb.append(PfmApprovalUnitDao.leftParenthesis());
            sb.append(PfmApprovalUnitDao.equal((String)"approver_position_grade", (String)"1"));
            sb.append(PfmApprovalUnitDao.and());
            sb.append("approver_position_code");
            sb.append(PfmApprovalUnitDao.in());
            sb.append(PfmApprovalUnitDao.leftParenthesis());
            sb.append(this.positionDao.getQueryForPositionGrade(false));
            sb.append(PfmApprovalUnitDao.rightParenthesis());
            sb.append(PfmApprovalUnitDao.rightParenthesis());
            sb.append(PfmApprovalUnitDao.or());
            sb.append(PfmApprovalUnitDao.leftParenthesis());
            sb.append(PfmApprovalUnitDao.equal((String)"approver_position_grade", (String)"2"));
            sb.append(PfmApprovalUnitDao.and());
            sb.append("approver_position_code");
            sb.append(PfmApprovalUnitDao.in());
            sb.append(PfmApprovalUnitDao.leftParenthesis());
            sb.append(this.positionDao.getQueryForPositionGrade(true));
            sb.append(PfmApprovalUnitDao.rightParenthesis());
            sb.append(PfmApprovalUnitDao.rightParenthesis());
            sb.append(PfmApprovalUnitDao.rightParenthesis());
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, activateDate);
            this.setParam(this.index++, "section");
            this.setParam(this.index++, approverSectionCode);
            this.setParam(this.index++, approverPositionCode);
            this.index = this.positionDao.setParamsForPositionGrande(this.index, approverPositionCode, activateDate, this.ps);
            this.index = this.positionDao.setParamsForPositionGrande(this.index, approverPositionCode, activateDate, this.ps);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            ApprovalUnitDtoInterface dto = this.castDto(baseDto);
            this.setParam(this.index++, dto.getPfmApprovalUnitId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public BaseDto mapping() throws MospException {
        PfmApprovalUnitDto dto = new PfmApprovalUnitDto();
        dto.setPfmApprovalUnitId(this.getLong("pfm_approval_unit_id"));
        dto.setUnitCode(this.getString("unit_code"));
        dto.setActivateDate(this.getDate("activate_date"));
        dto.setUnitName(this.getString("unit_name"));
        dto.setUnitType(this.getString("unit_type"));
        dto.setApproverPersonalId(this.getString("approver_personal_id"));
        dto.setApproverSectionCode(this.getString("approver_section_code"));
        dto.setApproverPositionCode(this.getString("approver_position_code"));
        dto.setApproverPositionGrade(this.getString("approver_position_grade"));
        dto.setRouteStage(this.getInt("route_stage"));
        dto.setInactivateFlag(this.getInt("inactivate_flag"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<ApprovalUnitDtoInterface> mappingAll() throws MospException {
        ArrayList<ApprovalUnitDtoInterface> all = new ArrayList<ApprovalUnitDtoInterface>();
        while (this.next()) {
            all.add(this.castDto((BaseDtoInterface)this.mapping()));
        }
        return all;
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        ApprovalUnitDtoInterface dto = this.castDto(baseDto);
        this.setParam(this.index++, dto.getPfmApprovalUnitId());
        this.setParam(this.index++, dto.getUnitCode());
        this.setParam(this.index++, dto.getActivateDate());
        this.setParam(this.index++, dto.getUnitName());
        this.setParam(this.index++, dto.getUnitType());
        this.setParam(this.index++, dto.getApproverPersonalId());
        this.setParam(this.index++, dto.getApproverSectionCode());
        this.setParam(this.index++, dto.getApproverPositionCode());
        this.setParam(this.index++, dto.getApproverPositionGrade());
        this.setParam(this.index++, dto.getRouteStage());
        this.setParam(this.index++, dto.getInactivateFlag());
        this.setCommonParams(baseDto, isInsert);
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            ApprovalUnitDtoInterface dto = this.castDto(baseDto);
            this.setParam(this.index++, dto.getPfmApprovalUnitId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public String getQueryForUnitName() {
        StringBuffer sb = new StringBuffer();
        sb.append(PfmApprovalUnitDao.select());
        sb.append("unit_code");
        sb.append(PfmApprovalUnitDao.from((String)"pfm_approval_unit"));
        sb.append(this.getQueryForMaxActivateDate("pfm_approval_unit", "unit_code", "activate_date"));
        sb.append(PfmApprovalUnitDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(PfmApprovalUnitDao.and());
        sb.append(PfmApprovalUnitDao.like((String)"unit_name"));
        return sb.toString();
    }

    protected ApprovalUnitDtoInterface castDto(BaseDtoInterface baseDto) {
        return (ApprovalUnitDtoInterface)baseDto;
    }

    public List<ApprovalUnitDtoInterface> findPersonTerm(String personalId, Date startDate, Date endDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmApprovalUnitDao.where());
            sb.append(this.deleteFlagOff());
            if (startDate != null) {
                sb.append(PfmApprovalUnitDao.and());
                sb.append(PfmApprovalUnitDao.greaterEqual((String)"activate_date"));
            }
            if (endDate != null) {
                sb.append(PfmApprovalUnitDao.and());
                sb.append(PfmApprovalUnitDao.lessEqual((String)"activate_date"));
            }
            sb.append(PfmApprovalUnitDao.and());
            sb.append(PfmApprovalUnitDao.equal((String)"unit_type"));
            sb.append(PfmApprovalUnitDao.and());
            sb.append(PfmApprovalUnitDao.like((String)"approver_personal_id"));
            this.prepareStatement(sb.toString());
            if (startDate != null) {
                this.setParam(this.index++, startDate);
            }
            if (endDate != null) {
                this.setParam(this.index++, endDate);
            }
            this.setParam(this.index++, "person");
            this.setParam(this.index++, PfmApprovalUnitDao.containsParam((String)personalId));
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }
}

