/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.file.action;

import java.util.ArrayList;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.bean.file.ExportFieldReferenceBeanInterface;
import jp.mosp.platform.bean.file.ExportFieldRegistBeanInterface;
import jp.mosp.platform.bean.file.ExportReferenceBeanInterface;
import jp.mosp.platform.bean.file.ExportRegistBeanInterface;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.dto.file.ExportFieldDtoInterface;
import jp.mosp.platform.file.vo.ExportCardVo;
import jp.mosp.platform.system.base.PlatformSystemAction;

public class ExportCardAction
extends PlatformSystemAction {
    public static final String CMD_SHOW = "PF1420";
    public static final String CMD_SELECT_SHOW = "PF1421";
    public static final String CMD_REGIST = "PF1425";
    public static final String CMD_DELETE = "PF1427";
    public static final String CMD_SET_TABLE_TYPE = "PF1470";
    public static final String CMD_INSERT_MODE = "PF1471";
    public static final String KEY_VIEW_HUMAN_EXPORT = "HumanExport";

    protected BaseVo getSpecificVo() {
        return new ExportCardVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo();
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_SET_TABLE_TYPE)) {
            this.prepareVo();
            this.setTableType();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        }
    }

    protected void show() throws MospException {
        this.setExportCardInfo();
        this.insertMode();
    }

    protected void select() throws MospException {
        this.setExportCardInfo();
        this.editMode();
    }

    protected void regist() throws MospException {
        ExportCardVo vo = (ExportCardVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        ExportCardVo vo = (ExportCardVo)this.mospParams.getVo();
        ExportRegistBeanInterface regist = this.platform().exportRegist();
        ExportFieldRegistBeanInterface registField = this.platform().exportFieldRegist();
        String[] arySelectSelected = vo.getJsPltSelectSelected();
        ExportDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        registField.insert(vo.getTxtEditCode(), vo.getPltEditInactivate(), arySelectSelected);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertNewMessage();
        this.setEditUpdateMode(dto.getExportCode());
    }

    protected void update() throws MospException {
        ExportCardVo vo = (ExportCardVo)this.mospParams.getVo();
        ExportRegistBeanInterface regist = this.platform().exportRegist();
        ExportFieldRegistBeanInterface registField = this.platform().exportFieldRegist();
        ExportDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        String[] arySelectSelected = vo.getJsPltSelectSelected();
        regist.update(dto);
        registField.update(vo.getTxtEditCode(), vo.getPltEditInactivate(), arySelectSelected);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.setEditUpdateMode(dto.getExportCode());
    }

    protected void delete() throws MospException {
        ExportCardVo vo = (ExportCardVo)this.mospParams.getVo();
        ExportDtoInterface dto = this.reference().export().findForKey(vo.getTxtEditCode());
        this.platform().exportRegist().delete(dto);
        this.platform().exportFieldRegist().delete(vo.getTxtEditCode());
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteMessage();
        this.insertMode();
    }

    protected void setTableType() throws MospException {
        ExportCardVo vo = (ExportCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
    }

    protected void insertMode() throws MospException {
        this.setEditInsertMode();
        this.setDefaultValues();
        ExportCardVo vo = (ExportCardVo)this.mospParams.getVo();
        vo.setModeActivateDate("chaning");
        this.setPulldown();
    }

    protected void editMode() throws MospException {
        this.setEditUpdateMode(this.getTransferredCode());
    }

    protected void setEditUpdateMode(String exportCode) throws MospException {
        ExportCardVo vo = (ExportCardVo)this.mospParams.getVo();
        ExportReferenceBeanInterface reference = this.reference().export();
        ExportFieldReferenceBeanInterface fieldReference = this.reference().exportField();
        ExportDtoInterface dto = reference.findForKey(exportCode);
        List list = fieldReference.getExportFieldList(exportCode);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        this.setVoFields(list);
        vo.setModeActivateDate("fixed");
        this.setPulldown();
        this.setEditUpdateMode(new ArrayList());
    }

    public void setDefaultValues() {
        ExportCardVo vo = (ExportCardVo)this.mospParams.getVo();
        vo.setTxtEditCode("");
        vo.setTxtEditName("");
        vo.setPltEditTable("");
        vo.setPltEditHeader("");
        vo.setPltEditType("1");
        vo.setJsPltSelectSelected(new String[0]);
    }

    protected void setPulldown() throws MospException {
        ExportCardVo vo = (ExportCardVo)this.mospParams.getVo();
        vo.setJsPltSelectTable(new String[0][0]);
        vo.setLblTableName("");
        if (vo.getModeActivateDate().equals("fixed")) {
            vo.setJsPltSelectTable(this.getCodeArray(vo.getPltEditTable(), false));
            vo.setLblTableName(this.getCodeName(vo.getPltEditTable(), vo.getTableTypeCodeKey()));
        }
        vo.setAryPltTableType(this.getCodeArray(vo.getTableTypeCodeKey(), false));
        if (vo.getModeActivateDate().equals("fixed") && vo.getPltEditTable().equals("pfm_human")) {
            String[] aryDivision;
            for (String division : aryDivision = this.mospParams.getApplicationProperties("HumanGeneralDivisions")) {
                String[][] aryAddItem;
                if (this.mospParams.getUserRole().getHiddenDivisionsList().contains(division) || (aryAddItem = this.reference().humanNormal().getPulldownForHumanExportImport(division, KEY_VIEW_HUMAN_EXPORT)) == null || aryAddItem.length == 0) continue;
                vo.setJsPltSelectTable(this.addArrayString(vo.getJsPltSelectTable(), aryAddItem));
            }
        }
    }

    protected void setDtoFields(ExportDtoInterface dto) {
        ExportCardVo vo = (ExportCardVo)this.mospParams.getVo();
        dto.setPfmExportId(vo.getRecordId());
        dto.setExportTable(vo.getPltEditTable());
        dto.setExportCode(vo.getTxtEditCode());
        dto.setExportName(vo.getTxtEditName());
        dto.setType(vo.getPltEditType());
        dto.setHeader(this.getInt(vo.getPltEditHeader()));
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
    }

    protected void setVoFields(ExportDtoInterface dto) {
        ExportCardVo vo = (ExportCardVo)this.mospParams.getVo();
        vo.setRecordId(dto.getPfmExportId());
        vo.setPltEditTable(dto.getExportTable());
        vo.setTxtEditCode(dto.getExportCode());
        vo.setTxtEditName(dto.getExportName());
        vo.setPltEditType(dto.getType());
        vo.setPltEditHeader(String.valueOf(dto.getHeader()));
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
    }

    protected void setVoFields(List<ExportFieldDtoInterface> list) {
        ExportCardVo vo = (ExportCardVo)this.mospParams.getVo();
        String[] jsPltSelectSelected = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ExportFieldDtoInterface dto = list.get(i);
            jsPltSelectSelected[i] = dto.getFieldName();
        }
        vo.setJsPltSelectSelected(jsPltSelectSelected);
    }

    protected void setExportCardInfo() {
        String tableTypeCodeKey = this.getTransferredType();
        String showListCommand = this.getTransferredCommand();
        if (tableTypeCodeKey == null || tableTypeCodeKey.isEmpty()) {
            return;
        }
        ExportCardVo vo = (ExportCardVo)this.mospParams.getVo();
        vo.setTableTypeCodeKey(tableTypeCodeKey);
        vo.setShowListCommand(showListCommand);
    }
}

