/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.RoleProperty;
import jp.mosp.framework.utils.SeUtility;
import jp.mosp.platform.bean.human.EntranceRegistBeanInterface;
import jp.mosp.platform.bean.human.HumanHistoryRegistBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanRegistBeanInterface;
import jp.mosp.platform.bean.system.UserMasterReferenceBeanInterface;
import jp.mosp.platform.bean.system.UserMasterRegistBeanInterface;
import jp.mosp.platform.bean.system.UserPasswordRegistBeanInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.HumanHistoryDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;
import jp.mosp.platform.dto.system.UserPasswordDtoInterface;
import jp.mosp.platform.human.action.HumanInfoAction;
import jp.mosp.platform.human.base.PlatformHumanAction;
import jp.mosp.platform.human.vo.BasicNewCardVo;
import jp.mosp.platform.utils.PlatformNamingUtility;

public class BasicNewCardAction
extends PlatformHumanAction {
    protected static final String MGP_JS_HUMAN_INFO = "jsToHumanInfo";
    public static final String CMD_SHOW = "PF1210";
    public static final String CMD_SET_ACTIVATION_DATE = "PF1211";
    public static final String CMD_AUTO_NUMBERING = "PF1212";
    public static final String CMD_INSERT = "PF1217";
    public static final String CMD_TRANSFER = "PF1219";

    public BasicNewCardAction() {
        this.topicPathCommand = CMD_SHOW;
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_AUTO_NUMBERING)) {
            this.prepareVo();
            this.autoNumbering();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT)) {
            this.prepareVo();
            this.insert();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected BaseVo getSpecificVo() {
        return new BasicNewCardVo();
    }

    protected void show() throws MospException {
        BasicNewCardVo vo = (BasicNewCardVo)this.mospParams.getVo();
        Date date = this.getSystemDate();
        vo.setTxtActivateYear(this.getStringYear(date));
        vo.setTxtActivateMonth(this.getStringMonth(date));
        vo.setTxtActivateDay(this.getStringDay(date));
        vo.setModeActivateDate("chaning");
        vo.setNeedPost(this.mospParams.getApplicationPropertyBool("UsePost"));
        vo.setNeedNumberingButton(this.reference().employeeNumbering().isEmployeeNumberingAvailable());
        vo.setExtraJspList(new ArrayList());
        this.setPulldown();
        this.setPostPulldown();
    }

    protected void setActivationDate() throws MospException {
        BasicNewCardVo vo = (BasicNewCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
        this.setPostPulldown();
    }

    protected void autoNumbering() throws MospException {
        BasicNewCardVo vo = (BasicNewCardVo)this.mospParams.getVo();
        String employeeCode = this.reference().employeeNumbering().getNewEmployeeCode();
        vo.setTxtEmployeeCode(employeeCode);
    }

    protected void insert() throws MospException {
        BasicNewCardVo vo = (BasicNewCardVo)this.mospParams.getVo();
        HumanDtoInterface dto = this.registHuman();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.registEntrance();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.registUser();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.registPost();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.registExtra(dto.getPersonalId());
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertNewMessage();
        vo.setPersonalId(dto.getPersonalId());
        vo.setTargetDate(dto.getActivateDate());
        this.mospParams.addGeneralParam(MGP_JS_HUMAN_INFO, (Object)"");
        this.initVoFields();
        vo.setModeActivateDate("chaning");
        this.setPulldown();
        this.setPostPulldown();
    }

    protected void transfer() {
        BasicNewCardVo vo = (BasicNewCardVo)this.mospParams.getVo();
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(vo.getPersonalId());
        this.setTargetDate(vo.getTargetDate());
        if (actionName.equals(HumanInfoAction.class.getName())) {
            this.mospParams.setNextCommand("PF1121");
        }
    }

    protected void setPulldown() throws MospException {
        BasicNewCardVo vo = (BasicNewCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setAryPltSection(this.getInputActivateDatePulldown());
            vo.setAryPltPosition(this.getInputActivateDatePulldown());
            vo.setAryPltEmployment(this.getInputActivateDatePulldown());
            vo.setAryPltWorkPlaceName(this.getInputActivateDatePulldown());
            return;
        }
        Date targetDate = this.getEditActivateDate();
        vo.setAryPltSection(this.reference().section().getCodedSelectArray(targetDate, true, null));
        vo.setAryPltPosition(this.reference().position().getCodedSelectArray(targetDate, true, null));
        vo.setAryPltEmployment(this.reference().employmentContract().getCodedAbbrSelectArray(targetDate, true, null));
        vo.setAryPltWorkPlaceName(this.reference().workPlace().getCodedAbbrSelectArray(targetDate, true, null));
    }

    protected void setPostPulldown() throws MospException {
        BasicNewCardVo vo = (BasicNewCardVo)this.mospParams.getVo();
        if (!vo.getNeedPost()) {
            return;
        }
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setAryPltPostName(this.getInputActivateDatePulldown());
            return;
        }
        vo.setAryPltPostName(this.reference().naming().getCodedSelectArray("post", this.getEditActivateDate(), true));
    }

    protected void initVoFields() {
        BasicNewCardVo vo = (BasicNewCardVo)this.mospParams.getVo();
        vo.setTxtEmployeeCode("");
        vo.setTxtLastName("");
        vo.setTxtFirstName("");
        vo.setTxtLastKana("");
        vo.setTxtFirstKana("");
        vo.setPltSectionName("");
        vo.setPltPositionName("");
        vo.setPltEmploymentName("");
        vo.setPltWorkPlaceName("");
        vo.setTxtUserId("");
        vo.setTxtEntranceYear("");
        vo.setTxtEntranceMonth("");
        vo.setTxtEntranceDay("");
    }

    protected void setDtoFields(HumanDtoInterface dto) throws MospException {
        BasicNewCardVo vo = (BasicNewCardVo)this.mospParams.getVo();
        dto.setActivateDate(this.getEditActivateDate());
        dto.setEmployeeCode(vo.getTxtEmployeeCode());
        dto.setLastName(vo.getTxtLastName());
        dto.setFirstName(vo.getTxtFirstName());
        dto.setLastKana(vo.getTxtLastKana());
        dto.setFirstKana(vo.getTxtFirstKana());
        dto.setEmploymentContractCode(vo.getPltEmploymentName());
        dto.setSectionCode(vo.getPltSectionName());
        dto.setPositionCode(vo.getPltPositionName());
        dto.setWorkPlaceCode(vo.getPltWorkPlaceName());
        dto.setMail("");
    }

    protected void setDtoFields(EntranceDtoInterface dto) throws MospException {
        BasicNewCardVo vo = (BasicNewCardVo)this.mospParams.getVo();
        dto.setEntranceDate(this.getEntranceDate());
        dto.setPersonalId(this.reference().human().getPersonalId(vo.getTxtEmployeeCode(), this.getEditActivateDate()));
    }

    protected void setDtoFields(UserMasterDtoInterface dto) throws MospException {
        BasicNewCardVo vo = (BasicNewCardVo)this.mospParams.getVo();
        dto.setUserId(vo.getTxtUserId());
        dto.setActivateDate(this.getEditActivateDate());
        dto.setPersonalId(this.reference().human().getPersonalId(vo.getTxtEmployeeCode(), this.getEditActivateDate()));
        dto.setRoleCode(this.getDefaultRole());
        dto.setInactivateFlag(0);
    }

    protected void setDtoFields(UserPasswordDtoInterface dto) throws MospException {
        BasicNewCardVo vo = (BasicNewCardVo)this.mospParams.getVo();
        dto.setChangeDate(this.getEditActivateDate());
        dto.setUserId(vo.getTxtUserId());
        String initialPassword = this.platform().passwordCheck().getInitialPassword(vo.getTxtUserId());
        dto.setPassword(SeUtility.encrypt((String)SeUtility.encrypt((String)initialPassword)));
    }

    protected HumanDtoInterface registHuman() throws MospException {
        String employeeCode;
        BasicNewCardVo vo = (BasicNewCardVo)this.mospParams.getVo();
        HumanRegistBeanInterface regist = this.platform().humanRegist();
        HumanReferenceBeanInterface reference = this.reference().human();
        HumanDtoInterface oldHoman = reference.getHumanInfoForEmployeeCode(employeeCode = vo.getTxtEmployeeCode(), this.getEditActivateDate());
        if (oldHoman != null) {
            String[] rep = new String[]{PlatformNamingUtility.employeeCode((MospParams)this.mospParams), employeeCode};
            this.mospParams.addErrorMessage("PFW0215", rep);
            return null;
        }
        HumanDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        return dto;
    }

    protected void registEntrance() throws MospException {
        if (this.getEntranceDate() == null) {
            return;
        }
        EntranceRegistBeanInterface regist = this.platform().entranceRegist();
        EntranceDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
    }

    protected void registUser() throws MospException {
        BasicNewCardVo vo = (BasicNewCardVo)this.mospParams.getVo();
        String userId = vo.getTxtUserId();
        if (userId.isEmpty()) {
            return;
        }
        UserMasterReferenceBeanInterface reference = this.reference().user();
        UserMasterDtoInterface oldDto = reference.getUserInfo(userId, this.getEditActivateDate());
        if (oldDto != null) {
            String[] rep = new String[]{this.mospParams.getName("User", new String[]{"Id"}), userId};
            this.mospParams.addErrorMessage("PFW0215", rep);
            return;
        }
        UserMasterRegistBeanInterface regist = this.platform().userMasterRegist();
        UserMasterDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        this.registUserPassword();
    }

    protected void registUserPassword() throws MospException {
        UserPasswordRegistBeanInterface regist = this.platform().userPasswordRegist();
        UserPasswordDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.regist(dto);
    }

    protected void registPost() throws MospException {
        BasicNewCardVo vo = (BasicNewCardVo)this.mospParams.getVo();
        if (!vo.getNeedPost()) {
            return;
        }
        if (vo.getPltPostName().isEmpty()) {
            return;
        }
        HumanHistoryRegistBeanInterface historyRegist = this.platform().humanHistoryRegist();
        HumanHistoryDtoInterface humanHistoryDto = historyRegist.getInitDto();
        humanHistoryDto.setActivateDate(vo.getTargetDate());
        humanHistoryDto.setPersonalId(vo.getPersonalId());
        humanHistoryDto.setHumanItemType("post");
        humanHistoryDto.setHumanItemValue(vo.getPltPostName());
    }

    protected void registExtra(String personalId) throws MospException {
    }

    public Date getEditActivateDate() {
        BasicNewCardVo vo = (BasicNewCardVo)this.mospParams.getVo();
        return this.getDate(vo.getTxtActivateYear(), vo.getTxtActivateMonth(), vo.getTxtActivateDay());
    }

    protected Date getEntranceDate() {
        BasicNewCardVo vo = (BasicNewCardVo)this.mospParams.getVo();
        return this.getDate(vo.getTxtEntranceYear(), vo.getTxtEntranceMonth(), vo.getTxtEntranceDay());
    }

    protected String getDefaultRole() {
        String roleCode = "";
        for (Map.Entry entry : this.mospParams.getProperties().getRoleProperties().entrySet()) {
            RoleProperty roleProperty = (RoleProperty)entry.getValue();
            if (!roleProperty.isDefault()) continue;
            return roleProperty.getKey();
        }
        return roleCode;
    }

    protected void addExtraJsp(String path) {
        BasicNewCardVo vo = (BasicNewCardVo)this.mospParams.getVo();
        List extraJspList = vo.getExtraJspList();
        extraJspList.add(path);
    }
}

