/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.action;

import java.io.InputStream;
import java.util.Date;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.MospProperties;
import jp.mosp.framework.utils.BinaryUtility;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.TopicPathUtility;
import jp.mosp.platform.bean.human.HumanBinaryArrayRegistBeanInterface;
import jp.mosp.platform.dto.human.HumanBinaryArrayDtoInterface;
import jp.mosp.platform.human.action.HumanInfoAction;
import jp.mosp.platform.human.base.PlatformHumanAction;
import jp.mosp.platform.human.utils.HumanUtility;
import jp.mosp.platform.human.vo.HumanBinaryArrayCardVo;

public class HumanBinaryArrayCardAction
extends PlatformHumanAction {
    public static final String CMD_SET_ACTIVATION_DATE = "PF1561";
    public static final String CMD_SEARCH = "PF1562";
    public static final String CMD_ADD_SELECT = "PF1564";
    public static final String CMD_ADD = "PF1565";
    public static final String CMD_EDIT_SELECT = "PF1566";
    public static final String CMD_DELETE = "PF1567";
    public static final String CMD_UPDATE = "PF1568";
    public static final String CMD_TRANSFER = "PF1569";
    public static final String KEY_VIEW_BINARY_ARRAY = "BinaryArray";
    public static final String PRM_FILE_BINARY_ARRAY = "fileBinaryArray";

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_SELECT)) {
            this.prepareVo(true, false);
            this.addSelect();
        } else if (this.mospParams.getCommand().equals(CMD_ADD)) {
            this.prepareVo();
            this.add();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_SELECT)) {
            this.prepareVo(false, false);
            this.editSelect();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_UPDATE)) {
            this.prepareVo();
            this.update();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else {
            this.throwInvalidCommandException();
        }
        this.setCardCommonInfo();
    }

    private void setActivationDate() throws MospException {
        HumanBinaryArrayCardVo vo = (HumanBinaryArrayCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else if (vo.getModeActivateDate().equals("fixed")) {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
    }

    protected BaseVo getSpecificVo() {
        return new HumanBinaryArrayCardVo();
    }

    private void search() throws MospException {
        this.searchHumanCommonInfo();
        this.setDefaultValues();
    }

    private void addSelect() throws MospException {
        HumanBinaryArrayCardVo vo = (HumanBinaryArrayCardVo)this.mospParams.getVo();
        vo.setDivision(this.getTransferredType());
        TopicPathUtility.setTopicPathName((MospParams)this.mospParams, (String)vo.getClassName(), (String)(this.mospParams.getName(vo.getDivision()) + this.mospParams.getName("Information", new String[]{"Add"})));
        this.setPlatformHumanSettings(CMD_SEARCH, "noActiveDate");
        this.setTargetHumanCommonInfo();
        this.setDefaultValues();
    }

    private void add() throws MospException {
        HumanBinaryArrayCardVo vo = (HumanBinaryArrayCardVo)this.mospParams.getVo();
        Date activeDate = DateUtility.getDate((String)vo.getTxtActivateYear(), (String)vo.getTxtActivateMonth(), (String)vo.getTxtActivateDay());
        this.validate();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        HumanBinaryArrayRegistBeanInterface regist = this.platform().humanBinaryArrayRegist();
        HumanBinaryArrayDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto, activeDate);
        regist.insert(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertMessage();
        this.setBinaryArrayInfo(dto.getHumanRowId());
        vo.setModeCardEdit("edit");
    }

    protected void update() throws MospException {
        HumanBinaryArrayCardVo vo = (HumanBinaryArrayCardVo)this.mospParams.getVo();
        this.validate();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        HumanBinaryArrayRegistBeanInterface regist = this.platform().humanBinaryArrayRegist();
        HumanBinaryArrayDtoInterface oldDto = this.reference().humanBinaryArray().findForKey(vo.getHidRecordId(), false);
        oldDto.setFileType(vo.getPltFileType());
        oldDto.setFileName(vo.getFileBinaryArray());
        oldDto.setFileRemark(vo.getTxtFileRemark());
        regist.update(oldDto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertMessage();
        this.setBinaryArrayInfo(oldDto.getHumanRowId());
    }

    protected void setBinaryArrayInfo(int rowId) throws MospException {
        HumanBinaryArrayCardVo vo = (HumanBinaryArrayCardVo)this.mospParams.getVo();
        HumanBinaryArrayDtoInterface dto = this.reference().humanBinaryArray().findForKey(vo.getPersonalId(), vo.getDivision(), rowId);
        if (dto == null) {
            this.setDefaultValues();
            return;
        }
        this.setVoFields(dto);
    }

    private void editSelect() throws MospException {
        HumanBinaryArrayCardVo vo = (HumanBinaryArrayCardVo)this.mospParams.getVo();
        String division = this.getTransferredType();
        vo.setDivision(division);
        int rowId = this.getTransferredIndex();
        vo.setRowId(rowId);
        TopicPathUtility.setTopicPathName((MospParams)this.mospParams, (String)vo.getClassName(), (String)(this.mospParams.getName(division) + this.mospParams.getName("Information", new String[]{"Edit"})));
        this.setPlatformHumanSettings(CMD_SEARCH, "codeAndName");
        this.setTargetHumanCommonInfo();
        HumanBinaryArrayDtoInterface dto = this.reference().humanBinaryArray().findForKey(vo.getPersonalId(), division, rowId);
        this.setPulldown();
        this.setVoFields(dto);
        vo.setModeActivateDate("fixed");
        vo.setModeCardEdit("edit");
    }

    protected void delete() throws MospException {
        HumanBinaryArrayCardVo vo = (HumanBinaryArrayCardVo)this.mospParams.getVo();
        HumanBinaryArrayRegistBeanInterface regist = this.platform().humanBinaryArrayRegist();
        HumanBinaryArrayDtoInterface dto = this.reference().humanBinaryArray().findForKey(vo.getHidRecordId(), false);
        regist.delete(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteMessage();
        this.setDefaultValues();
    }

    protected void transfer() {
        HumanBinaryArrayCardVo vo = (HumanBinaryArrayCardVo)this.mospParams.getVo();
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(vo.getPersonalId());
        this.setTargetDate(vo.getTargetDate());
        if (actionName.equals(HumanInfoAction.class.getName())) {
            this.mospParams.setNextCommand("PF1121");
        }
    }

    protected void setDefaultValues() throws MospException {
        HumanBinaryArrayCardVo vo = (HumanBinaryArrayCardVo)this.mospParams.getVo();
        vo.setTxtActivateYear("");
        vo.setTxtActivateMonth("");
        vo.setTxtActivateDay("");
        vo.setModeActivateDate("chaning");
        vo.setModeCardEdit("add");
        this.setPulldown();
    }

    private void setPulldown() throws MospException {
        HumanBinaryArrayCardVo vo = (HumanBinaryArrayCardVo)this.mospParams.getVo();
        MospProperties properties = this.mospParams.getProperties();
        String[][] aryBinaryFileType = properties.getCodeArray("BinaryFileType", true);
        vo.setAryPltFileType(aryBinaryFileType);
    }

    protected void setVoFields(HumanBinaryArrayDtoInterface dto) {
        HumanBinaryArrayCardVo vo = (HumanBinaryArrayCardVo)this.mospParams.getVo();
        vo.setHidRecordId(Long.valueOf(dto.getPfaHumanBinaryArrayId()));
        vo.setRowId(dto.getHumanRowId());
        vo.setTxtActivateYear(DateUtility.getStringYear((Date)dto.getActivateDate()));
        vo.setTxtActivateMonth(DateUtility.getStringMonth((Date)dto.getActivateDate()));
        vo.setTxtActivateDay(DateUtility.getStringDay((Date)dto.getActivateDate()));
        vo.setPltFileType(dto.getFileType());
        vo.setFileBinaryArray(dto.getFileName());
        vo.setTxtFileRemark(dto.getFileRemark());
    }

    private void setDtoFields(HumanBinaryArrayDtoInterface dto, Date activeDate) throws MospException {
        byte[] file = BinaryUtility.getBinaryData((InputStream)this.mospParams.getRequestFile(PRM_FILE_BINARY_ARRAY));
        HumanBinaryArrayCardVo vo = (HumanBinaryArrayCardVo)this.mospParams.getVo();
        dto.setPersonalId(vo.getPersonalId());
        dto.setHumanItemType(vo.getDivision());
        dto.setActivateDate(activeDate);
        dto.setHumanItemBinary(file);
        dto.setFileType(HumanUtility.getBinaryFileType((String)vo.getFileBinaryArray()));
        dto.setFileName(vo.getFileBinaryArray());
        dto.setFileRemark(vo.getTxtFileRemark());
    }

    protected void validate() throws MospException {
    }

    public void setCardCommonInfo() {
        HumanBinaryArrayCardVo vo = (HumanBinaryArrayCardVo)this.mospParams.getVo();
        vo.setJsIsReferenceDivision(this.mospParams.getUserRole().getReferenceDivisionsList().contains(this.getTransferredType()));
    }
}

