/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.action;

import java.util.Date;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.exporter.ImageContents;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.HumanBinaryArrayReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanBinaryHistoryReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanBinaryNormalReferenceBeanInterface;
import jp.mosp.platform.dto.human.HumanBinaryArrayDtoInterface;
import jp.mosp.platform.dto.human.HumanBinaryHistoryDtoInterface;
import jp.mosp.platform.dto.human.HumanBinaryNormalDtoInterface;
import jp.mosp.platform.human.base.PlatformHumanAction;
import jp.mosp.platform.human.vo.HumanBinaryArrayCardVo;
import jp.mosp.platform.human.vo.HumanBinaryHistoryCardVo;
import jp.mosp.platform.human.vo.HumanBinaryHistoryListVo;
import jp.mosp.platform.human.vo.HumanBinaryNormalCardVo;
import jp.mosp.platform.human.vo.HumanInfoVo;

public class HumanBinaryOutputImageAction
extends PlatformHumanAction {
    public static final String CMD_NORAML_IMAGE = "PF1591";
    public static final String CMD_HISTORY_IMAGE = "PF1592";
    public static final String CMD_HISTORY_LIST_IMAGE = "PF1593";
    public static final String CMD_ARRAY_IMAGE = "PF1594";

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_NORAML_IMAGE)) {
            this.prepareVo(true, false);
            this.normal();
        } else if (this.mospParams.getCommand().equals(CMD_HISTORY_IMAGE)) {
            this.prepareVo(true, false);
            this.history();
        } else if (this.mospParams.getCommand().equals(CMD_HISTORY_LIST_IMAGE)) {
            this.prepareVo(true, false);
            this.historyList();
        } else if (this.mospParams.getCommand().equals(CMD_ARRAY_IMAGE)) {
            this.prepareVo(true, false);
            this.array();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected BaseVo getSpecificVo() {
        if (this.mospParams.getCommand().equals(CMD_NORAML_IMAGE)) {
            return new HumanBinaryNormalCardVo();
        }
        if (this.mospParams.getCommand().equals(CMD_HISTORY_IMAGE)) {
            return new HumanBinaryHistoryCardVo();
        }
        if (this.mospParams.getCommand().equals(CMD_HISTORY_LIST_IMAGE)) {
            return new HumanBinaryHistoryListVo();
        }
        if (this.mospParams.getCommand().equals(CMD_ARRAY_IMAGE)) {
            return new HumanBinaryArrayCardVo();
        }
        return new HumanInfoVo();
    }

    public void normal() throws MospException {
        HumanBinaryNormalCardVo vo = (HumanBinaryNormalCardVo)this.mospParams.getVo();
        HumanBinaryNormalReferenceBeanInterface binaryNormal = this.reference().humanBinaryNormal();
        HumanBinaryNormalDtoInterface normalDto = binaryNormal.findForInfo(vo.getPersonalId(), vo.getDivision());
        this.mospParams.setFile((Object)new ImageContents(normalDto.getFileType(), normalDto.getHumanItemBinary()));
        this.mospParams.setFileName(normalDto.getFileName());
    }

    public void history() throws MospException {
        HumanBinaryHistoryCardVo vo = (HumanBinaryHistoryCardVo)this.mospParams.getVo();
        HumanBinaryHistoryReferenceBeanInterface binaryHistory = this.reference().humanBinaryHistory();
        String year = this.mospParams.getRequestParam("historyYear");
        String month = this.mospParams.getRequestParam("historyMonth");
        String day = this.mospParams.getRequestParam("historyDay");
        HumanBinaryHistoryDtoInterface historyDto = binaryHistory.findForInfo(vo.getPersonalId(), vo.getDivision(), DateUtility.getDate((String)year, (String)month, (String)day));
        this.mospParams.setFile((Object)new ImageContents(historyDto.getFileType(), historyDto.getHumanItemBinary()));
        this.mospParams.setFileName(historyDto.getFileName());
    }

    public void historyList() throws MospException {
        HumanBinaryHistoryListVo vo = (HumanBinaryHistoryListVo)this.mospParams.getVo();
        Date activeDate = this.getDate(this.getTransferredActivateDate());
        HumanBinaryHistoryReferenceBeanInterface binaryHistory = this.reference().humanBinaryHistory();
        HumanBinaryHistoryDtoInterface historyDto = binaryHistory.findForInfo(vo.getPersonalId(), vo.getDivision(), activeDate);
        this.mospParams.setFile((Object)new ImageContents(historyDto.getFileType(), historyDto.getHumanItemBinary()));
        this.mospParams.setFileName(historyDto.getFileName());
    }

    public void array() throws MospException {
        HumanBinaryArrayCardVo vo = (HumanBinaryArrayCardVo)this.mospParams.getVo();
        int rowId = this.getTransferredIndex();
        HumanBinaryArrayReferenceBeanInterface binaryArray = this.reference().humanBinaryArray();
        HumanBinaryArrayDtoInterface arrayDto = binaryArray.findForKey(vo.getPersonalId(), vo.getDivision(), rowId);
        if (arrayDto == null) {
            return;
        }
        this.mospParams.setFile((Object)new ImageContents(arrayDto.getFileType(), arrayDto.getHumanItemBinary()));
        this.mospParams.setFileName(arrayDto.getFileName());
    }
}

