/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.message.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBeanHandlerInterface;
import jp.mosp.platform.bean.human.HumanNormalReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.bean.mail.MailBeanInterface;
import jp.mosp.platform.bean.message.MessageReferenceBeanInterface;
import jp.mosp.platform.bean.message.MessageRegistBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.HumanNormalDtoInterface;
import jp.mosp.platform.dto.message.MessageDtoInterface;
import jp.mosp.platform.message.vo.MessageCardVo;
import jp.mosp.platform.system.base.PlatformSystemAction;
import jp.mosp.platform.utils.PlatformMessageUtility;

public class MessageCardAction
extends PlatformSystemAction {
    public static final String CMD_SHOW = "PF4120";
    public static final String CMD_SELECT_SHOW = "PF4121";
    public static final String CMD_REGIST = "PF4125";
    public static final String CMD_DELETE = "PF4127";
    public static final String CMD_SET_ACTIVATION_DATE = "PF4170";
    public static final String CMD_INSERT_MODE = "PF4171";
    public static final String CMD_REPLICATION_MODE = "PF4174";
    public static final String CMD_SEND_MAIL = "PF4175";

    protected BaseVo getSpecificVo() {
        return new MessageCardVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.selectShow();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_REPLICATION_MODE)) {
            this.prepareVo();
            this.replicationMode();
        } else if (this.mospParams.getCommand().equals(CMD_SEND_MAIL)) {
            this.prepareVo();
            this.sendMail();
        }
    }

    protected void show() throws MospException {
        this.insertMode();
    }

    protected void selectShow() throws MospException {
        this.editMode();
    }

    protected void regist() throws MospException {
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        PlatformBeanHandlerInterface platform = this.platform();
        MessageRegistBeanInterface regist = platform.messageRegist();
        MessageDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertNewMessage();
        this.setEditUpdateMode(dto.getMessageNo());
    }

    protected void update() throws MospException {
        PlatformBeanHandlerInterface platform = this.platform();
        MessageRegistBeanInterface regist = platform.messageRegist();
        MessageDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.update(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.setEditUpdateMode(dto.getMessageNo());
    }

    protected void delete() throws MospException {
        PlatformBeanHandlerInterface platform = this.platform();
        MessageRegistBeanInterface regist = platform.messageRegist();
        MessageDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.delete(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteMessage();
        this.insertMode();
    }

    protected void setActivationDate() throws MospException {
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
    }

    protected void insertMode() throws MospException {
        this.setEditInsertMode();
        this.setDefaultValues();
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        vo.setModeActivateDate("chaning");
        this.setPulldown();
    }

    protected void editMode() throws MospException {
        this.setEditUpdateMode(this.getTransferredCode());
    }

    protected void setEditUpdateMode(String messageNo) throws MospException {
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        MessageReferenceBeanInterface reference = this.reference().message();
        MessageDtoInterface dto = reference.findForKey(messageNo);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        vo.setModeActivateDate("fixed");
        this.setPulldown();
        this.setEditUpdateMode(new ArrayList());
    }

    protected void replicationMode() {
        this.setEditReplicationMode();
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        vo.setLblMessageNo("");
    }

    protected void sendMail() throws MospException {
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        MessageReferenceBeanInterface message = this.reference().message();
        MailBeanInterface mail = this.platform().mail();
        MessageDtoInterface dto = message.findForKey(vo.getLblMessageNo());
        String[][] aryPersonalIds = this.getMailAddressArray(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addSendMailFailedMessage();
            return;
        }
        if (aryPersonalIds.length <= 0) {
            this.addSendMailFailedMessage();
            this.mospParams.addErrorMessage("PFI0102", new String[0]);
            return;
        }
        if (!mail.canUseMailServer()) {
            this.addSendMailFailedMessage();
            this.mospParams.addErrorMessage("PFW0220", new String[]{this.mospParams.getName("Set")});
            return;
        }
        int count = 0;
        for (String[] strings : aryPersonalIds) {
            if (!mail.sendMail((String[][])new String[][]{strings}, dto.getMessageTitle(), dto.getMessageBody(), null)) continue;
            ++count;
        }
        if (count > 0) {
            this.addSendMailMessage(count);
            return;
        }
        this.addSendMailFailedMessage();
    }

    protected String[][] getMailAddressArray(MessageDtoInterface dto) throws MospException {
        HumanReferenceBeanInterface human = this.reference().human();
        HumanSearchBeanInterface humanSearch = this.reference().humanSearch();
        Date startDate = this.getEditActivateDate();
        int applicationType = dto.getApplicationType();
        if (applicationType == 0) {
            humanSearch.setTargetDate(dto.getStartDate());
            humanSearch.setWorkPlaceCode(dto.getWorkPlaceCode());
            humanSearch.setSectionCode(dto.getSectionCode());
            humanSearch.setPositionCode(dto.getPositionCode());
            humanSearch.setEmploymentContractCode(dto.getEmploymentContractCode());
            humanSearch.setStateType("presence");
            humanSearch.setNeedLowerSection(true);
            humanSearch.setNeedConcurrent(true);
            humanSearch.setOperationType("1");
            List list = humanSearch.search();
            String[][] mailAddressArray = new String[list.size()][2];
            for (int i = 0; i < mailAddressArray.length; ++i) {
                HumanDtoInterface humanDto = (HumanDtoInterface)list.get(i);
                String mailAddress = this.getMailAddress(humanDto.getPersonalId());
                mailAddressArray[i][0] = humanDto.getPersonalId();
                mailAddressArray[i][1] = "";
                if (mailAddress == null || mailAddress.isEmpty()) continue;
                mailAddressArray[i][1] = mailAddress;
            }
            return mailAddressArray;
        }
        if (applicationType == 1) {
            String[] aryPersonalId = dto.getPersonalId().split(",");
            String[][] mailAddressArray = new String[aryPersonalId.length][2];
            for (int i = 0; i < mailAddressArray.length; ++i) {
                String mailAddress = this.getMailAddress(aryPersonalId[i]);
                if (mailAddress == null || mailAddress.isEmpty()) {
                    String employeeCode = "";
                    HumanDtoInterface humanDto = human.getHumanInfo(aryPersonalId[i], startDate);
                    if (humanDto != null) {
                        employeeCode = humanDto.getEmployeeCode();
                    }
                    PlatformMessageUtility.addErrorUnregisteredMailAddress((MospParams)this.mospParams, (Date)startDate, (String)employeeCode);
                    return mailAddressArray;
                }
                mailAddressArray[i][0] = aryPersonalId[i];
                mailAddressArray[i][1] = mailAddress;
            }
            return mailAddressArray;
        }
        return new String[0][0];
    }

    protected String getMailAddress(String personalId) throws MospException {
        String itemName = "mailAddress";
        HumanNormalReferenceBeanInterface humanNormal = this.reference().humanNormal();
        HumanNormalDtoInterface dto = humanNormal.getHumanNormalInfo("mailAddress", personalId);
        if (dto == null) {
            return "";
        }
        return dto.getHumanItemValue();
    }

    protected void setPulldown() throws MospException {
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setAryPltWorkPlace(this.getInputActivateDatePulldown());
            vo.setAryPltEmployment(this.getInputActivateDatePulldown());
            vo.setAryPltSection(this.getInputActivateDatePulldown());
            vo.setAryPltPosition(this.getInputActivateDatePulldown());
            return;
        }
        Date date = this.getEditActivateDate();
        vo.setAryPltWorkPlace(this.reference().workPlace().getCodedSelectArray(date, true, null));
        vo.setAryPltEmployment(this.reference().employmentContract().getCodedSelectArray(date, true, null));
        vo.setAryPltSection(this.reference().section().getCodedSelectArray(date, true, null));
        vo.setAryPltPosition(this.reference().position().getCodedSelectArray(date, true, null));
    }

    public void setDefaultValues() {
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        vo.setTxtEndYear("");
        vo.setTxtEndMonth("");
        vo.setTxtEndDay("");
        vo.setPltMessageType("");
        vo.setPltImportance("");
        vo.setPltWorkPlace("");
        vo.setPltEmployment("");
        vo.setPltSection("");
        vo.setPltPosition("");
        vo.setTxtEmployeeCode("");
        vo.setTxtMessageTitle("");
        vo.setTxtMessage("");
        vo.setLblMessageNo("");
        vo.setLblRegistUser("");
        vo.setLblEmployeeName("");
        vo.setRadApplicationType("0");
    }

    protected void setDtoFields(MessageDtoInterface dto) throws MospException {
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        dto.setPftMessageId(vo.getRecordId());
        dto.setMessageNo(vo.getLblMessageNo());
        dto.setStartDate(this.getEditActivateDate());
        dto.setEndDate(this.getDate(vo.getTxtEndYear(), vo.getTxtEndMonth(), vo.getTxtEndDay()));
        dto.setMessageType(this.getInt(vo.getPltMessageType()));
        dto.setMessageImportance(this.getInt(vo.getPltImportance()));
        dto.setMessageTitle(vo.getTxtMessageTitle());
        dto.setMessageBody(vo.getTxtMessage());
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
        dto.setApplicationType(this.getInt(vo.getRadApplicationType()));
        if (vo.getRadApplicationType().equals("0")) {
            dto.setWorkPlaceCode(vo.getPltWorkPlace());
            dto.setEmploymentContractCode(vo.getPltEmployment());
            dto.setSectionCode(vo.getPltSection());
            dto.setPositionCode(vo.getPltPosition());
            dto.setPersonalId("");
        } else {
            dto.setWorkPlaceCode("");
            dto.setEmploymentContractCode("");
            dto.setSectionCode("");
            dto.setPositionCode("");
            dto.setPersonalId(this.reference().human().getPersonalIds(vo.getTxtEmployeeCode(), this.getEditActivateDate()));
        }
    }

    protected void setVoFields(MessageDtoInterface dto) throws MospException {
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        HumanReferenceBeanInterface human = this.reference().human();
        vo.setRecordId(dto.getPftMessageId());
        vo.setLblMessageNo(dto.getMessageNo());
        vo.setTxtEditActivateYear(this.getStringYear(dto.getStartDate()));
        vo.setTxtEditActivateMonth(this.getStringMonth(dto.getStartDate()));
        vo.setTxtEditActivateDay(this.getStringDay(dto.getStartDate()));
        vo.setTxtEndYear(this.getStringYear(dto.getEndDate()));
        vo.setTxtEndMonth(this.getStringMonth(dto.getEndDate()));
        vo.setTxtEndDay(this.getStringDay(dto.getEndDate()));
        vo.setPltMessageType(String.valueOf(dto.getMessageType()));
        vo.setPltImportance(String.valueOf(dto.getMessageImportance()));
        vo.setTxtMessageTitle(dto.getMessageTitle());
        vo.setTxtMessage(dto.getMessageBody());
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
        vo.setRadApplicationType(String.valueOf(dto.getApplicationType()));
        vo.setPltWorkPlace(dto.getWorkPlaceCode());
        vo.setPltEmployment(dto.getEmploymentContractCode());
        vo.setPltSection(dto.getSectionCode());
        vo.setPltPosition(dto.getPositionCode());
        vo.setTxtEmployeeCode(human.getEmployeeCodes(dto.getPersonalId(), dto.getStartDate()));
        vo.setLblEmployeeName(human.getHumanNames(dto.getPersonalId(), dto.getStartDate()));
        vo.setLblRegistUser(this.getInsertUserName((BaseDtoInterface)dto));
    }

    protected void addSendMailMessage(int count) {
        StringBuffer sb = new StringBuffer();
        sb.append(count);
        sb.append(this.mospParams.getName("Count", new String[]{"SendMail"}));
        this.mospParams.addMessage("PFI0001", new String[]{sb.toString()});
    }
}

