/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.message.action;

import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.bean.message.MessageSearchBeanInterface;
import jp.mosp.platform.comparator.message.MessageNoComparator;
import jp.mosp.platform.dto.message.MessageDtoInterface;
import jp.mosp.platform.message.vo.MessageListVo;
import jp.mosp.platform.system.base.PlatformSystemAction;

public class MessageListAction
extends PlatformSystemAction {
    public static final String CMD_SHOW = "PF4110";
    public static final String CMD_SEARCH = "PF4112";
    public static final String CMD_RE_SEARCH = "PF4113";
    public static final String CMD_SORT = "PF4118";
    public static final String CMD_PAGE = "PF4119";

    public MessageListAction() {
        this.topicPathCommand = CMD_RE_SEARCH;
    }

    protected BaseVo getSpecificVo() {
        return new MessageListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        }
    }

    protected void show() throws MospException {
        MessageListVo vo = (MessageListVo)this.mospParams.getVo();
        this.initPlatformSystemVoFields();
        vo.setTxtSearchMessageNo("");
        vo.setPltSearchMessageType("");
        vo.setTxtSearchMessageTitle("");
        vo.setTxtSearchEmployeeName("");
        vo.setPltSearchImportance("");
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(MessageNoComparator.class.getName());
    }

    protected void search() throws MospException {
        MessageListVo vo = (MessageListVo)this.mospParams.getVo();
        MessageSearchBeanInterface search = this.reference().messageSearch();
        search.setTargetYear(this.getInt(vo.getTxtSearchActivateYear()));
        search.setTargetMonth(this.getInt(vo.getTxtSearchActivateMonth()));
        search.setMessageNo(vo.getTxtSearchMessageNo());
        search.setMessageType(vo.getPltSearchMessageType());
        search.setMessageTitle(vo.getTxtSearchMessageTitle());
        search.setEmployeeName(vo.getTxtSearchEmployeeName());
        search.setMessageImportance(vo.getPltSearchImportance());
        search.setInactivateFlag(vo.getPltSearchInactivate());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(MessageNoComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        this.initCkbSelect();
        if (list.size() == 0) {
            this.addNoSearchResultMessage();
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        MessageListVo vo = (MessageListVo)this.mospParams.getVo();
        String[] aryLblStartDate = new String[list.size()];
        String[] aryLblEndDate = new String[list.size()];
        String[] aryLblMessageNo = new String[list.size()];
        String[] aryLblMessageType = new String[list.size()];
        String[] aryLblMessageTitle = new String[list.size()];
        String[] aryLblEmployeeName = new String[list.size()];
        String[] aryLblImportance = new String[list.size()];
        String[] aryLblInactivate = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            MessageDtoInterface dto = (MessageDtoInterface)list.get(i);
            aryLblStartDate[i] = this.getStringDateAndDay(dto.getStartDate());
            aryLblEndDate[i] = this.getStringDateAndDay(dto.getEndDate());
            aryLblMessageNo[i] = dto.getMessageNo();
            aryLblMessageType[i] = this.getCodeName(dto.getMessageType(), "MessageType");
            aryLblMessageTitle[i] = dto.getMessageTitle();
            aryLblEmployeeName[i] = this.getInsertUserName((BaseDtoInterface)dto);
            aryLblImportance[i] = this.getCodeName(dto.getMessageImportance(), "MessageImportance");
            aryLblInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
        }
        vo.setAryLblStartDate(aryLblStartDate);
        vo.setAryLblEndDate(aryLblEndDate);
        vo.setAryLblMessageNo(aryLblMessageNo);
        vo.setAryLblMessageType(aryLblMessageType);
        vo.setAryLblMessageTitle(aryLblMessageTitle);
        vo.setAryLblEmployeeName(aryLblEmployeeName);
        vo.setAryLblImportance(aryLblImportance);
        vo.setAryLblInactivate(aryLblInactivate);
    }
}

